% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineByEitherFactor.R
\name{combineByEitherFactor}
\alias{combineByEitherFactor}
\title{Create factor-like column regrouping data regrouping simultaneaously by two factors}
\usage{
combineByEitherFactor(
  mat,
  refC1,
  refC2,
  nByGrp = FALSE,
  convergeMax = TRUE,
  callFrom = NULL,
  silent = FALSE
)
}
\arguments{
\item{mat}{input matrix}

\item{refC1}{(integer) column-number of 'mat' to use as 1st set}

\item{refC2}{(integer) column-number of 'mat' to use as 2nd set}

\item{nByGrp}{(logical) add last col with n by group}

\item{convergeMax}{(logical) if TRUE, run 2 add'l iteartive steps to search convergence to stable result}

\item{callFrom}{(character) allows easier tracking of message(s) produced}

\item{silent}{(logical) suppres messages}
}
\value{
matrix containing both selected columns plus additional column(s) indicating group-number of the pair-wise combination 
(and optional the total n by group)
}
\description{
This function aims to address the situation when two somehow different groupins (of the same data) exist and need to be joined.
It is not necessary that both alternative groupings use the same labels, neither.
\code{combineByEitherFactor} adds new (last) column named 'grp' to input matrix representing the combined factor 
relative to 2 specified columns from input matrix 'mat' (via 'refC1','refC2'). Optionally, the output may be 
sorted and a column giving n per factor-level may be added. 
The function treats selected columns of 'mat' 
as pairwise combination of 2 elements (that may occur multiple times over all lines of 'mat')
and sorts/organizes all instances of such combined elements (ie from both selected columns) as repeats of a given group,
who's class number is given in output column 'grp', the (total) number of repeats may be displayed in column 'nGrp' (nByGrp=TRUE).
If groups are overlapping (after re-ordering), an iterative process of max 3x2 passes will be launched after initial matching.
Works on numeric as well as character input.
}
\examples{
nn <- rep(c("a","e","b","c","d","g","f"),c(3,1,2,2,1,2,1))
qq <- rep(c("m","n","p","o","q"),c(2,1,1,4,4))
nq <- cbind(nn,qq)[c(4,2,9,11,6,10,7,3,5,1,12,8),]
combineByEitherFactor(nq,1,2,nBy=TRUE); combineByEitherFactor(nq,1,2,nBy=FALSE)
combineByEitherFactor(nq,1,2,conv=FALSE); combineByEitherFactor(nq,1,2,conv=TRUE)
##
mm <- rep(c("a","b","c","d","e"),c(3,4,2,3,1)); pp <- rep(c("m","n","o","p","q"),c(2,2,2,2,5))
combineByEitherFactor(cbind(mm,pp),1,2,con=FALSE,nBy=TRUE);
combineByEitherFactor(cbind(mm,pp),1,2,con=TRUE,nBy=TRUE) 
}
