\name{sfbay}
\Rdversion{1.1}
\alias{sfbay}
\alias{sfbayStns}
\alias{sfbayVars}
\alias{sfbayChla}
\docType{data}
\title{
San Francisco Bay water quality data
}
\description{
Selected observations and variables from U.S. Geological Survey water quality stations in south San Francisco Bay. Data include \acronym{CTD} and nutrient measurements.
}
\usage{
sfbay
}
\format{
\code{sfbay} is a data frame with 23207 observations (rows) of 12 variables (columns):

\tabular{rll}{
	 \code{[, 1]} \tab \code{date} \tab date\cr
	 \code{[, 2]} \tab \code{time} \tab time\cr
	 \code{[, 3]} \tab \code{stn} \tab station code\cr
	 \code{[, 4]} \tab \code{depth} \tab measurement depth\cr
	 \code{[, 5]} \tab \code{chl} \tab chlorophyll \emph{a}\cr
	 \code{[, 6]} \tab \code{dox.pct} \tab dissolved oxygen\cr
	 \code{[, 7]} \tab \code{spm} \tab suspended particulate matter\cr
	 \code{[, 8]} \tab \code{ext} \tab extinction coefficient\cr
	 \code{[, 9]} \tab \code{sal} \tab salinity\cr
	 \code{[, 10]} \tab \code{temp} \tab water temperature\cr
	 \code{[, 11]} \tab \code{nox} \tab nitrate + nitrite\cr
	 \code{[, 12]} \tab \code{nhx} \tab ammonium\cr
}

\code{sfbayStns} is a data frame with 16 observations of 6 variables:

\tabular{rll}{
	 \code{[, 1]} \tab \code{site} \tab station code\cr
	 \code{[, 2]} \tab \code{description} \tab station description\cr
	 \code{[, 3]} \tab \code{lat} \tab latitude\cr
	 \code{[, 4]} \tab \code{long} \tab longitude\cr
	 \code{[, 5]} \tab \code{depthMax} \tab maximum depth, in m\cr
	 \code{[, 6]} \tab \code{distFrom36} \tab distance from station 36, in km\cr
}

\code{sfbayVars} is a data frame with 7 observations of 3 variables:

\tabular{rll}{
	 \code{[, 1]} \tab \code{variable} \tab water quality variable code\cr
	 \code{[, 2]} \tab \code{description} \tab description\cr
	 \code{[, 3]} \tab \code{units} \tab measurement units\cr
}

\code{sfbayChla} is a time series matrix (380 months \code{x} 16 stations) of average 0-5 m chlorophyll \emph{a} concentrations calculated from the data in \code{sfbay}.

}
\details{
The original downloaded dataset was modified by taking a subset of six well-sampled stations and the period 1985--2004. Variable names were also simplified. The data frames \code{sfbayStns} and \code{sfbayVars} describe the stations and water quality variables in more detail; they were created from information at the same web site. Note that the station numbers in \code{sfbayStns} have been prefixed with \code{s} to make station codes into legal \R variable names. \code{sfbayChla} was constructed from the entire downloaded sfbay dataset and encompasses the period 1969--2009.
}
\source{
	Downloaded from \url{http://sfbay.wr.usgs.gov/access/wqdata} on 2009-11-17.
}
\examples{
data(sfbay)
str(sfbay)
str(sfbayStns)
str(sfbayVars)
plot(sfbayChla[, 1:10], main = "SF Bay Chl-a")
}
\keyword{datasets}