% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workpatterns_classify_pav.R
\name{workpatterns_classify_pav}
\alias{workpatterns_classify_pav}
\title{Classify working pattern personas using a rule based algorithm, using
the person-average volume-based ('pav') method.}
\usage{
workpatterns_classify_pav(
  data,
  values = "percent",
  signals = c("email", "IM"),
  start_hour = "0900",
  end_hour = "1700",
  return = "plot"
)
}
\arguments{
\item{data}{A data frame containing data from the Hourly Collaboration query.}

\item{values}{Character vector to specify whether to return percentages
or absolute values in "data" and "plot". Valid values are:
\itemize{
\item "percent": percentage of signals divided by total signals (default)
\item "abs": absolute count of signals
}}

\item{signals}{Character vector to specify which collaboration metrics to use:
\itemize{
\item "email" (default) for emails only
\item "IM" for Teams messages only,
\item "unscheduled_calls" for Unscheduled Calls only
\item "meetings" for Meetings only
\item or a combination of signals, such as \code{c("email", "IM")}
}}

\item{start_hour}{A character vector specifying starting hours,
e.g. "0900"}

\item{end_hour}{A character vector specifying starting hours,
e.g. "1700"}

\item{return}{Character vector to specify what to return. Valid options include:
\itemize{
\item \code{"plot"}: returns a bar plot of signal distribution by hour and archetypes (default)
\item \code{"data"}: returns the raw data with the classified archetypes
\item \code{"table"}: returns a summary table of the archetypes
\item \code{"plot-area"}: returns an overlapping area plot
}}
}
\value{
A different output is returned depending on the value passed to the \code{return}
argument:
\itemize{
\item \code{"plot"}: returns a bar plot of signal distribution by hour and
archetypes (default). A 'ggplot' object.
\item \code{"data"}: returns a data frame of the raw data with the classified archetypes.
\item \code{"table"}: returns a data frame of a summary table of the archetypes.
\item \code{"plot-area"}: returns an overlapping area plot. A 'ggplot' object.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Apply a rule based algorithm to emails or instant messages sent by hour of day.
This uses a person-average volume-based ('pav') method.
}
\seealso{
Other Working Patterns: 
\code{\link{flex_index}()},
\code{\link{identify_shifts}()},
\code{\link{identify_shifts_wp}()},
\code{\link{plot_flex_index}()},
\code{\link{workpatterns_area}()},
\code{\link{workpatterns_classify}()},
\code{\link{workpatterns_classify_bw}()},
\code{\link{workpatterns_hclust}()},
\code{\link{workpatterns_rank}()},
\code{\link{workpatterns_report}()}
}
\author{
Ainize Cidoncha \href{mailto:ainize.cidoncha@microsoft.com}{ainize.cidoncha@microsoft.com}
}
\concept{Working Patterns}
