% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{write_wos_data}
\alias{write_wos_data}
\title{Write WoS data}
\usage{
write_wos_data(wos_data, dir)
}
\arguments{
\item{wos_data}{An object of class \code{wos_data}, created by calling
\code{\link{pull_wos}}.}

\item{dir}{Path to the directory where you want to write the files.}
}
\value{
Nothing. Files are written to disk.
}
\description{
Writes each of the data frames in an object of class \code{wos_data} to its
own csv file. Each file will be named after the name of the data frame.
}
\examples{
\dontrun{

sid <- auth("your_username", password = "your_password")
wos_data <- pull_wos("TS = (dog welfare) AND PY = 2010", sid = sid)

# Write files to working directory
write_wos_data(wos_data, ".")

# Write files to "wos-data" dir
dir.create("wos-data")
write_wos_data(wos_data, "wos-data")
}
}
