% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word2vec.R
\name{word2vec}
\alias{word2vec}
\title{Word2vec model}
\usage{
word2vec(
  x,
  dim = 50,
  type = c("cbow", "skip-gram"),
  min_count = 5L,
  window = ifelse(type == "cbow", 5L, 10L),
  iter = 10L,
  alpha = 0.05,
  use_ns = TRUE,
  ns_size = 5L,
  sample = 0.001,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{a \link[quanteda:tokens]{quanteda::tokens} object.}

\item{dim}{the size of the word vectors.}

\item{type}{the architecture of the model; either "cbow" (continuous back of words) or "skip-gram".}

\item{min_count}{the minimum frequency of the words. Words less frequent than
this in \code{x} are removed before training.}

\item{window}{the size of the word window. Words within this window are considered
to be the context of a target word.}

\item{iter}{the number of iterations in model training.}

\item{alpha}{the initial learning rate.}

\item{use_ns}{if \code{TRUE}, negative sampling is used. Otherwise, hierarchical softmax
is used.}

\item{ns_size}{the size of negative samples. Only used when \code{use_ns = TRUE}.}

\item{sample}{the rate of sampling of words based on their frequency. Sampling is
disabled when \code{sample = 1.0}}

\item{verbose}{if \code{TRUE}, print the progress of training.}

\item{...}{additional arguments.}
}
\value{
Returns a textmodel_wordvector object with the following elements:
\item{vectors}{a matrix for word vectors.}
\item{dim}{the size of the word vectors.}
\item{type}{the architecture of the model.}
\item{frequency}{the frequency of words in \code{x}.}
\item{window}{the size of the word window.}
\item{iter}{the number of iterations in model training.}
\item{alpha}{the initial learning rate.}
\item{use_ns}{the use of negative sampling.}
\item{ns_size}{the size of negative samples.}
\item{concatenator}{the concatenator in \code{x}.}
\item{call}{the command used to execute the function.}
\item{version}{the version of the wordvector package.}
}
\description{
Train a Word2vec model (Mikolov et al., 2023) in different architectures on a \link[quanteda:tokens]{quanteda::tokens} object.
}
\details{
User can changed the number of processors used for the parallel computing via
\code{options(wordvector_threads)}.
}
\examples{
\donttest{
library(quanteda)
library(wordvector)

# pre-processing
corp <- data_corpus_news2014 
toks <- tokens(corp, remove_punct = TRUE, remove_symbols = TRUE) \%>\% 
   tokens_remove(stopwords("en", "marimo"), padding = TRUE) \%>\% 
   tokens_select("^[a-zA-Z-]+$", valuetype = "regex", case_insensitive = FALSE,
                 padding = TRUE) \%>\% 
   tokens_tolower()

# train word2vec
w2v <- word2vec(toks, dim = 50, type = "cbow", min_count = 5, sample = 0.001)
head(similarity(w2v, c("berlin", "germany", "france"), mode = "word"))
analogy(w2v, ~ berlin - germany + france)
}
}
\references{
Mikolov, T., Sutskever, I., Chen, K., Corrado, G., & Dean, J. (2013).
Distributed Representations of Words and Phrases and their Compositionality.
https://arxiv.org/abs/1310.4546.
}
