% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcAC.R
\name{calcAC}
\alias{calcAC}
\title{Calculate the area correction value(s) with confidence intervals}
\usage{
calcAC(
  distribution,
  paramVec,
  varcovVec = NULL,
  proportionSearchDF,
  distanceCol,
  proportionCol,
  additionalCol = NULL,
  nBoot = NULL,
  truncBounds = NULL,
  ciLevel = 0.9,
  randomSeed = NULL,
  ...
)
}
\arguments{
\item{distribution}{Character indicating the distribution, passed to
\code{\link{getDistanceProbability}}.}

\item{paramVec}{Numeric vector for the parameters associated with distribution. Assumed to be in the same order as the function indicated by \code{distribution}.}

\item{varcovVec}{Numeric vector for the variances and covariances for
\code{paramVec}, default is NULL, see details.}

\item{proportionSearchDF}{Data frame with at least two columns: distance of the outer edge of an annulus from
turbine and proportion of area searched within each annulus.}

\item{distanceCol}{Character indicating the column name for the distance from
turbine}

\item{proportionCol}{Character indicating the column name for the proportion of
area searched.}

\item{additionalCol}{Character vector, default is NULL, indicating additional
columns of how the area correction value should be calculated, see details and examples.}

\item{nBoot}{Integer, indicating the number of parametric
bootstrap replicates to use. Default is NULL, and not confidence intervals are produced.}

\item{truncBounds}{Numeric, indicating bounds for the area
correction calculation, see details. Default is NULL, and the bounds are set to \code{c(0,Inf)}.}

\item{ciLevel}{Numeric, default is 0.9, desired confidence level for the
bootstrap confidence interval.}

\item{randomSeed}{Numeric value of random seed, default is NULL.}

\item{...}{Additional arguments passed to \code{\link{getDistanceProbability}} and \code{rmvnorm} (see \code{\link[mvtnorm]{Mvnorm}}).}
}
\value{
\code{windAC} object
}
\description{
Use a fitted carcass density distribution and data describing the search area to calculate area correction values and confidence intervals using a
  parametric bootstrap approach.
}
\details{
The function \code{\link{getDistanceProbability}} is used to calculate
  the probability (fraction of carcasses) in the intervals between distances in \code{proportionSearchDF}.

  The \code{truncBounds} argument defaults to zero as a lower bound and infinity
  as the upper bound. If a single value is provided, it is assumed as the upper
  bound with zero as the lower bound. If two or more values are provided, the
  \code{max(truncBounds)} is the upper bound and \code{min(truncBounds)} is the
  lower bound.

  If \code{varcovVec} is NULL, then parametric bootstrapping is impossible and a confidence interval is not estimated. The
  \code{varcovVec} should be in such an order that correctly fills the lower
  triangle including the diagonal. The first column is filled, then the second,
  and so on. This forms the variance-covariance matrix for the parameters.

  If \code{nBoot} is greater than zero, a parametric bootstrap is done.
  Bootstrap parameters are generated using the \code{rmvnorm}
  function.

If the additionalCol argument is not NULL, separate area corrections are estimated for each unique value within the column.
}
\examples{

## proportion of area searched data
data(proportionAreaSearched)

## no parametric bootstrap
noBootstrap <- calcAC(distribution = 'gamma',
                      paramVec = c(2.483323, 0.02495139),
                      varcovVec = NULL,
                      proportionSearchDF = proportionAreaSearched,
                      distanceCol = 'distanceFromTurbine',
                      proportionCol = 'proportionAreaSearched',
                      additionalCol = 'plotType')

## with a parametric bootstrap

withBootstrap <- calcAC(distribution = 'gamma',
                        paramVec = c(2.483323, 0.02495139),
                        varcovVec = c(0.041189428, 0.0008825275, 2.118081e-05),
                        proportionSearchDF = proportionAreaSearched,
                        distanceCol = 'distanceFromTurbine',
                        proportionCol = 'proportionAreaSearched',
                        additionalCol = 'plotType',
                        nBoot = 10)

}
\seealso{
\code{\link{weightedLikelihood}} \code{\link{weightedDistribution}} \code{\link{getDistanceProbability}}
}
