% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{Wikimedia_person_exists}
\alias{Wikimedia_person_exists}
\title{Wikimedia_person_exists
Use Wikimedia_query and Wikidata_sparql_query to check if a article of a person
exists in the Wikimedia project. If exists, also return the Wikipedia pages of
that person in the languages indicated in param lang}
\usage{
Wikimedia_person_exists(
  article,
  project = "en.wikipedia.org",
  langs = "en|es|fr|de|it|pt|ca"
)
}
\arguments{
\item{article}{Article to search}

\item{project}{Wikimedia project, defaults "en.wikipedia.org"}

\item{langs}{Wikipedia languages to search if the person has a page, use "|" to split languages}
}
\value{
If the article of the person exists, a vector with four elements: the firts one set to 1, the second de article label normalized, the third de Wikidata id, and fourth a data frame with URL to Wikipedias (lang, label, URL)
If the article of the person does not exist, the firts element is set to 0 and the third is the explication of error.
}
\description{
Wikimedia_person_exists
Use Wikimedia_query and Wikidata_sparql_query to check if a article of a person
exists in the Wikimedia project. If exists, also return the Wikipedia pages of
that person in the languages indicated in param lang
}
\author{
Angel F. Zazo, Departament of Computer Science and Automatics, University of Salamanca
}
