% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terrain_analysis.R
\name{wbt_dem_void_filling}
\alias{wbt_dem_void_filling}
\title{Dem void filling}
\usage{
wbt_dem_void_filling(
  dem,
  fill,
  output,
  mean_plane_dist = 20,
  edge_treatment = "use DEM",
  weight_value = 2,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{dem}{Name of the input raster DEM file, containing the void areas.}

\item{fill}{Name of the input fill DEM file, containing the values used to fill the void areas in the other DEM.}

\item{output}{Name of the output void-filled DEM file.}

\item{mean_plane_dist}{Distance to void edge at which the mean-plane value is used as an offset, measured in grid cells.}

\item{edge_treatment}{How should void-edge cells be treated? Options include 'use DEM' (default), 'use Fill', 'average'.}

\item{weight_value}{Weight value used for IDW interpolation (default is 2.0).}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
This tool can be used to fill the void areas of a DEM using another fill DEM data set.
}
\keyword{GeomorphometricAnalysis}
