% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terrain_analysis.R
\name{wbt_multiscale_curvatures}
\alias{wbt_multiscale_curvatures}
\title{Multiscale curvatures}
\usage{
wbt_multiscale_curvatures(
  dem,
  out_mag,
  curv_type = "ProfileCurv",
  out_scale = NULL,
  min_scale = 0,
  step = 1,
  num_steps = 1,
  step_nonlinearity = 1,
  log = TRUE,
  standardize = FALSE,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{dem}{Name of the input raster DEM file.}

\item{out_mag}{Output raster magnitude file.}

\item{curv_type}{Curvature type.}

\item{out_scale}{Output raster scale file.}

\item{min_scale}{Minimum search neighbourhood radius in grid cells.}

\item{step}{Step size as any positive non-zero integer.}

\item{num_steps}{Number of steps.}

\item{step_nonlinearity}{Step nonlinearity factor (1.0-2.0 is typical).}

\item{log}{Display output values using a log-scale.}

\item{standardize}{Should each scale be standardized to z-scores?.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
This tool calculates several multiscale curvatures and curvature-based indices from an input DEM.
}
\keyword{GeomorphometricAnalysis}
