% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream_network_analysis.R
\name{wbt_extract_streams}
\alias{wbt_extract_streams}
\title{Extract streams}
\usage{
wbt_extract_streams(
  flow_accum,
  output,
  threshold,
  zero_background = FALSE,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{flow_accum}{Input raster D8 flow accumulation file.}

\item{output}{Output raster file.}

\item{threshold}{Threshold in flow accumulation values for channelization.}

\item{zero_background}{Flag indicating whether a background value of zero should be used.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Extracts stream grid cells from a flow accumulation raster.
}
\keyword{StreamNetworkAnalysis}
