% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terrain_analysis.R
\name{wbt_assess_route}
\alias{wbt_assess_route}
\title{Assess route}
\usage{
wbt_assess_route(
  routes,
  dem,
  output,
  length = "",
  dist = 20,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{routes}{Name of the input routes vector file.}

\item{dem}{Name of the input DEM raster file.}

\item{output}{Name of the output lines shapefile.}

\item{length}{Maximum segment length (m).}

\item{dist}{Search distance, in grid cells, used in visibility analysis.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
This tool assesses a route for slope, elevation, and visibility variation.
}
\keyword{GeomorphometricAnalysis}
