% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terrain_analysis.R
\name{wbt_topographic_position_animation}
\alias{wbt_topographic_position_animation}
\title{Topographic position animation}
\usage{
wbt_topographic_position_animation(
  input,
  output,
  palette = "bl_yl_rd",
  min_scale = 1,
  num_steps = 100,
  step_nonlinearity = 1.5,
  height = 600,
  delay = 250,
  label = "",
  dev_max = FALSE,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE
)
}
\arguments{
\item{input}{Name of the input digital elevation model (DEM) raster file.}

\item{output}{Name of the output HTML file (*.html).}

\item{palette}{Image palette; options are 'bl_yl_rd', 'bl_w_rd', 'purple', 'gn_yl', 'pi_y_g', and 'viridis'.}

\item{min_scale}{Minimum search neighbourhood radius in grid cells.}

\item{num_steps}{Number of steps.}

\item{step_nonlinearity}{Step nonlinearity factor (1.0-2.0 is typical).}

\item{height}{Image height, in pixels.}

\item{delay}{GIF time delay in milliseconds.}

\item{label}{Label text (leave blank for none).}

\item{dev_max}{Do you want to use DEVmax instead of DEV for measuring local topographic position?.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is False, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by WhiteboxTools to determine whether to use compression for output rasters.}
}
\value{
Returns the tool text outputs.
}
\description{
This tool creates an animated GIF of multi-scale local topographic position (elevation deviation).
}
