% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_analysis.R
\name{wbt_edge_contamination}
\alias{wbt_edge_contamination}
\title{Edge contamination}
\usage{
wbt_edge_contamination(
  dem,
  output,
  flow_type = "mfd",
  zfactor = "",
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE
)
}
\arguments{
\item{dem}{Name of the input DEM raster file; must be depressionless.}

\item{output}{Name of the output raster file.}

\item{flow_type}{Flow algorithm type, one of 'd8', 'mfd', or 'dinf'.}

\item{zfactor}{Optional multiplier for when the vertical and horizontal units are not the same.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is False, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by WhiteboxTools to determine whether to use compression for output rasters.}
}
\value{
Returns the tool text outputs.
}
\description{
This tool identifies grid cells within an input DEM that may be impacted by edge contamination for hydrological applications.
}
