% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_intervals.R
\name{confint_betabinom}
\alias{confint_betabinom}
\title{Beta Binomial Confidence Bounds for Quantiles and/or Probabilities}
\usage{
confint_betabinom(x, event, loc_sc_params, distribution = c("weibull",
  "lognormal", "loglogistic"), bounds = c("two_sided", "lower", "upper"),
  conf_level = 0.95, direction = c("y", "x"))
}
\arguments{
\item{x}{a numeric vector which consists of lifetime data. \code{x} is used to
specify the range of confidence region(s).}

\item{event}{a vector of binary data (0 or 1) indicating whether unit \emph{i}
is a right censored observation (= 0) or a failure (= 1).}

\item{loc_sc_params}{a (named) numeric vector of estimated location and scale
parameters for a specified distribution. The order of elements is
important. First entry needs to be the location parameter \eqn{\mu} and the
second element needs to be the scale parameter \eqn{\sigma}.}

\item{distribution}{supposed distribution of the random variable. The
value can be \code{"weibull"}, \code{"lognormal"} or \code{"loglogistic"}.
Other distributions have not been implemented yet.}

\item{bounds}{a character string specifying the interval(s) which has/have to
be computed. Must be one of "two_sided" (default), "lower" or "upper".}

\item{conf_level}{confidence level of the interval. The default value is
\code{conf_level = 0.95}.}

\item{direction}{a character string specifying the direction of the computed
interval(s). Must be either "y" (failure probabilities) or "x" (quantiles).}
}
\value{
A data frame containing the lifetime characteristic, interpolated
  ranks as a function of probabilities, the probabilities which are used to
  compute the ranks and computed values for the specified confidence bound(s).
}
\description{
This non-parametric approach calculates confidence bounds for quantiles and/or
failure probabilities using a procedure that is similar to that used in
calculating median ranks. The location-scale parameters estimated by rank
regression are needed.
}
\examples{
obs   <- seq(10000, 100000, 10000)
state <- c(0, 1, 1, 0, 0, 0, 1, 0, 1, 0)

df_john <- johnson_method(x = obs, event = state)
mrr <- rank_regression(x = df_john$characteristic,
                       y = df_john$prob,
                       event = df_john$status,
                       distribution = "weibull",
                       conf_level = .95)
conf_betabin <- confint_betabinom(x = df_john$characteristic,
                                  event = df_john$status,
                                  loc_sc_params = mrr$loc_sc_coefficients,
                                  distribution = "weibull",
                                  bounds = "two_sided",
                                  conf_level = 0.95,
                                  direction = "y")
}
