% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/horiz_eyes.R
\name{horiz_eyes}
\alias{horiz_eyes}
\title{Make eyes horizontal}
\usage{
horiz_eyes(stimuli, left_eye = 0, right_eye = 1, fill = wm_opts("fill"))
}
\arguments{
\item{stimuli}{list of stimuli}

\item{left_eye}{The first point to align (defaults to 0)}

\item{right_eye}{The second point to align (defaults to 1)}

\item{fill}{background color to pass to rotate, see \code{\link[=color_conv]{color_conv()}}}
}
\value{
list of stimuli with rotated tems and/or images
}
\description{
Rotate each stimulus so the eye points are horizontal.
}
\examples{
stimuli <- demo_unstandard(1:3)
horiz_eyes(stimuli, fill = "red")

}
\seealso{
Stimulus manipulation functions
\code{\link{align}()},
\code{\link{crop_tem}()},
\code{\link{crop}()},
\code{\link{greyscale}()},
\code{\link{image_func}()},
\code{\link{mask_oval}()},
\code{\link{mask}()},
\code{\link{mirror}()},
\code{\link{pad}()},
\code{\link{resize}()},
\code{\link{rotate}()},
\code{\link{to_size}()}
}
\concept{manipulators}
