% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stimlist.R
\name{as_stimlist}
\alias{as_stimlist}
\title{Convert list to stimlist}
\usage{
as_stimlist(x)
}
\arguments{
\item{x}{The object}
}
\value{
A stimlist
}
\description{
Checks if an object is a stimulus or list of stimuli and repairs common problems.
}
\details{
Some webmorphR functions, like \code{\link[=plot]{plot()}} and \code{\link[=print]{print()}} require objects to have a "stimlist" class. If you've processed a list of stimuli with iterator functions like \code{\link[=lapply]{lapply()}} or \code{\link[purrr:map]{purrr::map()}} and the resulting object prints or plots oddly, it is probably unclassed, and this function will fix that.
}
\examples{
stimuli <- demo_stim() |>
  lapply(function(stim) {
    # remove template lines
    stim$lines <- NULL
    return(stim)
  })
  
class(stimuli)

\dontrun{
plot(stimuli) # error
}

s <- as_stimlist(stimuli)
class(s)
plot(s)

}
\seealso{
Stimulus creating functions
\code{\link{animate}()},
\code{\link{blank}()},
\code{\link{new_stimlist}()},
\code{\link{new_stim}()},
\code{\link{read_img}()},
\code{\link{read_stim}()},
\code{\link{read_tem}()},
\code{\link{write_stim}()}
}
\concept{stim}
