% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemid.R
\name{ci_query}
\alias{ci_query}
\title{Retrieve information from ChemIDPlus \url{http://chem.sis.nlm.nih.gov/chemidplus}}
\usage{
ci_query(query, type = c("name", "rn", "inchikey"), match = c("best",
  "first", "ask", "na"), verbose = TRUE)
}
\arguments{
\item{query}{character; query string}

\item{type}{character; type of query string.
'rn' for regeistry number or 'name' for common name or 'inchikey' for inchikey as input.}

\item{match}{character; How should multiple hits be handeled?
'first' returns only the first match, 'best' the best matching (by name) ID, 'ask' is a interactive mode and the user is asked for input,
'na' returns NA if multiple hits are found.}

\item{verbose}{logical; should a verbose output be printed on the console?}
}
\value{
A list of 8 entries: name (vector), synonyms (vector), cas (vector),
inchi (vector), inchikey (vector), smiles(vector), toxicity (data.frame),
physprop (data.frame) and source_url.
}
\description{
Retrieve information from ChemIDPlus \url{http://chem.sis.nlm.nih.gov/chemidplus}
}
\note{
The data of the entry \code{pp_query} is identical to the result returned
by \code{\link{pp_query}}.
}
\examples{
\dontrun{
# might fail if API is not available
# query common name
y1 <- ci_query(c('Formaldehyde', 'Triclosan'), type = 'name')
names(y1)
str(y1[['Triclosan']]) # lots of information inside
y1[['Triclosan']]$inchikey

# Query by CAS
y2 <- ci_query('50-00-0', type = 'rn', match = 'first')
y2[['50-00-0']]$inchikey

# query by inchikey
y3 <- ci_query('WSFSSNUMVMOOMR-UHFFFAOYSA-N', type = 'inchikey')
y3[[1]]$name

# extract lop-P
sapply(y1, function(y){
 if (length(y) == 1 && is.na(y))
   return(NA)
 y$physprop$Value[y$physprop$`Physical Property` == 'log P (octanol-water)']
 })
}
}

