% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemid.R
\name{ci_query}
\alias{ci_query}
\title{Retrieve information from ChemIDPlus \url{http://chem.sis.nlm.nih.gov/chemidplus}}
\usage{
ci_query(query, type = c("rn", "name", "inchikey"), mult = c("first",
  "best", "ask", "na"), verbose = TRUE)
}
\arguments{
\item{query}{character; query string}

\item{type}{character; type of query string.
'rn' for regeistry number or 'name' for common name or 'inchikey' for inchikey as input.}

\item{mult}{character; How should multiple hits be handeled?
'first' returns only the first match, 'best' the best matching (by name) ID, 'ask' is a interactive mode and the user is asked for input,
'na' returns NA if multiple hits are found.}

\item{verbose}{logical; should a verbose output be printed on the console?}
}
\value{
A list of 8 entries: name (vector), synonyms (vector), cas (vector),
inchi (vector), inchikey (vector), smiles(vector), toxicity (data.frame),
physprop (data.frame) and source_url.
}
\description{
Retrieve information from ChemIDPlus \url{http://chem.sis.nlm.nih.gov/chemidplus}
}
\note{
The data of the entry \code{physprop} is identical to the result returned
by \code{\link{physprop}}.
}
\examples{
\dontrun{
# might fail if API is not available
# query common name
y1 <- ci_query('Formaldehyde', type = 'name')
str(y1) # lots of information inside
y1$inchikey

# Query by CAS
y2 <- ci_query('50-00-0', type = 'rn')
y2$inchikey

# query by inchikey
y3 <- ci_query('WSFSSNUMVMOOMR-UHFFFAOYSA-N', type = 'inchikey')
y3$name

### handle multiple inputs
 cas <- c('1071-83-6', '50-00-0')
 # extract inchikeys
 sapply(cas, function(x){
   ci_query(x, type = 'rn')$inchikey
 })
}
}

