% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panet_control.R
\name{rpactl.scenario}
\alias{rpactl.scenario}
\title{Set parameters for controlling the probability of edge scenarios}
\usage{
rpactl.scenario(
  alpha = 1,
  beta = 0,
  gamma = 0,
  xi = 0,
  rho = 0,
  beta.loop = TRUE,
  source.first = TRUE
)
}
\arguments{
\item{alpha}{Probability of adding an edge from a new node to an existing
node.}

\item{beta}{Probability of adding an edge between existing nodes.}

\item{gamma}{Probability of adding an edge from an existing node to a new
node.}

\item{xi}{Probability of adding an edge between two new nodes.}

\item{rho}{Probability of adding a new node with a self-loop.}

\item{beta.loop}{Logical, whether self-loops are allowed under beta scenario.
Default value is \code{TRUE}.}

\item{source.first}{Logical. Defined for \code{beta} scenario edges of
directed networks. If \code{TRUE}, the source node of a new edge is sampled
from existing nodes before the target node is sampled; if \code{FALSE}, the
target node is sampled from existing nodes before the source node is
sampled. Default value is \code{TRUE}.}
}
\value{
A list of class \code{rpactl} with components \code{alpha},
  \code{beta}, \code{gamma}, \code{xi}, \code{rho}, \code{beta.loop} and
  \code{source.first} with meanings as explained under 'Arguments'.
}
\description{
Set parameters for controlling the probability of edge scenarios
}
\examples{
control <- rpactl.scenario(alpha = 0.5, beta = 0.5, beta.loop = FALSE)

}
