\name{expand.som}
\alias{expand.som}
\title{Expand a SOM network}
\description{
  Increases the size of a network by a factor of 2 in both
  x and y directions; code vectors for new units are interpolated.
}
\usage{expand.som(somnet, plotit=FALSE)}
\details{
  For hexagonal grids, the six closest units are used for interpolation,
  weighted by distance; for rectangular grids, the four closest are used.
}
\arguments{
  \item{somnet}{Object of class "wccsom", generated by \code{wccsom}.}
  \item{plotit}{If \code{TRUE}, plots the new network with the
  original units coloured white, the new ones red.}
}
\value{
  Returns the new network.
}
\examples{
data(cepha)
gr <- somgrid(3,3, "hexagonal")
set.seed(7)
x <- wccsom(cepha$patterns, grid=gr, trwidth=20, rlen=50)
x2 <- expand.som(x, plotit=TRUE)
}
\keyword{classif}
