% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoPreprocessing.R
\name{DoPreprocessing}
\alias{DoPreprocessing}
\title{Preprocess spectral data according to user-designated method}
\usage{
DoPreprocessing(df, test.data = NULL, preprocessing.method = 1,
  wavelengths = 740:1070)
}
\arguments{
\item{df}{\code{data.frame} object containing spectral data. First column(s)
(optional) include metadata (with or without reference value column)
followed by spectral columns. Spectral column names must be formatted as
"X" followed by wavelength Include no other columns to right of spectra! No
missing values permitted.}

\item{test.data}{\code{data.frame} object with same format as train.data.
Will be appended to \code{df} during preprocessing so that the same
transformations are applied to each row. Default is \code{NULL}.}

\item{preprocessing.method}{Number or list of numbers 1:13 corresponding to
  desired pretreatment method(s):
\itemize{
  \item 1 = raw data (default)
  \item 2 = standard normal variate (SNV)
  \item 3 = SNV and first derivative
  \item 4 = SNV and second derivative
  \item 5 = first derivative
  \item 6 = second derivative
  \item 7 = Savitzky–Golay filter (SG)
  \item 8 = SNV and SG
  \item 9 = gap segment derivative (window size = 11)
  \item 10 = SG and first derivative (window size = 5)
  \item 11 = SG and first derivative (window size = 11)
  \item 12 = SG and second derivative (window size = 5)
  \item 13 = SG and second derivative (window size = 11)
}}

\item{wavelengths}{List of wavelengths represented by each column in
\code{df}. Default is 740:1070.}
}
\value{
Preprocessed \code{df}` (or list of \code{data.frame}s) with
  reference column intact
}
\description{
Preprocessing, also known as pretreatment, is often used to
  increase the signal to noise ratio in vis-NIR datasets. The \emph{waves}
  function \code{DoPreprocessing} applies common spectral preprocessing
  methods such as standard normal variate and the Savitzky-Golay filter.
}
\examples{
DoPreprocessing(df = ikeogu.2017, wavelengths = 350:2500)[1:5,1:5]
}
\author{
Jenna Hershberger \email{jmh579@cornell.edu}
}
