\name{waterfallplot}
\alias{waterfallplot}
\alias{waterfallplot.default}
\title{Waterfall Charts in R using traditional graphics}

\description{Creates a waterfall plot with vertical or horizontal bars.} 

\usage{
waterfallplot(height, ...)

\method{waterfallplot}{default}(height, width=1, space=NULL, names.arg=NULL, horiz=FALSE,
              density=NULL, angle=45, col=NULL, border=par("fg"),
              main=NA, sub=NA, xlab=NULL, ylab=NULL, xlim=NULL,
              ylim=NULL, xpd=TRUE, axes=TRUE, axisnames=TRUE,
              cex.axis=par("cex.axis"), cex.names=par("cex.axis"),
              plot=TRUE, axis.lty=0, offset=0, add = FALSE,
              summary=FALSE, rev=FALSE, ...)
}

\arguments{
  \item{height}{
    a vector of values describing the height of the bars that make up
    the plot.  Matrices are not supported.
  }

  \item{width}{
    optional vector of bar widths.  Re-cycled to length the number of
    bars drawn.  Specifying a single value will have no visible effect
    unless 'xlim' is specified.
  }

  \item{space}{
    the amount of space (as a fraction of the average bar width)
    left before each bar.  May be given as a single number or one number
    per bar.  If not given explicitly, it defaults to 0.2
  }

  \item{names.arg}{
    a vector of names to be plotted below each bar If this argument is
    omitted, then the names are taken from the 'names' attribute of
    'height.'
  }

  \item{horiz}{a logical value.  If 'FALSE', the bars are drawn
    vertically with the first bar to the left.  If 'TRUE', the bars are
    drawn horizontally with the first at the bottom.
  }

  \item{density}{
    a vector giving the density of shading lines, in lines per inch, for
    the bars or bar components. The default value of 'NULL' means that
    no shading lines are drawn. Non-positive   values of 'density' also
    inhibit the drawing of shading lines.
  }

  \item{angle}{
    the slope of shading lines, given as an angle in degrees
    (counter-clockwise), for the bars or bar components.
  }

  \item{col}{
    a vector of colors for the bars or bar components. By default, grey
    is used.
  }

  \item{border}{
    the color to be used for the border of the bars. Use 'border = NA'
    to omit borders.  If there are shading lines, 'border = TRUE' means
    use the same colour for the border as forr the shading lines.
  }

  \item{main,sub}{overall and sub title for the plot.}

  \item{xlab}{a label for the x axis.}

  \item{ylab}{a label for the y axis.}

  \item{xlim}{limits for the x axis.}

  \item{ylim}{limits for the y axis.}

  \item{xpd}{logical. Should bars be allowed to outside region?}

  \item{axes}{
    logical.  If 'TRUE', a vertical (or horizontal, if 'horiz' is true)
    axis is drawn.
  }

  \item{axisnames}{
    logical.  If 'TRUE', and if there are 'names.arg' (see above), the
    other axis is drawn (with 'lty=0') and labeled.
  }

  \item{cex.axis}{expansion factor for numeric axis labels.}

  \item{cex.names}{expansion factor for axis names (bar labels).}

  \item{plot}{logical.  If 'FALSE', nothing is plotted.}

  \item{axis.lty}{
    the graphics parameter 'lty' applied to the axis and tick marks of
    the categorical (default horizontal) axis.  Note that by default the
    axis is suppressed.
  }

  \item{offset}{
    initial offset relative to the x axis.  The value serves as the
    logical starting point for the first column and any summary column.
    Defaults to 0.
  }

  \item{add}{
    logical specifying if bars should be added to an already existing
    plot; defaults to 'FALSE'.
  }

  \item{summary}{
    create a summary column.  A summary column provides a final sum
    column showing the relative change from the offset.  If a summary is
    requested and names.arg is set, the names.arg vector must include
    one extra entry with the summary column's name.  Defaults to FALSE.
  }

  \item{rev}{reverse the order of columns?  Defaults to FALSE.}

  \item{...}{
    arguments to be passed to/from other methods.  For the default
    method these can include further arguments (such as 'axes', 'asp'
    and 'main') and graphical parameters (see 'par') which are passed to
    'plot.window()', 'title()' and 'axis'.
  }

}

\details{
  This function closely mimics the \link{barplot} interface, but
  provides a type of chart called a waterfall plot, showing how multiple
  subvalues contribute to a total sum.
  
  This is a generic function, it currently only has a default method. A
  formula interface may be added eventually.
}

\value{
  A numeric vector say 'mp', giving the coordinates of \emph{all} the
  bar midpoints drawn, useful for adding to the graph.
}

\references{
  James P. Howard, II, FIXME.

  Andrew Jaquith, \emph{Security Metrics: Replacing Fear, Uncertainty,
    and Doubt} (Boston:  Addison-Wesley Professional, 2007), 170-172.
  
  Ethan M. Rasiel, \emph{The McKinsey Way: Using the Techniques of the
    World's Top Strategic Consultants to Help You and Your Business}
  (New York:  McGraw-Hill, 1999), 113-118. 
}

\seealso{
  \code{\link{barplot}}, \code{\link{waterfallchart}}
}

\examples{
data(rasiel)
waterfallplot(rasiel$value, names.arg=rasiel$label)
}

\keyword{hplot}
  
