/*
    walker is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    licence is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with licence.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.19.1

#include <stan/model/model_header.hpp>

namespace model_rw1_model_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_rw1_model");
    reader.add_event(145, 143, "end", "model_rw1_model");
    return reader;
}

template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type
gaussian_filter_rw_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                            const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& a1,
                            const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& P1,
                            const T3__& Ht,
                            const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                            const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& xreg, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 8;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,rows(y));

        current_statement_begin__ = 9;
        int m(0);
        (void) m;  // dummy to suppress unused var warning
        stan::math::fill(m, std::numeric_limits<int>::min());
        stan::math::assign(m,rows(a1));

        current_statement_begin__ = 10;
        local_scalar_t__ loglik(DUMMY_VAR__);
        (void) loglik;  // dummy to suppress unused var warning
        stan::math::initialize(loglik, DUMMY_VAR__);
        stan::math::fill(loglik, DUMMY_VAR__);
        stan::math::assign(loglik,0.0);

        current_statement_begin__ = 12;
        validate_non_negative_index("x", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> x(m);
        stan::math::initialize(x, DUMMY_VAR__);
        stan::math::fill(x, DUMMY_VAR__);
        stan::math::assign(x,a1);

        current_statement_begin__ = 13;
        validate_non_negative_index("P", "m", m);
        validate_non_negative_index("P", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> P(m, m);
        stan::math::initialize(P, DUMMY_VAR__);
        stan::math::fill(P, DUMMY_VAR__);
        stan::math::assign(P,diag_matrix(P1));


        current_statement_begin__ = 14;
        for (int t = 1; t <= n; ++t) {
            {
            current_statement_begin__ = 15;
            local_scalar_t__ F(DUMMY_VAR__);
            (void) F;  // dummy to suppress unused var warning
            stan::math::initialize(F, DUMMY_VAR__);
            stan::math::fill(F, DUMMY_VAR__);
            stan::math::assign(F,(quad_form(P, stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")) + Ht));

            current_statement_begin__ = 16;
            local_scalar_t__ v(DUMMY_VAR__);
            (void) v;  // dummy to suppress unused var warning
            stan::math::initialize(v, DUMMY_VAR__);
            stan::math::fill(v, DUMMY_VAR__);
            stan::math::assign(v,(get_base1(y, t, "y", 1) - dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), x)));

            current_statement_begin__ = 17;
            validate_non_negative_index("K", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> K(m);
            stan::math::initialize(K, DUMMY_VAR__);
            stan::math::fill(K, DUMMY_VAR__);
            stan::math::assign(K,divide(multiply(P, stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")), F));


            current_statement_begin__ = 18;
            stan::math::assign(x, add(x, multiply(K, v)));
            current_statement_begin__ = 19;
            stan::math::assign(P, add(P, add(multiply(multiply(minus(K), transpose(K)), F), Rt)));
            current_statement_begin__ = 20;
            stan::math::assign(loglik, (loglik - (0.5 * (stan::math::log(F) + ((v * v) / F)))));
            }
        }
        current_statement_begin__ = 22;
        return stan::math::promote_scalar<fun_return_scalar_t__>(loglik);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type
gaussian_filter_rw_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                            const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& a1,
                            const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& P1,
                            const T3__& Ht,
                            const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                            const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& xreg, std::ostream* pstream__) {
    return gaussian_filter_rw_lpdf<false>(y,a1,P1,Ht,Rt,xreg, pstream__);
}


struct gaussian_filter_rw_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                            const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& a1,
                            const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& P1,
                            const T3__& Ht,
                            const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                            const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& xreg, std::ostream* pstream__) const {
        return gaussian_filter_rw_lpdf(y, a1, P1, Ht, Rt, xreg, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type, Eigen::Dynamic, Eigen::Dynamic>
gaussian_smoother_rw(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                         const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& a1,
                         const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& P1,
                         const T3__& Ht,
                         const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                         const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& xreg, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 27;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,rows(y));

        current_statement_begin__ = 28;
        int m(0);
        (void) m;  // dummy to suppress unused var warning
        stan::math::fill(m, std::numeric_limits<int>::min());
        stan::math::assign(m,rows(a1));

        current_statement_begin__ = 29;
        validate_non_negative_index("x", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> x(m);
        stan::math::initialize(x, DUMMY_VAR__);
        stan::math::fill(x, DUMMY_VAR__);
        stan::math::assign(x,a1);

        current_statement_begin__ = 30;
        validate_non_negative_index("P", "m", m);
        validate_non_negative_index("P", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> P(m, m);
        stan::math::initialize(P, DUMMY_VAR__);
        stan::math::fill(P, DUMMY_VAR__);
        stan::math::assign(P,diag_matrix(P1));

        current_statement_begin__ = 31;
        validate_non_negative_index("v", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> v(n);
        stan::math::initialize(v, DUMMY_VAR__);
        stan::math::fill(v, DUMMY_VAR__);

        current_statement_begin__ = 32;
        validate_non_negative_index("F", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> F(n);
        stan::math::initialize(F, DUMMY_VAR__);
        stan::math::fill(F, DUMMY_VAR__);

        current_statement_begin__ = 33;
        validate_non_negative_index("K", "m", m);
        validate_non_negative_index("K", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> K(m, n);
        stan::math::initialize(K, DUMMY_VAR__);
        stan::math::fill(K, DUMMY_VAR__);

        current_statement_begin__ = 34;
        validate_non_negative_index("r", "m", m);
        validate_non_negative_index("r", "(n + 1)", (n + 1));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> r(m, (n + 1));
        stan::math::initialize(r, DUMMY_VAR__);
        stan::math::fill(r, DUMMY_VAR__);

        current_statement_begin__ = 35;
        validate_non_negative_index("tmpr", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmpr(m);
        stan::math::initialize(tmpr, DUMMY_VAR__);
        stan::math::fill(tmpr, DUMMY_VAR__);


        current_statement_begin__ = 37;
        for (int t = 1; t <= n; ++t) {

            current_statement_begin__ = 38;
            stan::model::assign(F, 
                        stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                        (quad_form(P, stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")) + Ht), 
                        "assigning variable F");
            current_statement_begin__ = 39;
            stan::model::assign(v, 
                        stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                        (get_base1(y, t, "y", 1) - dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), x)), 
                        "assigning variable v");
            current_statement_begin__ = 40;
            stan::model::assign(K, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                        divide(multiply(P, stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")), get_base1(F, t, "F", 1)), 
                        "assigning variable K");
            current_statement_begin__ = 41;
            stan::math::assign(x, add(x, multiply(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"), get_base1(v, t, "v", 1))));
            current_statement_begin__ = 42;
            stan::math::assign(P, add(P, add(multiply(multiply(minus(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K")), transpose(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"))), get_base1(F, t, "F", 1)), Rt)));
        }
        current_statement_begin__ = 44;
        stan::model::assign(r, 
                    stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((n + 1)), stan::model::nil_index_list())), 
                    rep_vector(0.0, m), 
                    "assigning variable r");
        current_statement_begin__ = 45;
        for (int tt = 1; tt <= n; ++tt) {
            {
            current_statement_begin__ = 46;
            int t(0);
            (void) t;  // dummy to suppress unused var warning
            stan::math::fill(t, std::numeric_limits<int>::min());
            stan::math::assign(t,((n + 1) - tt));

            current_statement_begin__ = 47;
            validate_non_negative_index("tmp", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp(m);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            stan::math::assign(tmp,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), "r"));


            current_statement_begin__ = 48;
            stan::model::assign(r, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                        subtract(add(divide(multiply(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), get_base1(v, t, "v", 1)), get_base1(F, t, "F", 1)), tmp), multiply(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), dot_product(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"), tmp))), 
                        "assigning variable r");
            }
        }
        current_statement_begin__ = 51;
        stan::math::assign(tmpr, stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "r"));
        current_statement_begin__ = 52;
        stan::model::assign(r, 
                    stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    add(a1, elt_multiply(P1, tmpr)), 
                    "assigning variable r");
        current_statement_begin__ = 53;
        for (int t = 2; t <= n; ++t) {
            {
            current_statement_begin__ = 54;
            validate_non_negative_index("tmp", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp(m);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            stan::math::assign(tmp,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::nil_index_list())), "r"));

            current_statement_begin__ = 55;
            validate_non_negative_index("tmp2", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp2(m);
            stan::math::initialize(tmp2, DUMMY_VAR__);
            stan::math::fill(tmp2, DUMMY_VAR__);
            stan::math::assign(tmp2,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "r"));


            current_statement_begin__ = 56;
            stan::model::assign(r, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                        add(tmp, multiply(Rt, tmp2)), 
                        "assigning variable r");
            }
        }
        current_statement_begin__ = 58;
        return stan::math::promote_scalar<fun_return_scalar_t__>(stan::model::rvalue(r, stan::model::cons_list(stan::model::index_min_max(1, m), stan::model::cons_list(stan::model::index_min_max(1, n), stan::model::nil_index_list())), "r"));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct gaussian_smoother_rw_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                         const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& a1,
                         const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& P1,
                         const T3__& Ht,
                         const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                         const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& xreg, std::ostream* pstream__) const {
        return gaussian_smoother_rw(y, a1, P1, Ht, Rt, xreg, pstream__);
    }
};

class model_rw1_model : public prob_grad {
private:
        int k;
        int n;
        matrix_d xreg;
        vector_d y;
        vector_d beta_mean;
        vector_d beta_sd;
        vector_d sigma_mean;
        vector_d sigma_sd;
        int n_new;
        matrix_d xreg_new;
        vector_d sigma_b_mean;
        vector_d sigma_b_sd;
        double sigma_y_mean;
        double sigma_y_sd;
public:
    model_rw1_model(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_rw1_model(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_rw1_model_namespace::model_rw1_model";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            // initialize data block variables from context__
            current_statement_begin__ = 63;
            context__.validate_dims("data initialization", "k", "int", context__.to_vec());
            k = int(0);
            vals_i__ = context__.vals_i("k");
            pos__ = 0;
            k = vals_i__[pos__++];
            check_greater_or_equal(function__, "k", k, 0);

            current_statement_begin__ = 64;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            check_greater_or_equal(function__, "n", n, 0);

            current_statement_begin__ = 65;
            validate_non_negative_index("xreg", "k", k);
            validate_non_negative_index("xreg", "n", n);
            context__.validate_dims("data initialization", "xreg", "matrix_d", context__.to_vec(k,n));
            xreg = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(k, n);
            vals_r__ = context__.vals_r("xreg");
            pos__ = 0;
            size_t xreg_j_2_max__ = n;
            size_t xreg_j_1_max__ = k;
            for (size_t j_2__ = 0; j_2__ < xreg_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < xreg_j_1_max__; ++j_1__) {
                    xreg(j_1__, j_2__) = vals_r__[pos__++];
                }
            }

            current_statement_begin__ = 66;
            validate_non_negative_index("y", "n", n);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(n));
            y = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                y(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 67;
            validate_non_negative_index("beta_mean", "k", k);
            context__.validate_dims("data initialization", "beta_mean", "vector_d", context__.to_vec(k));
            beta_mean = Eigen::Matrix<double, Eigen::Dynamic, 1>(k);
            vals_r__ = context__.vals_r("beta_mean");
            pos__ = 0;
            size_t beta_mean_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < beta_mean_j_1_max__; ++j_1__) {
                beta_mean(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 68;
            validate_non_negative_index("beta_sd", "k", k);
            context__.validate_dims("data initialization", "beta_sd", "vector_d", context__.to_vec(k));
            beta_sd = Eigen::Matrix<double, Eigen::Dynamic, 1>(k);
            vals_r__ = context__.vals_r("beta_sd");
            pos__ = 0;
            size_t beta_sd_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < beta_sd_j_1_max__; ++j_1__) {
                beta_sd(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 69;
            validate_non_negative_index("sigma_mean", "(k + 1)", (k + 1));
            context__.validate_dims("data initialization", "sigma_mean", "vector_d", context__.to_vec((k + 1)));
            sigma_mean = Eigen::Matrix<double, Eigen::Dynamic, 1>((k + 1));
            vals_r__ = context__.vals_r("sigma_mean");
            pos__ = 0;
            size_t sigma_mean_j_1_max__ = (k + 1);
            for (size_t j_1__ = 0; j_1__ < sigma_mean_j_1_max__; ++j_1__) {
                sigma_mean(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 70;
            validate_non_negative_index("sigma_sd", "(k + 1)", (k + 1));
            context__.validate_dims("data initialization", "sigma_sd", "vector_d", context__.to_vec((k + 1)));
            sigma_sd = Eigen::Matrix<double, Eigen::Dynamic, 1>((k + 1));
            vals_r__ = context__.vals_r("sigma_sd");
            pos__ = 0;
            size_t sigma_sd_j_1_max__ = (k + 1);
            for (size_t j_1__ = 0; j_1__ < sigma_sd_j_1_max__; ++j_1__) {
                sigma_sd(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 71;
            context__.validate_dims("data initialization", "n_new", "int", context__.to_vec());
            n_new = int(0);
            vals_i__ = context__.vals_i("n_new");
            pos__ = 0;
            n_new = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_new", n_new, 0);

            current_statement_begin__ = 72;
            validate_non_negative_index("xreg_new", "k", k);
            validate_non_negative_index("xreg_new", "n_new", n_new);
            context__.validate_dims("data initialization", "xreg_new", "matrix_d", context__.to_vec(k,n_new));
            xreg_new = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(k, n_new);
            vals_r__ = context__.vals_r("xreg_new");
            pos__ = 0;
            size_t xreg_new_j_2_max__ = n_new;
            size_t xreg_new_j_1_max__ = k;
            for (size_t j_2__ = 0; j_2__ < xreg_new_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < xreg_new_j_1_max__; ++j_1__) {
                    xreg_new(j_1__, j_2__) = vals_r__[pos__++];
                }
            }


            // initialize transformed data variables
            current_statement_begin__ = 76;
            validate_non_negative_index("sigma_b_mean", "k", k);
            sigma_b_mean = Eigen::Matrix<double, Eigen::Dynamic, 1>(k);
            stan::math::fill(sigma_b_mean, DUMMY_VAR__);
            stan::math::assign(sigma_b_mean,stan::model::rvalue(sigma_mean, stan::model::cons_list(stan::model::index_min(2), stan::model::nil_index_list()), "sigma_mean"));

            current_statement_begin__ = 77;
            validate_non_negative_index("sigma_b_sd", "k", k);
            sigma_b_sd = Eigen::Matrix<double, Eigen::Dynamic, 1>(k);
            stan::math::fill(sigma_b_sd, DUMMY_VAR__);
            stan::math::assign(sigma_b_sd,stan::model::rvalue(sigma_sd, stan::model::cons_list(stan::model::index_min(2), stan::model::nil_index_list()), "sigma_sd"));

            current_statement_begin__ = 78;
            sigma_y_mean = double(0);
            stan::math::fill(sigma_y_mean, DUMMY_VAR__);
            stan::math::assign(sigma_y_mean,get_base1(sigma_mean, 1, "sigma_mean", 1));

            current_statement_begin__ = 79;
            sigma_y_sd = double(0);
            stan::math::fill(sigma_y_sd, DUMMY_VAR__);
            stan::math::assign(sigma_y_sd,get_base1(sigma_sd, 1, "sigma_sd", 1));

            // execute transformed data statements

            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 83;
            validate_non_negative_index("sigma_b", "k", k);
            num_params_r__ += (1 * k);
            current_statement_begin__ = 84;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_rw1_model() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        current_statement_begin__ = 83;
        if (!(context__.contains_r("sigma_b")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_b missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_b");
        pos__ = 0U;
        validate_non_negative_index("sigma_b", "k", k);
        context__.validate_dims("parameter initialization", "sigma_b", "double", context__.to_vec(k));
        std::vector<double> sigma_b(k, double(0));
        size_t sigma_b_k_0_max__ = k;
        for (size_t k_0__ = 0; k_0__ < sigma_b_k_0_max__; ++k_0__) {
            sigma_b[k_0__] = vals_r__[pos__++];
        }
        size_t sigma_b_i_0_max__ = k;
        for (size_t i_0__ = 0; i_0__ < sigma_b_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, sigma_b[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_b: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }

        current_statement_begin__ = 84;
        if (!(context__.contains_r("sigma_y")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_y missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_y");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma_y", "double", context__.to_vec());
        double sigma_y(0);
        sigma_y = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma_y);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_y: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);

            // model parameters
            current_statement_begin__ = 83;
            std::vector<local_scalar_t__> sigma_b;
            size_t sigma_b_d_0_max__ = k;
            sigma_b.reserve(sigma_b_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < sigma_b_d_0_max__; ++d_0__) {
                if (jacobian__)
                    sigma_b.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    sigma_b.push_back(in__.scalar_lb_constrain(0));
            }

            current_statement_begin__ = 84;
            local_scalar_t__ sigma_y;
            (void) sigma_y;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_y = in__.scalar_lb_constrain(0, lp__);
            else
                sigma_y = in__.scalar_lb_constrain(0);

            // transformed parameters
            current_statement_begin__ = 88;
            validate_non_negative_index("R_vector", "k", k);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> R_vector(k);
            stan::math::initialize(R_vector, DUMMY_VAR__);
            stan::math::fill(R_vector, DUMMY_VAR__);

            current_statement_begin__ = 89;
            validate_non_negative_index("P1_vector", "k", k);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> P1_vector(k);
            stan::math::initialize(P1_vector, DUMMY_VAR__);
            stan::math::fill(P1_vector, DUMMY_VAR__);

            // transformed parameters block statements
            current_statement_begin__ = 90;
            for (int i = 1; i <= k; ++i) {

                current_statement_begin__ = 91;
                stan::model::assign(R_vector, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            pow(get_base1(sigma_b, i, "sigma_b", 1), 2), 
                            "assigning variable R_vector");
                current_statement_begin__ = 92;
                stan::model::assign(P1_vector, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            pow(get_base1(beta_sd, i, "beta_sd", 1), 2), 
                            "assigning variable P1_vector");
            }

            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            current_statement_begin__ = 88;
            size_t R_vector_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < R_vector_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(R_vector(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: R_vector" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable R_vector: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 89;
            size_t P1_vector_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < P1_vector_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(P1_vector(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: P1_vector" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable P1_vector: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }

            // model body

            current_statement_begin__ = 97;
            lp_accum__.add(normal_log<propto__>(sigma_b, sigma_b_mean, sigma_b_sd));
            current_statement_begin__ = 98;
            lp_accum__.add(normal_log<propto__>(sigma_y, sigma_y_mean, sigma_y_sd));
            current_statement_begin__ = 99;
            lp_accum__.add(gaussian_filter_rw_lpdf<propto__>(y, beta_mean, P1_vector, pow(sigma_y, 2), diag_matrix(R_vector), xreg, pstream__));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("sigma_b");
        names__.push_back("sigma_y");
        names__.push_back("R_vector");
        names__.push_back("P1_vector");
        names__.push_back("y_rep");
        names__.push_back("beta");
        names__.push_back("y_new");
        names__.push_back("beta_new");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(k);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_new);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dims__.push_back(n_new);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_rw1_model_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning

        // read-transform, write parameters
        std::vector<double> sigma_b;
        size_t sigma_b_d_0_max__ = k;
        sigma_b.reserve(sigma_b_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < sigma_b_d_0_max__; ++d_0__) {
            sigma_b.push_back(in__.scalar_lb_constrain(0));
        }
        size_t sigma_b_k_0_max__ = k;
        for (size_t k_0__ = 0; k_0__ < sigma_b_k_0_max__; ++k_0__) {
            vars__.push_back(sigma_b[k_0__]);
        }

        double sigma_y = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma_y);

        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        if (!include_tparams__ && !include_gqs__) return;

        try {
            // declare and define transformed parameters
            current_statement_begin__ = 88;
            validate_non_negative_index("R_vector", "k", k);
            Eigen::Matrix<double, Eigen::Dynamic, 1> R_vector(k);
            stan::math::initialize(R_vector, DUMMY_VAR__);
            stan::math::fill(R_vector, DUMMY_VAR__);

            current_statement_begin__ = 89;
            validate_non_negative_index("P1_vector", "k", k);
            Eigen::Matrix<double, Eigen::Dynamic, 1> P1_vector(k);
            stan::math::initialize(P1_vector, DUMMY_VAR__);
            stan::math::fill(P1_vector, DUMMY_VAR__);

            // do transformed parameters statements
            current_statement_begin__ = 90;
            for (int i = 1; i <= k; ++i) {

                current_statement_begin__ = 91;
                stan::model::assign(R_vector, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            pow(get_base1(sigma_b, i, "sigma_b", 1), 2), 
                            "assigning variable R_vector");
                current_statement_begin__ = 92;
                stan::model::assign(P1_vector, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            pow(get_base1(beta_sd, i, "beta_sd", 1), 2), 
                            "assigning variable P1_vector");
            }

            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            // write transformed parameters
            if (include_tparams__) {
                size_t R_vector_j_1_max__ = k;
                for (size_t j_1__ = 0; j_1__ < R_vector_j_1_max__; ++j_1__) {
                    vars__.push_back(R_vector(j_1__));
                }
                size_t P1_vector_j_1_max__ = k;
                for (size_t j_1__ = 0; j_1__ < P1_vector_j_1_max__; ++j_1__) {
                    vars__.push_back(P1_vector(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 104;
            validate_non_negative_index("y_rep", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> y_rep(n);
            stan::math::initialize(y_rep, DUMMY_VAR__);
            stan::math::fill(y_rep, DUMMY_VAR__);

            current_statement_begin__ = 105;
            validate_non_negative_index("beta", "k", k);
            validate_non_negative_index("beta", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> beta(k, n);
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);

            current_statement_begin__ = 106;
            validate_non_negative_index("y_new", "n_new", n_new);
            Eigen::Matrix<double, Eigen::Dynamic, 1> y_new(n_new);
            stan::math::initialize(y_new, DUMMY_VAR__);
            stan::math::fill(y_new, DUMMY_VAR__);

            current_statement_begin__ = 107;
            validate_non_negative_index("beta_new", "k", k);
            validate_non_negative_index("beta_new", "n_new", n_new);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> beta_new(k, n_new);
            stan::math::initialize(beta_new, DUMMY_VAR__);
            stan::math::fill(beta_new, DUMMY_VAR__);

            // generated quantities statements
            current_statement_begin__ = 110;
            for (int i = 1; i <= k; ++i) {

                current_statement_begin__ = 111;
                stan::model::assign(beta, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            normal_rng(get_base1(beta_mean, i, "beta_mean", 1), get_base1(beta_sd, i, "beta_sd", 1), base_rng__), 
                            "assigning variable beta");
            }
            current_statement_begin__ = 113;
            for (int t = 1; t <= (n - 1); ++t) {

                current_statement_begin__ = 114;
                for (int i = 1; i <= k; ++i) {

                    current_statement_begin__ = 115;
                    stan::model::assign(beta, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), 
                                normal_rng(get_base1(beta, i, t, "beta", 1), get_base1(sigma_b, i, "sigma_b", 1), base_rng__), 
                                "assigning variable beta");
                }
            }
            current_statement_begin__ = 119;
            for (int t = 1; t <= n; ++t) {

                current_statement_begin__ = 120;
                stan::model::assign(y_rep, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            normal_rng(dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), stan::model::rvalue(beta, stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "beta")), sigma_y, base_rng__), 
                            "assigning variable y_rep");
            }
            current_statement_begin__ = 123;
            stan::math::assign(beta, add(beta, gaussian_smoother_rw(subtract(y, y_rep), beta_mean, P1_vector, pow(sigma_y, 2), diag_matrix(R_vector), xreg, pstream__)));
            current_statement_begin__ = 126;
            for (int t = 1; t <= n; ++t) {

                current_statement_begin__ = 127;
                stan::model::assign(y_rep, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            (dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), stan::model::rvalue(beta, stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "beta")) + normal_rng(0, sigma_y, base_rng__)), 
                            "assigning variable y_rep");
            }
            current_statement_begin__ = 131;
            if (as_bool(logical_gt(n_new, 0))) {

                current_statement_begin__ = 132;
                for (int i = 1; i <= k; ++i) {

                    current_statement_begin__ = 133;
                    stan::model::assign(beta_new, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                                normal_rng(get_base1(beta, i, n, "beta", 1), get_base1(sigma_b, i, "sigma_b", 1), base_rng__), 
                                "assigning variable beta_new");
                }
                current_statement_begin__ = 135;
                for (int t = 1; t <= (n_new - 1); ++t) {

                    current_statement_begin__ = 136;
                    stan::model::assign(y_new, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                (dot_product(stan::model::rvalue(xreg_new, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg_new"), stan::model::rvalue(beta_new, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "beta_new")) + normal_rng(0, sigma_y, base_rng__)), 
                                "assigning variable y_new");
                    current_statement_begin__ = 137;
                    for (int i = 1; i <= k; ++i) {

                        current_statement_begin__ = 138;
                        stan::model::assign(beta_new, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), 
                                    normal_rng(get_base1(beta_new, i, t, "beta_new", 1), get_base1(sigma_b, i, "sigma_b", 1), base_rng__), 
                                    "assigning variable beta_new");
                    }
                }
                current_statement_begin__ = 141;
                stan::model::assign(y_new, 
                            stan::model::cons_list(stan::model::index_uni(n_new), stan::model::nil_index_list()), 
                            (dot_product(stan::model::rvalue(xreg_new, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(n_new), stan::model::nil_index_list())), "xreg_new"), stan::model::rvalue(beta_new, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(n_new), stan::model::nil_index_list())), "beta_new")) + normal_rng(0, sigma_y, base_rng__)), 
                            "assigning variable y_new");
            }

            // validate, write generated quantities
            current_statement_begin__ = 104;
            size_t y_rep_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y_rep_j_1_max__; ++j_1__) {
                vars__.push_back(y_rep(j_1__));
            }

            current_statement_begin__ = 105;
            size_t beta_j_2_max__ = n;
            size_t beta_j_1_max__ = k;
            for (size_t j_2__ = 0; j_2__ < beta_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                    vars__.push_back(beta(j_1__, j_2__));
                }
            }

            current_statement_begin__ = 106;
            size_t y_new_j_1_max__ = n_new;
            for (size_t j_1__ = 0; j_1__ < y_new_j_1_max__; ++j_1__) {
                vars__.push_back(y_new(j_1__));
            }

            current_statement_begin__ = 107;
            size_t beta_new_j_2_max__ = n_new;
            size_t beta_new_j_1_max__ = k;
            for (size_t j_2__ = 0; j_2__ < beta_new_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < beta_new_j_1_max__; ++j_1__) {
                    vars__.push_back(beta_new(j_1__, j_2__));
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_rw1_model";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t sigma_b_k_0_max__ = k;
        for (size_t k_0__ = 0; k_0__ < sigma_b_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_b" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_y";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            size_t R_vector_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < R_vector_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "R_vector" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t P1_vector_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < P1_vector_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "P1_vector" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
        size_t y_rep_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < y_rep_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_rep" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_2_max__ = n;
        size_t beta_j_1_max__ = k;
        for (size_t j_2__ = 0; j_2__ < beta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t y_new_j_1_max__ = n_new;
        for (size_t j_1__ = 0; j_1__ < y_new_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_new" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_new_j_2_max__ = n_new;
        size_t beta_new_j_1_max__ = k;
        for (size_t j_2__ = 0; j_2__ < beta_new_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_new_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_new" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t sigma_b_k_0_max__ = k;
        for (size_t k_0__ = 0; k_0__ < sigma_b_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_b" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_y";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            size_t R_vector_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < R_vector_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "R_vector" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t P1_vector_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < P1_vector_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "P1_vector" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
        size_t y_rep_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < y_rep_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_rep" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_2_max__ = n;
        size_t beta_j_1_max__ = k;
        for (size_t j_2__ = 0; j_2__ < beta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t y_new_j_1_max__ = n_new;
        for (size_t j_1__ = 0; j_1__ < y_new_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_new" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_new_j_2_max__ = n_new;
        size_t beta_new_j_1_max__ = k;
        for (size_t j_2__ = 0; j_2__ < beta_new_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_new_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_new" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }

}; // model

}  // namespace




// Code generated by Stan version 2.19.1

#include <stan/model/model_header.hpp>

namespace model_rw1_model_naive_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_rw1_model_naive");
    reader.add_event(46, 44, "end", "model_rw1_model_naive");
    return reader;
}

class model_rw1_model_naive : public prob_grad {
private:
        int k;
        int n;
        matrix_d xreg;
        vector_d y;
        vector_d beta_mean;
        vector_d beta_sd;
        vector_d sigma_mean;
        vector_d sigma_sd;
        vector_d sigma_b_mean;
        vector_d sigma_b_sd;
        double sigma_y_mean;
        double sigma_y_sd;
public:
    model_rw1_model_naive(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_rw1_model_naive(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_rw1_model_naive_namespace::model_rw1_model_naive";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            // initialize data block variables from context__
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "k", "int", context__.to_vec());
            k = int(0);
            vals_i__ = context__.vals_i("k");
            pos__ = 0;
            k = vals_i__[pos__++];
            check_greater_or_equal(function__, "k", k, 0);

            current_statement_begin__ = 3;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            check_greater_or_equal(function__, "n", n, 0);

            current_statement_begin__ = 4;
            validate_non_negative_index("xreg", "k", k);
            validate_non_negative_index("xreg", "n", n);
            context__.validate_dims("data initialization", "xreg", "matrix_d", context__.to_vec(k,n));
            xreg = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(k, n);
            vals_r__ = context__.vals_r("xreg");
            pos__ = 0;
            size_t xreg_j_2_max__ = n;
            size_t xreg_j_1_max__ = k;
            for (size_t j_2__ = 0; j_2__ < xreg_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < xreg_j_1_max__; ++j_1__) {
                    xreg(j_1__, j_2__) = vals_r__[pos__++];
                }
            }

            current_statement_begin__ = 5;
            validate_non_negative_index("y", "n", n);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(n));
            y = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                y(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 6;
            validate_non_negative_index("beta_mean", "k", k);
            context__.validate_dims("data initialization", "beta_mean", "vector_d", context__.to_vec(k));
            beta_mean = Eigen::Matrix<double, Eigen::Dynamic, 1>(k);
            vals_r__ = context__.vals_r("beta_mean");
            pos__ = 0;
            size_t beta_mean_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < beta_mean_j_1_max__; ++j_1__) {
                beta_mean(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 7;
            validate_non_negative_index("beta_sd", "k", k);
            context__.validate_dims("data initialization", "beta_sd", "vector_d", context__.to_vec(k));
            beta_sd = Eigen::Matrix<double, Eigen::Dynamic, 1>(k);
            vals_r__ = context__.vals_r("beta_sd");
            pos__ = 0;
            size_t beta_sd_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < beta_sd_j_1_max__; ++j_1__) {
                beta_sd(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 8;
            validate_non_negative_index("sigma_mean", "(k + 1)", (k + 1));
            context__.validate_dims("data initialization", "sigma_mean", "vector_d", context__.to_vec((k + 1)));
            sigma_mean = Eigen::Matrix<double, Eigen::Dynamic, 1>((k + 1));
            vals_r__ = context__.vals_r("sigma_mean");
            pos__ = 0;
            size_t sigma_mean_j_1_max__ = (k + 1);
            for (size_t j_1__ = 0; j_1__ < sigma_mean_j_1_max__; ++j_1__) {
                sigma_mean(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 9;
            validate_non_negative_index("sigma_sd", "(k + 1)", (k + 1));
            context__.validate_dims("data initialization", "sigma_sd", "vector_d", context__.to_vec((k + 1)));
            sigma_sd = Eigen::Matrix<double, Eigen::Dynamic, 1>((k + 1));
            vals_r__ = context__.vals_r("sigma_sd");
            pos__ = 0;
            size_t sigma_sd_j_1_max__ = (k + 1);
            for (size_t j_1__ = 0; j_1__ < sigma_sd_j_1_max__; ++j_1__) {
                sigma_sd(j_1__) = vals_r__[pos__++];
            }


            // initialize transformed data variables
            current_statement_begin__ = 13;
            validate_non_negative_index("sigma_b_mean", "k", k);
            sigma_b_mean = Eigen::Matrix<double, Eigen::Dynamic, 1>(k);
            stan::math::fill(sigma_b_mean, DUMMY_VAR__);
            stan::math::assign(sigma_b_mean,stan::model::rvalue(sigma_mean, stan::model::cons_list(stan::model::index_min(2), stan::model::nil_index_list()), "sigma_mean"));

            current_statement_begin__ = 14;
            validate_non_negative_index("sigma_b_sd", "k", k);
            sigma_b_sd = Eigen::Matrix<double, Eigen::Dynamic, 1>(k);
            stan::math::fill(sigma_b_sd, DUMMY_VAR__);
            stan::math::assign(sigma_b_sd,stan::model::rvalue(sigma_sd, stan::model::cons_list(stan::model::index_min(2), stan::model::nil_index_list()), "sigma_sd"));

            current_statement_begin__ = 15;
            sigma_y_mean = double(0);
            stan::math::fill(sigma_y_mean, DUMMY_VAR__);
            stan::math::assign(sigma_y_mean,get_base1(sigma_mean, 1, "sigma_mean", 1));

            current_statement_begin__ = 16;
            sigma_y_sd = double(0);
            stan::math::fill(sigma_y_sd, DUMMY_VAR__);
            stan::math::assign(sigma_y_sd,get_base1(sigma_sd, 1, "sigma_sd", 1));

            // execute transformed data statements

            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 20;
            validate_non_negative_index("sigma_b", "k", k);
            num_params_r__ += (1 * k);
            current_statement_begin__ = 21;
            num_params_r__ += 1;
            current_statement_begin__ = 22;
            validate_non_negative_index("beta_raw", "k", k);
            validate_non_negative_index("beta_raw", "n", n);
            num_params_r__ += (k * n);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_rw1_model_naive() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        current_statement_begin__ = 20;
        if (!(context__.contains_r("sigma_b")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_b missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_b");
        pos__ = 0U;
        validate_non_negative_index("sigma_b", "k", k);
        context__.validate_dims("parameter initialization", "sigma_b", "double", context__.to_vec(k));
        std::vector<double> sigma_b(k, double(0));
        size_t sigma_b_k_0_max__ = k;
        for (size_t k_0__ = 0; k_0__ < sigma_b_k_0_max__; ++k_0__) {
            sigma_b[k_0__] = vals_r__[pos__++];
        }
        size_t sigma_b_i_0_max__ = k;
        for (size_t i_0__ = 0; i_0__ < sigma_b_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, sigma_b[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_b: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }

        current_statement_begin__ = 21;
        if (!(context__.contains_r("sigma_y")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_y missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_y");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma_y", "double", context__.to_vec());
        double sigma_y(0);
        sigma_y = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma_y);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_y: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 22;
        if (!(context__.contains_r("beta_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta_raw");
        pos__ = 0U;
        validate_non_negative_index("beta_raw", "k", k);
        validate_non_negative_index("beta_raw", "n", n);
        context__.validate_dims("parameter initialization", "beta_raw", "matrix_d", context__.to_vec(k,n));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> beta_raw(k, n);
        size_t beta_raw_j_2_max__ = n;
        size_t beta_raw_j_1_max__ = k;
        for (size_t j_2__ = 0; j_2__ < beta_raw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_raw_j_1_max__; ++j_1__) {
                beta_raw(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(beta_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);

            // model parameters
            current_statement_begin__ = 20;
            std::vector<local_scalar_t__> sigma_b;
            size_t sigma_b_d_0_max__ = k;
            sigma_b.reserve(sigma_b_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < sigma_b_d_0_max__; ++d_0__) {
                if (jacobian__)
                    sigma_b.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    sigma_b.push_back(in__.scalar_lb_constrain(0));
            }

            current_statement_begin__ = 21;
            local_scalar_t__ sigma_y;
            (void) sigma_y;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_y = in__.scalar_lb_constrain(0, lp__);
            else
                sigma_y = in__.scalar_lb_constrain(0);

            current_statement_begin__ = 22;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> beta_raw;
            (void) beta_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                beta_raw = in__.matrix_constrain(k, n, lp__);
            else
                beta_raw = in__.matrix_constrain(k, n);

            // transformed parameters
            current_statement_begin__ = 26;
            validate_non_negative_index("beta", "k", k);
            validate_non_negative_index("beta", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> beta(k, n);
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);

            current_statement_begin__ = 28;
            validate_non_negative_index("tmp", "k", k);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp(k);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);

            // transformed parameters block statements
            current_statement_begin__ = 29;
            stan::model::assign(beta, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                        add(beta_mean, elt_multiply(beta_sd, stan::model::rvalue(beta_raw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "beta_raw"))), 
                        "assigning variable beta");
            current_statement_begin__ = 30;
            for (int t = 2; t <= n; ++t) {

                current_statement_begin__ = 31;
                stan::math::assign(tmp, stan::model::rvalue(beta, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::nil_index_list())), "beta"));
                current_statement_begin__ = 32;
                stan::model::assign(beta, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                            add(tmp, elt_multiply(to_vector(sigma_b), stan::model::rvalue(beta_raw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "beta_raw"))), 
                            "assigning variable beta");
            }

            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            current_statement_begin__ = 26;
            size_t beta_j_1_max__ = k;
            size_t beta_j_2_max__ = n;
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < beta_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(beta(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: beta" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable beta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 28;
            size_t tmp_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < tmp_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(tmp(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: tmp" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable tmp: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }

            // model body

            current_statement_begin__ = 37;
            lp_accum__.add(normal_log<propto__>(sigma_b, sigma_b_mean, sigma_b_sd));
            current_statement_begin__ = 38;
            lp_accum__.add(normal_log<propto__>(sigma_y, sigma_y_mean, sigma_y_sd));
            current_statement_begin__ = 39;
            lp_accum__.add(normal_log<propto__>(to_vector(beta_raw), 0, 1));
            {
            current_statement_begin__ = 41;
            validate_non_negative_index("mu", "n", n);
            Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> mu(n);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            stan::math::assign(mu,columns_dot_product(xreg, beta));


            current_statement_begin__ = 42;
            lp_accum__.add(normal_log<propto__>(y, mu, sigma_y));
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("sigma_b");
        names__.push_back("sigma_y");
        names__.push_back("beta_raw");
        names__.push_back("beta");
        names__.push_back("tmp");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(k);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_rw1_model_naive_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning

        // read-transform, write parameters
        std::vector<double> sigma_b;
        size_t sigma_b_d_0_max__ = k;
        sigma_b.reserve(sigma_b_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < sigma_b_d_0_max__; ++d_0__) {
            sigma_b.push_back(in__.scalar_lb_constrain(0));
        }
        size_t sigma_b_k_0_max__ = k;
        for (size_t k_0__ = 0; k_0__ < sigma_b_k_0_max__; ++k_0__) {
            vars__.push_back(sigma_b[k_0__]);
        }

        double sigma_y = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma_y);

        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> beta_raw = in__.matrix_constrain(k, n);
        size_t beta_raw_j_2_max__ = n;
        size_t beta_raw_j_1_max__ = k;
        for (size_t j_2__ = 0; j_2__ < beta_raw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_raw_j_1_max__; ++j_1__) {
                vars__.push_back(beta_raw(j_1__, j_2__));
            }
        }

        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        if (!include_tparams__ && !include_gqs__) return;

        try {
            // declare and define transformed parameters
            current_statement_begin__ = 26;
            validate_non_negative_index("beta", "k", k);
            validate_non_negative_index("beta", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> beta(k, n);
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);

            current_statement_begin__ = 28;
            validate_non_negative_index("tmp", "k", k);
            Eigen::Matrix<double, Eigen::Dynamic, 1> tmp(k);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);

            // do transformed parameters statements
            current_statement_begin__ = 29;
            stan::model::assign(beta, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                        add(beta_mean, elt_multiply(beta_sd, stan::model::rvalue(beta_raw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "beta_raw"))), 
                        "assigning variable beta");
            current_statement_begin__ = 30;
            for (int t = 2; t <= n; ++t) {

                current_statement_begin__ = 31;
                stan::math::assign(tmp, stan::model::rvalue(beta, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::nil_index_list())), "beta"));
                current_statement_begin__ = 32;
                stan::model::assign(beta, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                            add(tmp, elt_multiply(to_vector(sigma_b), stan::model::rvalue(beta_raw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "beta_raw"))), 
                            "assigning variable beta");
            }

            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            // write transformed parameters
            if (include_tparams__) {
                size_t beta_j_2_max__ = n;
                size_t beta_j_1_max__ = k;
                for (size_t j_2__ = 0; j_2__ < beta_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                        vars__.push_back(beta(j_1__, j_2__));
                    }
                }
                size_t tmp_j_1_max__ = k;
                for (size_t j_1__ = 0; j_1__ < tmp_j_1_max__; ++j_1__) {
                    vars__.push_back(tmp(j_1__));
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_rw1_model_naive";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t sigma_b_k_0_max__ = k;
        for (size_t k_0__ = 0; k_0__ < sigma_b_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_b" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_y";
        param_names__.push_back(param_name_stream__.str());
        size_t beta_raw_j_2_max__ = n;
        size_t beta_raw_j_1_max__ = k;
        for (size_t j_2__ = 0; j_2__ < beta_raw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_raw_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_raw" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            size_t beta_j_2_max__ = n;
            size_t beta_j_1_max__ = k;
            for (size_t j_2__ = 0; j_2__ < beta_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "beta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t tmp_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < tmp_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tmp" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t sigma_b_k_0_max__ = k;
        for (size_t k_0__ = 0; k_0__ < sigma_b_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_b" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_y";
        param_names__.push_back(param_name_stream__.str());
        size_t beta_raw_j_2_max__ = n;
        size_t beta_raw_j_1_max__ = k;
        for (size_t j_2__ = 0; j_2__ < beta_raw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_raw_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_raw" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            size_t beta_j_2_max__ = n;
            size_t beta_j_1_max__ = k;
            for (size_t j_2__ = 0; j_2__ < beta_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "beta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t tmp_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < tmp_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tmp" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
    }

}; // model

}  // namespace




// Code generated by Stan version 2.19.1

#include <stan/model/model_header.hpp>

namespace model_rw_glm_model_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_rw_glm_model");
    reader.add_event(205, 203, "end", "model_rw_glm_model");
    return reader;
}

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T7__, typename T8__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T7__, T8__>::type>::type, Eigen::Dynamic, 1>
glm_approx_smoother(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                        const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& a1,
                        const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& P1,
                        const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& Ht,
                        const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                        const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& xreg,
                        const int& distribution,
                        const Eigen::Matrix<T7__, Eigen::Dynamic, 1>& u,
                        const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& y_original, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T7__, T8__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 9;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,rows(y));

        current_statement_begin__ = 10;
        int m(0);
        (void) m;  // dummy to suppress unused var warning
        stan::math::fill(m, std::numeric_limits<int>::min());
        stan::math::assign(m,rows(a1));

        current_statement_begin__ = 11;
        validate_non_negative_index("x", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> x(m);
        stan::math::initialize(x, DUMMY_VAR__);
        stan::math::fill(x, DUMMY_VAR__);
        stan::math::assign(x,a1);

        current_statement_begin__ = 12;
        validate_non_negative_index("P", "m", m);
        validate_non_negative_index("P", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> P(m, m);
        stan::math::initialize(P, DUMMY_VAR__);
        stan::math::fill(P, DUMMY_VAR__);
        stan::math::assign(P,diag_matrix(P1));

        current_statement_begin__ = 13;
        validate_non_negative_index("v", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> v(n);
        stan::math::initialize(v, DUMMY_VAR__);
        stan::math::fill(v, DUMMY_VAR__);

        current_statement_begin__ = 14;
        validate_non_negative_index("F", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> F(n);
        stan::math::initialize(F, DUMMY_VAR__);
        stan::math::fill(F, DUMMY_VAR__);

        current_statement_begin__ = 15;
        validate_non_negative_index("K", "m", m);
        validate_non_negative_index("K", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> K(m, n);
        stan::math::initialize(K, DUMMY_VAR__);
        stan::math::fill(K, DUMMY_VAR__);

        current_statement_begin__ = 16;
        validate_non_negative_index("r", "m", m);
        validate_non_negative_index("r", "(n + 1)", (n + 1));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> r(m, (n + 1));
        stan::math::initialize(r, DUMMY_VAR__);
        stan::math::fill(r, DUMMY_VAR__);

        current_statement_begin__ = 17;
        validate_non_negative_index("tmpr", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmpr(m);
        stan::math::initialize(tmpr, DUMMY_VAR__);
        stan::math::fill(tmpr, DUMMY_VAR__);

        current_statement_begin__ = 18;
        validate_non_negative_index("loglik", "2", 2);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> loglik(2);
        stan::math::initialize(loglik, DUMMY_VAR__);
        stan::math::fill(loglik, DUMMY_VAR__);
        stan::math::assign(loglik,rep_vector(0, 2));


        current_statement_begin__ = 21;
        for (int t = 1; t <= n; ++t) {

            current_statement_begin__ = 22;
            stan::model::assign(F, 
                        stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                        (quad_form(P, stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")) + get_base1(Ht, t, "Ht", 1)), 
                        "assigning variable F");
            current_statement_begin__ = 23;
            stan::model::assign(v, 
                        stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                        (get_base1(y, t, "y", 1) - dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), x)), 
                        "assigning variable v");
            current_statement_begin__ = 24;
            stan::model::assign(K, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                        divide(multiply(P, stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")), get_base1(F, t, "F", 1)), 
                        "assigning variable K");
            current_statement_begin__ = 25;
            stan::math::assign(x, add(x, multiply(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"), get_base1(v, t, "v", 1))));
            current_statement_begin__ = 26;
            stan::math::assign(P, add(P, add(multiply(multiply(minus(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K")), transpose(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"))), get_base1(F, t, "F", 1)), Rt)));
            current_statement_begin__ = 27;
            stan::model::assign(loglik, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        (stan::model::rvalue(loglik, stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), "loglik") - (0.5 * (stan::math::log(get_base1(F, t, "F", 1)) + ((get_base1(v, t, "v", 1) * get_base1(v, t, "v", 1)) / get_base1(F, t, "F", 1))))), 
                        "assigning variable loglik");
        }
        current_statement_begin__ = 30;
        stan::model::assign(r, 
                    stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((n + 1)), stan::model::nil_index_list())), 
                    rep_vector(0.0, m), 
                    "assigning variable r");
        current_statement_begin__ = 31;
        for (int tt = 1; tt <= n; ++tt) {
            {
            current_statement_begin__ = 32;
            int t(0);
            (void) t;  // dummy to suppress unused var warning
            stan::math::fill(t, std::numeric_limits<int>::min());
            stan::math::assign(t,((n + 1) - tt));

            current_statement_begin__ = 33;
            validate_non_negative_index("tmp", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp(m);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            stan::math::assign(tmp,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), "r"));


            current_statement_begin__ = 34;
            stan::model::assign(r, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                        subtract(add(divide(multiply(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), get_base1(v, t, "v", 1)), get_base1(F, t, "F", 1)), tmp), multiply(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), dot_product(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"), tmp))), 
                        "assigning variable r");
            }
        }
        current_statement_begin__ = 37;
        stan::math::assign(tmpr, stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "r"));
        current_statement_begin__ = 38;
        stan::model::assign(r, 
                    stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    add(a1, elt_multiply(P1, tmpr)), 
                    "assigning variable r");
        current_statement_begin__ = 39;
        for (int t = 2; t <= n; ++t) {
            {
            current_statement_begin__ = 40;
            validate_non_negative_index("tmp", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp(m);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            stan::math::assign(tmp,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::nil_index_list())), "r"));

            current_statement_begin__ = 41;
            validate_non_negative_index("tmp2", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp2(m);
            stan::math::initialize(tmp2, DUMMY_VAR__);
            stan::math::fill(tmp2, DUMMY_VAR__);
            stan::math::assign(tmp2,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "r"));


            current_statement_begin__ = 42;
            stan::model::assign(r, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                        add(tmp, multiply(Rt, tmp2)), 
                        "assigning variable r");
            }
        }
        current_statement_begin__ = 48;
        for (int t = 1; t <= n; ++t) {
            {
            current_statement_begin__ = 49;
            local_scalar_t__ xbeta(DUMMY_VAR__);
            (void) xbeta;  // dummy to suppress unused var warning
            stan::math::initialize(xbeta, DUMMY_VAR__);
            stan::math::fill(xbeta, DUMMY_VAR__);
            stan::math::assign(xbeta,dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "r")));


            current_statement_begin__ = 50;
            stan::model::assign(loglik, 
                        stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                        (stan::model::rvalue(loglik, stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), "loglik") + (((get_base1(y_original, t, "y_original", 1) * xbeta) - (get_base1(u, t, "u", 1) * stan::math::exp(xbeta))) + ((0.5 * pow((get_base1(y, t, "y", 1) - xbeta), 2)) / get_base1(Ht, t, "Ht", 1)))), 
                        "assigning variable loglik");
            }
        }
        current_statement_begin__ = 54;
        return stan::math::promote_scalar<fun_return_scalar_t__>(loglik);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct glm_approx_smoother_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T7__, typename T8__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T7__, T8__>::type>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                        const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& a1,
                        const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& P1,
                        const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& Ht,
                        const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                        const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& xreg,
                        const int& distribution,
                        const Eigen::Matrix<T7__, Eigen::Dynamic, 1>& u,
                        const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& y_original, std::ostream* pstream__) const {
        return glm_approx_smoother(y, a1, P1, Ht, Rt, xreg, distribution, u, y_original, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type, Eigen::Dynamic, Eigen::Dynamic>
gaussian_smoother(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                      const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& a1,
                      const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& P1,
                      const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& Ht,
                      const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                      const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& xreg, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 59;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,rows(y));

        current_statement_begin__ = 60;
        int m(0);
        (void) m;  // dummy to suppress unused var warning
        stan::math::fill(m, std::numeric_limits<int>::min());
        stan::math::assign(m,rows(a1));

        current_statement_begin__ = 61;
        validate_non_negative_index("x", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> x(m);
        stan::math::initialize(x, DUMMY_VAR__);
        stan::math::fill(x, DUMMY_VAR__);
        stan::math::assign(x,a1);

        current_statement_begin__ = 62;
        validate_non_negative_index("P", "m", m);
        validate_non_negative_index("P", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> P(m, m);
        stan::math::initialize(P, DUMMY_VAR__);
        stan::math::fill(P, DUMMY_VAR__);
        stan::math::assign(P,diag_matrix(P1));

        current_statement_begin__ = 63;
        validate_non_negative_index("v", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> v(n);
        stan::math::initialize(v, DUMMY_VAR__);
        stan::math::fill(v, DUMMY_VAR__);

        current_statement_begin__ = 64;
        validate_non_negative_index("F", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> F(n);
        stan::math::initialize(F, DUMMY_VAR__);
        stan::math::fill(F, DUMMY_VAR__);

        current_statement_begin__ = 65;
        validate_non_negative_index("K", "m", m);
        validate_non_negative_index("K", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> K(m, n);
        stan::math::initialize(K, DUMMY_VAR__);
        stan::math::fill(K, DUMMY_VAR__);

        current_statement_begin__ = 66;
        validate_non_negative_index("r", "m", m);
        validate_non_negative_index("r", "(n + 1)", (n + 1));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> r(m, (n + 1));
        stan::math::initialize(r, DUMMY_VAR__);
        stan::math::fill(r, DUMMY_VAR__);

        current_statement_begin__ = 67;
        validate_non_negative_index("tmpr", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmpr(m);
        stan::math::initialize(tmpr, DUMMY_VAR__);
        stan::math::fill(tmpr, DUMMY_VAR__);


        current_statement_begin__ = 69;
        for (int t = 1; t <= n; ++t) {

            current_statement_begin__ = 70;
            stan::model::assign(F, 
                        stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                        (quad_form(P, stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")) + get_base1(Ht, t, "Ht", 1)), 
                        "assigning variable F");
            current_statement_begin__ = 71;
            stan::model::assign(v, 
                        stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                        (get_base1(y, t, "y", 1) - dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), x)), 
                        "assigning variable v");
            current_statement_begin__ = 72;
            stan::model::assign(K, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                        divide(multiply(P, stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")), get_base1(F, t, "F", 1)), 
                        "assigning variable K");
            current_statement_begin__ = 73;
            stan::math::assign(x, add(x, multiply(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"), get_base1(v, t, "v", 1))));
            current_statement_begin__ = 74;
            stan::math::assign(P, add(P, add(multiply(multiply(minus(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K")), transpose(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"))), get_base1(F, t, "F", 1)), Rt)));
        }
        current_statement_begin__ = 76;
        stan::model::assign(r, 
                    stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((n + 1)), stan::model::nil_index_list())), 
                    rep_vector(0.0, m), 
                    "assigning variable r");
        current_statement_begin__ = 77;
        for (int tt = 1; tt <= n; ++tt) {
            {
            current_statement_begin__ = 78;
            int t(0);
            (void) t;  // dummy to suppress unused var warning
            stan::math::fill(t, std::numeric_limits<int>::min());
            stan::math::assign(t,((n + 1) - tt));

            current_statement_begin__ = 79;
            validate_non_negative_index("tmp", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp(m);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            stan::math::assign(tmp,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), "r"));


            current_statement_begin__ = 80;
            stan::model::assign(r, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                        subtract(add(divide(multiply(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), get_base1(v, t, "v", 1)), get_base1(F, t, "F", 1)), tmp), multiply(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), dot_product(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"), tmp))), 
                        "assigning variable r");
            }
        }
        current_statement_begin__ = 83;
        stan::math::assign(tmpr, stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "r"));
        current_statement_begin__ = 84;
        stan::model::assign(r, 
                    stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    add(a1, elt_multiply(P1, tmpr)), 
                    "assigning variable r");
        current_statement_begin__ = 85;
        for (int t = 2; t <= n; ++t) {
            {
            current_statement_begin__ = 86;
            validate_non_negative_index("tmp", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp(m);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            stan::math::assign(tmp,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::nil_index_list())), "r"));

            current_statement_begin__ = 87;
            validate_non_negative_index("tmp2", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp2(m);
            stan::math::initialize(tmp2, DUMMY_VAR__);
            stan::math::fill(tmp2, DUMMY_VAR__);
            stan::math::assign(tmp2,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "r"));


            current_statement_begin__ = 88;
            stan::model::assign(r, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                        add(tmp, multiply(Rt, tmp2)), 
                        "assigning variable r");
            }
        }
        current_statement_begin__ = 90;
        return stan::math::promote_scalar<fun_return_scalar_t__>(stan::model::rvalue(r, stan::model::cons_list(stan::model::index_min_max(1, m), stan::model::cons_list(stan::model::index_min_max(1, n), stan::model::nil_index_list())), "r"));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct gaussian_smoother_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                      const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& a1,
                      const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& P1,
                      const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& Ht,
                      const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                      const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& xreg, std::ostream* pstream__) const {
        return gaussian_smoother(y, a1, P1, Ht, Rt, xreg, pstream__);
    }
};

class model_rw_glm_model : public prob_grad {
private:
        int k;
        int n;
        matrix_d xreg;
        vector_d y;
        vector_d beta_mean;
        vector_d beta_sd;
        vector_d sigma_mean;
        vector_d sigma_sd;
        int n_new;
        matrix_d xreg_new;
        vector_d Ht;
        vector_d y_original;
        vector_d u;
        int distribution;
        int N;
public:
    model_rw_glm_model(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_rw_glm_model(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_rw_glm_model_namespace::model_rw_glm_model";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            // initialize data block variables from context__
            current_statement_begin__ = 95;
            context__.validate_dims("data initialization", "k", "int", context__.to_vec());
            k = int(0);
            vals_i__ = context__.vals_i("k");
            pos__ = 0;
            k = vals_i__[pos__++];
            check_greater_or_equal(function__, "k", k, 0);

            current_statement_begin__ = 96;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            check_greater_or_equal(function__, "n", n, 0);

            current_statement_begin__ = 97;
            validate_non_negative_index("xreg", "k", k);
            validate_non_negative_index("xreg", "n", n);
            context__.validate_dims("data initialization", "xreg", "matrix_d", context__.to_vec(k,n));
            xreg = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(k, n);
            vals_r__ = context__.vals_r("xreg");
            pos__ = 0;
            size_t xreg_j_2_max__ = n;
            size_t xreg_j_1_max__ = k;
            for (size_t j_2__ = 0; j_2__ < xreg_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < xreg_j_1_max__; ++j_1__) {
                    xreg(j_1__, j_2__) = vals_r__[pos__++];
                }
            }

            current_statement_begin__ = 98;
            validate_non_negative_index("y", "n", n);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(n));
            y = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                y(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 99;
            validate_non_negative_index("beta_mean", "k", k);
            context__.validate_dims("data initialization", "beta_mean", "vector_d", context__.to_vec(k));
            beta_mean = Eigen::Matrix<double, Eigen::Dynamic, 1>(k);
            vals_r__ = context__.vals_r("beta_mean");
            pos__ = 0;
            size_t beta_mean_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < beta_mean_j_1_max__; ++j_1__) {
                beta_mean(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 100;
            validate_non_negative_index("beta_sd", "k", k);
            context__.validate_dims("data initialization", "beta_sd", "vector_d", context__.to_vec(k));
            beta_sd = Eigen::Matrix<double, Eigen::Dynamic, 1>(k);
            vals_r__ = context__.vals_r("beta_sd");
            pos__ = 0;
            size_t beta_sd_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < beta_sd_j_1_max__; ++j_1__) {
                beta_sd(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 101;
            validate_non_negative_index("sigma_mean", "k", k);
            context__.validate_dims("data initialization", "sigma_mean", "vector_d", context__.to_vec(k));
            sigma_mean = Eigen::Matrix<double, Eigen::Dynamic, 1>(k);
            vals_r__ = context__.vals_r("sigma_mean");
            pos__ = 0;
            size_t sigma_mean_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < sigma_mean_j_1_max__; ++j_1__) {
                sigma_mean(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 102;
            validate_non_negative_index("sigma_sd", "k", k);
            context__.validate_dims("data initialization", "sigma_sd", "vector_d", context__.to_vec(k));
            sigma_sd = Eigen::Matrix<double, Eigen::Dynamic, 1>(k);
            vals_r__ = context__.vals_r("sigma_sd");
            pos__ = 0;
            size_t sigma_sd_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < sigma_sd_j_1_max__; ++j_1__) {
                sigma_sd(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 103;
            context__.validate_dims("data initialization", "n_new", "int", context__.to_vec());
            n_new = int(0);
            vals_i__ = context__.vals_i("n_new");
            pos__ = 0;
            n_new = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_new", n_new, 0);

            current_statement_begin__ = 104;
            validate_non_negative_index("xreg_new", "k", k);
            validate_non_negative_index("xreg_new", "n_new", n_new);
            context__.validate_dims("data initialization", "xreg_new", "matrix_d", context__.to_vec(k,n_new));
            xreg_new = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(k, n_new);
            vals_r__ = context__.vals_r("xreg_new");
            pos__ = 0;
            size_t xreg_new_j_2_max__ = n_new;
            size_t xreg_new_j_1_max__ = k;
            for (size_t j_2__ = 0; j_2__ < xreg_new_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < xreg_new_j_1_max__; ++j_1__) {
                    xreg_new(j_1__, j_2__) = vals_r__[pos__++];
                }
            }

            current_statement_begin__ = 105;
            validate_non_negative_index("Ht", "n", n);
            context__.validate_dims("data initialization", "Ht", "vector_d", context__.to_vec(n));
            Ht = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("Ht");
            pos__ = 0;
            size_t Ht_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < Ht_j_1_max__; ++j_1__) {
                Ht(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 106;
            validate_non_negative_index("y_original", "n", n);
            context__.validate_dims("data initialization", "y_original", "vector_d", context__.to_vec(n));
            y_original = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("y_original");
            pos__ = 0;
            size_t y_original_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y_original_j_1_max__; ++j_1__) {
                y_original(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 107;
            validate_non_negative_index("u", "n", n);
            context__.validate_dims("data initialization", "u", "vector_d", context__.to_vec(n));
            u = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("u");
            pos__ = 0;
            size_t u_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < u_j_1_max__; ++j_1__) {
                u(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 108;
            context__.validate_dims("data initialization", "distribution", "int", context__.to_vec());
            distribution = int(0);
            vals_i__ = context__.vals_i("distribution");
            pos__ = 0;
            distribution = vals_i__[pos__++];

            current_statement_begin__ = 109;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 0);


            // initialize transformed data variables
            // execute transformed data statements

            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 114;
            validate_non_negative_index("sigma_b", "k", k);
            num_params_r__ += (1 * k);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_rw_glm_model() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        current_statement_begin__ = 114;
        if (!(context__.contains_r("sigma_b")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_b missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_b");
        pos__ = 0U;
        validate_non_negative_index("sigma_b", "k", k);
        context__.validate_dims("parameter initialization", "sigma_b", "double", context__.to_vec(k));
        std::vector<double> sigma_b(k, double(0));
        size_t sigma_b_k_0_max__ = k;
        for (size_t k_0__ = 0; k_0__ < sigma_b_k_0_max__; ++k_0__) {
            sigma_b[k_0__] = vals_r__[pos__++];
        }
        size_t sigma_b_i_0_max__ = k;
        for (size_t i_0__ = 0; i_0__ < sigma_b_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, sigma_b[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_b: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);

            // model parameters
            current_statement_begin__ = 114;
            std::vector<local_scalar_t__> sigma_b;
            size_t sigma_b_d_0_max__ = k;
            sigma_b.reserve(sigma_b_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < sigma_b_d_0_max__; ++d_0__) {
                if (jacobian__)
                    sigma_b.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    sigma_b.push_back(in__.scalar_lb_constrain(0));
            }

            // transformed parameters
            current_statement_begin__ = 118;
            validate_non_negative_index("R_vector", "k", k);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> R_vector(k);
            stan::math::initialize(R_vector, DUMMY_VAR__);
            stan::math::fill(R_vector, DUMMY_VAR__);

            current_statement_begin__ = 119;
            validate_non_negative_index("P1_vector", "k", k);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> P1_vector(k);
            stan::math::initialize(P1_vector, DUMMY_VAR__);
            stan::math::fill(P1_vector, DUMMY_VAR__);

            current_statement_begin__ = 120;
            validate_non_negative_index("loglik", "2", 2);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> loglik(2);
            stan::math::initialize(loglik, DUMMY_VAR__);
            stan::math::fill(loglik, DUMMY_VAR__);

            // transformed parameters block statements
            current_statement_begin__ = 121;
            for (int i = 1; i <= k; ++i) {

                current_statement_begin__ = 122;
                stan::model::assign(R_vector, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            pow(get_base1(sigma_b, i, "sigma_b", 1), 2), 
                            "assigning variable R_vector");
                current_statement_begin__ = 123;
                stan::model::assign(P1_vector, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            pow(get_base1(beta_sd, i, "beta_sd", 1), 2), 
                            "assigning variable P1_vector");
            }
            current_statement_begin__ = 125;
            stan::math::assign(loglik, glm_approx_smoother(y, beta_mean, P1_vector, Ht, diag_matrix(R_vector), xreg, distribution, u, y_original, pstream__));

            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            current_statement_begin__ = 118;
            size_t R_vector_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < R_vector_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(R_vector(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: R_vector" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable R_vector: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 119;
            size_t P1_vector_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < P1_vector_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(P1_vector(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: P1_vector" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable P1_vector: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 120;
            size_t loglik_j_1_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < loglik_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(loglik(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: loglik" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable loglik: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }

            // model body

            current_statement_begin__ = 130;
            lp_accum__.add(normal_log<propto__>(sigma_b, sigma_mean, sigma_sd));
            current_statement_begin__ = 131;
            lp_accum__.add(sum(loglik));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("sigma_b");
        names__.push_back("R_vector");
        names__.push_back("P1_vector");
        names__.push_back("loglik");
        names__.push_back("beta");
        names__.push_back("weights");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(k);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_rw_glm_model_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning

        // read-transform, write parameters
        std::vector<double> sigma_b;
        size_t sigma_b_d_0_max__ = k;
        sigma_b.reserve(sigma_b_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < sigma_b_d_0_max__; ++d_0__) {
            sigma_b.push_back(in__.scalar_lb_constrain(0));
        }
        size_t sigma_b_k_0_max__ = k;
        for (size_t k_0__ = 0; k_0__ < sigma_b_k_0_max__; ++k_0__) {
            vars__.push_back(sigma_b[k_0__]);
        }

        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        if (!include_tparams__ && !include_gqs__) return;

        try {
            // declare and define transformed parameters
            current_statement_begin__ = 118;
            validate_non_negative_index("R_vector", "k", k);
            Eigen::Matrix<double, Eigen::Dynamic, 1> R_vector(k);
            stan::math::initialize(R_vector, DUMMY_VAR__);
            stan::math::fill(R_vector, DUMMY_VAR__);

            current_statement_begin__ = 119;
            validate_non_negative_index("P1_vector", "k", k);
            Eigen::Matrix<double, Eigen::Dynamic, 1> P1_vector(k);
            stan::math::initialize(P1_vector, DUMMY_VAR__);
            stan::math::fill(P1_vector, DUMMY_VAR__);

            current_statement_begin__ = 120;
            validate_non_negative_index("loglik", "2", 2);
            Eigen::Matrix<double, Eigen::Dynamic, 1> loglik(2);
            stan::math::initialize(loglik, DUMMY_VAR__);
            stan::math::fill(loglik, DUMMY_VAR__);

            // do transformed parameters statements
            current_statement_begin__ = 121;
            for (int i = 1; i <= k; ++i) {

                current_statement_begin__ = 122;
                stan::model::assign(R_vector, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            pow(get_base1(sigma_b, i, "sigma_b", 1), 2), 
                            "assigning variable R_vector");
                current_statement_begin__ = 123;
                stan::model::assign(P1_vector, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            pow(get_base1(beta_sd, i, "beta_sd", 1), 2), 
                            "assigning variable P1_vector");
            }
            current_statement_begin__ = 125;
            stan::math::assign(loglik, glm_approx_smoother(y, beta_mean, P1_vector, Ht, diag_matrix(R_vector), xreg, distribution, u, y_original, pstream__));

            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            // write transformed parameters
            if (include_tparams__) {
                size_t R_vector_j_1_max__ = k;
                for (size_t j_1__ = 0; j_1__ < R_vector_j_1_max__; ++j_1__) {
                    vars__.push_back(R_vector(j_1__));
                }
                size_t P1_vector_j_1_max__ = k;
                for (size_t j_1__ = 0; j_1__ < P1_vector_j_1_max__; ++j_1__) {
                    vars__.push_back(P1_vector(j_1__));
                }
                size_t loglik_j_1_max__ = 2;
                for (size_t j_1__ = 0; j_1__ < loglik_j_1_max__; ++j_1__) {
                    vars__.push_back(loglik(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 136;
            validate_non_negative_index("beta", "k", k);
            validate_non_negative_index("beta", "n", n);
            std::vector<std::vector<double> > beta(k, std::vector<double>(n, double(0)));
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);

            current_statement_begin__ = 137;
            double weights;
            (void) weights;  // dummy to suppress unused var warning
            stan::math::initialize(weights, DUMMY_VAR__);
            stan::math::fill(weights, DUMMY_VAR__);

            // generated quantities statements
            {
            current_statement_begin__ = 140;
            validate_non_negative_index("y_rep", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> y_rep(n);
            stan::math::initialize(y_rep, DUMMY_VAR__);
            stan::math::fill(y_rep, DUMMY_VAR__);

            current_statement_begin__ = 141;
            validate_non_negative_index("beta_j", "k", k);
            validate_non_negative_index("beta_j", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> beta_j(k, n);
            stan::math::initialize(beta_j, DUMMY_VAR__);
            stan::math::fill(beta_j, DUMMY_VAR__);

            current_statement_begin__ = 142;
            validate_non_negative_index("beta_array", "k", k);
            validate_non_negative_index("beta_array", "n", n);
            validate_non_negative_index("beta_array", "N", N);
            std::vector<std::vector<std::vector<local_scalar_t__  >  >  > beta_array(k, std::vector<std::vector<local_scalar_t__> >(n, std::vector<local_scalar_t__>(N, local_scalar_t__(DUMMY_VAR__))));
            stan::math::initialize(beta_array, DUMMY_VAR__);
            stan::math::fill(beta_array, DUMMY_VAR__);

            current_statement_begin__ = 146;
            validate_non_negative_index("w", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> w(N);
            stan::math::initialize(w, DUMMY_VAR__);
            stan::math::fill(w, DUMMY_VAR__);


            current_statement_begin__ = 150;
            for (int j = 1; j <= N; ++j) {

                current_statement_begin__ = 152;
                for (int i = 1; i <= k; ++i) {

                    current_statement_begin__ = 153;
                    stan::model::assign(beta_j, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                                normal_rng(get_base1(beta_mean, i, "beta_mean", 1), get_base1(beta_sd, i, "beta_sd", 1), base_rng__), 
                                "assigning variable beta_j");
                }
                current_statement_begin__ = 155;
                for (int t = 1; t <= (n - 1); ++t) {

                    current_statement_begin__ = 156;
                    for (int i = 1; i <= k; ++i) {

                        current_statement_begin__ = 157;
                        stan::model::assign(beta_j, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), 
                                    normal_rng(get_base1(beta_j, i, t, "beta_j", 1), get_base1(sigma_b, i, "sigma_b", 1), base_rng__), 
                                    "assigning variable beta_j");
                    }
                }
                current_statement_begin__ = 161;
                for (int t = 1; t <= n; ++t) {

                    current_statement_begin__ = 162;
                    stan::model::assign(y_rep, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                normal_rng(dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), stan::model::rvalue(beta_j, stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "beta_j")), stan::math::sqrt(get_base1(Ht, t, "Ht", 1)), base_rng__), 
                                "assigning variable y_rep");
                }
                current_statement_begin__ = 165;
                stan::math::assign(beta_j, add(beta_j, gaussian_smoother(subtract(y, y_rep), beta_mean, P1_vector, Ht, diag_matrix(R_vector), xreg, pstream__)));
                current_statement_begin__ = 166;
                stan::model::assign(beta_array, 
                            stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_min_max(1, n), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()))), 
                            to_array_2d(beta_j), 
                            "assigning variable beta_array");
                current_statement_begin__ = 168;
                stan::model::assign(w, 
                            stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                            -(get_base1(loglik, 2, "loglik", 1)), 
                            "assigning variable w");
                current_statement_begin__ = 170;
                for (int t = 1; t <= n; ++t) {
                    {
                    current_statement_begin__ = 171;
                    local_scalar_t__ xbeta(DUMMY_VAR__);
                    (void) xbeta;  // dummy to suppress unused var warning
                    stan::math::initialize(xbeta, DUMMY_VAR__);
                    stan::math::fill(xbeta, DUMMY_VAR__);
                    stan::math::assign(xbeta,dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), stan::model::rvalue(beta_j, stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "beta_j")));


                    current_statement_begin__ = 172;
                    stan::model::assign(w, 
                                stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                                (stan::model::rvalue(w, stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), "w") + (((get_base1(y_original, t, "y_original", 1) * xbeta) - (get_base1(u, t, "u", 1) * stan::math::exp(xbeta))) + ((0.5 * pow((get_base1(y, t, "y", 1) - xbeta), 2)) / get_base1(Ht, t, "Ht", 1)))), 
                                "assigning variable w");
                    }
                }
            }
            {
            current_statement_begin__ = 178;
            validate_non_negative_index("wexp", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> wexp(N);
            stan::math::initialize(wexp, DUMMY_VAR__);
            stan::math::fill(wexp, DUMMY_VAR__);
            stan::math::assign(wexp,stan::math::exp(w));


            current_statement_begin__ = 179;
            stan::math::assign(weights, mean(wexp));
            current_statement_begin__ = 180;
            stan::math::assign(beta, stan::model::rvalue(beta_array, stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_min_max(1, n), stan::model::cons_list(stan::model::index_uni(categorical_rng(divide(wexp, sum(wexp)), base_rng__)), stan::model::nil_index_list()))), "beta_array"));
            }
            }

            // validate, write generated quantities
            current_statement_begin__ = 136;
            size_t beta_k_0_max__ = k;
            size_t beta_k_1_max__ = n;
            for (size_t k_1__ = 0; k_1__ < beta_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < beta_k_0_max__; ++k_0__) {
                    vars__.push_back(beta[k_0__][k_1__]);
                }
            }

            current_statement_begin__ = 137;
            vars__.push_back(weights);

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_rw_glm_model";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t sigma_b_k_0_max__ = k;
        for (size_t k_0__ = 0; k_0__ < sigma_b_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_b" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            size_t R_vector_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < R_vector_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "R_vector" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t P1_vector_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < P1_vector_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "P1_vector" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t loglik_j_1_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < loglik_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "loglik" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
        size_t beta_k_0_max__ = k;
        size_t beta_k_1_max__ = n;
        for (size_t k_1__ = 0; k_1__ < beta_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < beta_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "weights";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t sigma_b_k_0_max__ = k;
        for (size_t k_0__ = 0; k_0__ < sigma_b_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_b" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            size_t R_vector_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < R_vector_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "R_vector" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t P1_vector_j_1_max__ = k;
            for (size_t j_1__ = 0; j_1__ < P1_vector_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "P1_vector" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t loglik_j_1_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < loglik_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "loglik" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
        size_t beta_k_0_max__ = k;
        size_t beta_k_1_max__ = n;
        for (size_t k_1__ = 0; k_1__ < beta_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < beta_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "weights";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

}  // namespace




// Code generated by Stan version 2.19.1

#include <stan/model/model_header.hpp>

namespace model_walker_glm_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_walker_glm");
    reader.add_event(464, 462, "end", "model_walker_glm");
    return reader;
}

template <typename T0__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T8__>
typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__, T8__>::type>::type
gaussian_filter(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                    const std::vector<int>& y_miss,
                    const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& a1,
                    const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& P1,
                    const T4__& Ht,
                    const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& Tt,
                    const Eigen::Matrix<T6__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                    const Eigen::Matrix<T7__, Eigen::Dynamic, Eigen::Dynamic>& xreg,
                    const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& gamma2_y, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__, T8__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 17;
        int k(0);
        (void) k;  // dummy to suppress unused var warning
        stan::math::fill(k, std::numeric_limits<int>::min());
        stan::math::assign(k,rows(xreg));

        current_statement_begin__ = 18;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,rows(y));

        current_statement_begin__ = 19;
        int m(0);
        (void) m;  // dummy to suppress unused var warning
        stan::math::fill(m, std::numeric_limits<int>::min());
        stan::math::assign(m,rows(a1));

        current_statement_begin__ = 20;
        local_scalar_t__ loglik(DUMMY_VAR__);
        (void) loglik;  // dummy to suppress unused var warning
        stan::math::initialize(loglik, DUMMY_VAR__);
        stan::math::fill(loglik, DUMMY_VAR__);
        stan::math::assign(loglik,0.0);

        current_statement_begin__ = 22;
        validate_non_negative_index("x", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> x(m);
        stan::math::initialize(x, DUMMY_VAR__);
        stan::math::fill(x, DUMMY_VAR__);
        stan::math::assign(x,a1);

        current_statement_begin__ = 23;
        validate_non_negative_index("P", "m", m);
        validate_non_negative_index("P", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> P(m, m);
        stan::math::initialize(P, DUMMY_VAR__);
        stan::math::fill(P, DUMMY_VAR__);
        stan::math::assign(P,P1);


        current_statement_begin__ = 25;
        for (int t = 1; t <= n; ++t) {
            {
            current_statement_begin__ = 26;
            local_scalar_t__ F(DUMMY_VAR__);
            (void) F;  // dummy to suppress unused var warning
            stan::math::initialize(F, DUMMY_VAR__);
            stan::math::fill(F, DUMMY_VAR__);
            stan::math::assign(F,(quad_form(stan::model::rvalue(P, stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::nil_index_list())), "P"), stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")) + (get_base1(gamma2_y, t, "gamma2_y", 1) * Ht)));


            current_statement_begin__ = 28;
            if (as_bool((primitive_value(logical_eq(get_base1(y_miss, t, "y_miss", 1), 0)) && primitive_value(logical_gt(F, 1.0e-12))))) {
                {
                current_statement_begin__ = 29;
                local_scalar_t__ v(DUMMY_VAR__);
                (void) v;  // dummy to suppress unused var warning
                stan::math::initialize(v, DUMMY_VAR__);
                stan::math::fill(v, DUMMY_VAR__);
                stan::math::assign(v,(get_base1(y, t, "y", 1) - dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), head(x, k))));

                current_statement_begin__ = 30;
                validate_non_negative_index("K", "m", m);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> K(m);
                stan::math::initialize(K, DUMMY_VAR__);
                stan::math::fill(K, DUMMY_VAR__);
                stan::math::assign(K,divide(multiply(stan::model::rvalue(P, stan::model::cons_list(stan::model::index_min_max(1, m), stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::nil_index_list())), "P"), stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")), F));


                current_statement_begin__ = 31;
                stan::math::assign(x, multiply(Tt, add(x, multiply(K, v))));
                current_statement_begin__ = 32;
                stan::math::assign(P, quad_form_sym(subtract(P, multiply(multiply(K, transpose(K)), F)), transpose(Tt)));
                current_statement_begin__ = 33;
                for (int i = 1; i <= m; ++i) {

                    current_statement_begin__ = 34;
                    stan::model::assign(P, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                (stan::model::rvalue(P, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "P") + get_base1(Rt, i, t, "Rt", 1)), 
                                "assigning variable P");
                }
                current_statement_begin__ = 36;
                stan::math::assign(loglik, (loglik - (0.5 * (stan::math::log(F) + ((v * v) / F)))));
                }
            } else {

                current_statement_begin__ = 38;
                stan::math::assign(x, multiply(Tt, x));
                current_statement_begin__ = 39;
                stan::math::assign(P, quad_form_sym(P, transpose(Tt)));
                current_statement_begin__ = 40;
                for (int i = 1; i <= m; ++i) {

                    current_statement_begin__ = 41;
                    stan::model::assign(P, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                (stan::model::rvalue(P, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "P") + get_base1(Rt, i, t, "Rt", 1)), 
                                "assigning variable P");
                }
            }
            }
        }
        current_statement_begin__ = 45;
        return stan::math::promote_scalar<fun_return_scalar_t__>(loglik);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct gaussian_filter_functor__ {
    template <typename T0__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T8__>
        typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__, T8__>::type>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                    const std::vector<int>& y_miss,
                    const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& a1,
                    const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& P1,
                    const T4__& Ht,
                    const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& Tt,
                    const Eigen::Matrix<T6__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                    const Eigen::Matrix<T7__, Eigen::Dynamic, Eigen::Dynamic>& xreg,
                    const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& gamma2_y, std::ostream* pstream__) const {
        return gaussian_filter(y, y_miss, a1, P1, Ht, Tt, Rt, xreg, gamma2_y, pstream__);
    }
};

template <typename T0__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T8__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__, T8__>::type>::type, Eigen::Dynamic, Eigen::Dynamic>
gaussian_smoother(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                      const std::vector<int>& y_miss,
                      const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& a1,
                      const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& P1,
                      const T4__& Ht,
                      const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& Tt,
                      const Eigen::Matrix<T6__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                      const Eigen::Matrix<T7__, Eigen::Dynamic, Eigen::Dynamic>& xreg,
                      const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& gamma2_y, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__, T8__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 52;
        int k(0);
        (void) k;  // dummy to suppress unused var warning
        stan::math::fill(k, std::numeric_limits<int>::min());
        stan::math::assign(k,rows(xreg));

        current_statement_begin__ = 53;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,rows(y));

        current_statement_begin__ = 54;
        int m(0);
        (void) m;  // dummy to suppress unused var warning
        stan::math::fill(m, std::numeric_limits<int>::min());
        stan::math::assign(m,rows(a1));

        current_statement_begin__ = 55;
        local_scalar_t__ loglik(DUMMY_VAR__);
        (void) loglik;  // dummy to suppress unused var warning
        stan::math::initialize(loglik, DUMMY_VAR__);
        stan::math::fill(loglik, DUMMY_VAR__);
        stan::math::assign(loglik,0.0);

        current_statement_begin__ = 56;
        validate_non_negative_index("x", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> x(m);
        stan::math::initialize(x, DUMMY_VAR__);
        stan::math::fill(x, DUMMY_VAR__);
        stan::math::assign(x,a1);

        current_statement_begin__ = 57;
        validate_non_negative_index("P", "m", m);
        validate_non_negative_index("P", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> P(m, m);
        stan::math::initialize(P, DUMMY_VAR__);
        stan::math::fill(P, DUMMY_VAR__);
        stan::math::assign(P,P1);

        current_statement_begin__ = 58;
        validate_non_negative_index("v", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> v(n);
        stan::math::initialize(v, DUMMY_VAR__);
        stan::math::fill(v, DUMMY_VAR__);

        current_statement_begin__ = 59;
        validate_non_negative_index("F", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> F(n);
        stan::math::initialize(F, DUMMY_VAR__);
        stan::math::fill(F, DUMMY_VAR__);

        current_statement_begin__ = 60;
        validate_non_negative_index("K", "m", m);
        validate_non_negative_index("K", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> K(m, n);
        stan::math::initialize(K, DUMMY_VAR__);
        stan::math::fill(K, DUMMY_VAR__);

        current_statement_begin__ = 61;
        validate_non_negative_index("r", "m", m);
        validate_non_negative_index("r", "(n + 1)", (n + 1));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> r(m, (n + 1));
        stan::math::initialize(r, DUMMY_VAR__);
        stan::math::fill(r, DUMMY_VAR__);

        current_statement_begin__ = 62;
        validate_non_negative_index("tmpr", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmpr(m);
        stan::math::initialize(tmpr, DUMMY_VAR__);
        stan::math::fill(tmpr, DUMMY_VAR__);


        current_statement_begin__ = 64;
        for (int t = 1; t <= n; ++t) {

            current_statement_begin__ = 66;
            stan::model::assign(F, 
                        stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                        (quad_form(stan::model::rvalue(P, stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::nil_index_list())), "P"), stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")) + (get_base1(gamma2_y, t, "gamma2_y", 1) * Ht)), 
                        "assigning variable F");
            current_statement_begin__ = 68;
            if (as_bool((primitive_value(logical_eq(get_base1(y_miss, t, "y_miss", 1), 0)) && primitive_value(logical_gt(get_base1(F, t, "F", 1), 1.0e-12))))) {

                current_statement_begin__ = 69;
                stan::model::assign(v, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            (get_base1(y, t, "y", 1) - dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), head(x, k))), 
                            "assigning variable v");
                current_statement_begin__ = 70;
                stan::model::assign(K, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                            divide(multiply(stan::model::rvalue(P, stan::model::cons_list(stan::model::index_min_max(1, m), stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::nil_index_list())), "P"), stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")), get_base1(F, t, "F", 1)), 
                            "assigning variable K");
                current_statement_begin__ = 71;
                stan::math::assign(x, multiply(Tt, add(x, multiply(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"), get_base1(v, t, "v", 1)))));
                current_statement_begin__ = 72;
                stan::math::assign(P, quad_form_sym(subtract(P, multiply(multiply(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"), transpose(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"))), get_base1(F, t, "F", 1))), transpose(Tt)));
                current_statement_begin__ = 73;
                for (int i = 1; i <= m; ++i) {

                    current_statement_begin__ = 74;
                    stan::model::assign(P, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                (stan::model::rvalue(P, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "P") + get_base1(Rt, i, t, "Rt", 1)), 
                                "assigning variable P");
                }
                current_statement_begin__ = 76;
                stan::math::assign(loglik, (loglik - (0.5 * (stan::math::log(get_base1(F, t, "F", 1)) + ((get_base1(v, t, "v", 1) * get_base1(v, t, "v", 1)) / get_base1(F, t, "F", 1))))));
            } else {

                current_statement_begin__ = 78;
                stan::math::assign(x, multiply(Tt, x));
                current_statement_begin__ = 79;
                stan::math::assign(P, quad_form_sym(P, transpose(Tt)));
                current_statement_begin__ = 80;
                for (int i = 1; i <= m; ++i) {

                    current_statement_begin__ = 81;
                    stan::model::assign(P, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                (stan::model::rvalue(P, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "P") + get_base1(Rt, i, t, "Rt", 1)), 
                                "assigning variable P");
                }
            }
        }
        current_statement_begin__ = 86;
        stan::model::assign(r, 
                    stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((n + 1)), stan::model::nil_index_list())), 
                    rep_vector(0.0, m), 
                    "assigning variable r");
        current_statement_begin__ = 87;
        for (int tt = 1; tt <= n; ++tt) {
            {
            current_statement_begin__ = 88;
            int t(0);
            (void) t;  // dummy to suppress unused var warning
            stan::math::fill(t, std::numeric_limits<int>::min());
            stan::math::assign(t,((n + 1) - tt));

            current_statement_begin__ = 89;
            validate_non_negative_index("tmp", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp(m);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            stan::math::assign(tmp,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), "r"));


            current_statement_begin__ = 90;
            if (as_bool((primitive_value(logical_eq(get_base1(y_miss, t, "y_miss", 1), 0)) && primitive_value(logical_gt(get_base1(F, t, "F", 1), 1.0e-12))))) {
                {
                current_statement_begin__ = 91;
                validate_non_negative_index("tmp2", "m", m);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp2(m);
                stan::math::initialize(tmp2, DUMMY_VAR__);
                stan::math::fill(tmp2, DUMMY_VAR__);
                stan::math::assign(tmp2,rep_vector(0.0, m));


                current_statement_begin__ = 92;
                stan::model::assign(tmp2, 
                            stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::nil_index_list()), 
                            stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), 
                            "assigning variable tmp2");
                current_statement_begin__ = 93;
                stan::model::assign(r, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                            add(divide(multiply(tmp2, get_base1(v, t, "v", 1)), get_base1(F, t, "F", 1)), multiply(transpose(subtract(Tt, multiply(multiply(Tt, stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K")), transpose(tmp2)))), tmp)), 
                            "assigning variable r");
                }
            } else {

                current_statement_begin__ = 95;
                stan::model::assign(r, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                            multiply(transpose(Tt), tmp), 
                            "assigning variable r");
            }
            }
        }
        current_statement_begin__ = 99;
        stan::math::assign(tmpr, stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "r"));
        current_statement_begin__ = 100;
        stan::model::assign(r, 
                    stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    add(a1, multiply(P1, tmpr)), 
                    "assigning variable r");
        current_statement_begin__ = 101;
        for (int t = 2; t <= n; ++t) {
            {
            current_statement_begin__ = 102;
            validate_non_negative_index("tmp", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp(m);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            stan::math::assign(tmp,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::nil_index_list())), "r"));

            current_statement_begin__ = 103;
            validate_non_negative_index("tmp2", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp2(m);
            stan::math::initialize(tmp2, DUMMY_VAR__);
            stan::math::fill(tmp2, DUMMY_VAR__);
            stan::math::assign(tmp2,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "r"));


            current_statement_begin__ = 104;
            stan::model::assign(r, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                        add(multiply(Tt, tmp), elt_multiply(stan::model::rvalue(Rt, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "Rt"), tmp2)), 
                        "assigning variable r");
            }
        }
        current_statement_begin__ = 106;
        return stan::math::promote_scalar<fun_return_scalar_t__>(stan::model::rvalue(r, stan::model::cons_list(stan::model::index_min_max(1, m), stan::model::cons_list(stan::model::index_min_max(1, n), stan::model::nil_index_list())), "r"));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct gaussian_smoother_functor__ {
    template <typename T0__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T8__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__, T8__>::type>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                      const std::vector<int>& y_miss,
                      const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& a1,
                      const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& P1,
                      const T4__& Ht,
                      const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& Tt,
                      const Eigen::Matrix<T6__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                      const Eigen::Matrix<T7__, Eigen::Dynamic, Eigen::Dynamic>& xreg,
                      const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& gamma2_y, std::ostream* pstream__) const {
        return gaussian_smoother(y, y_miss, a1, P1, Ht, Tt, Rt, xreg, gamma2_y, pstream__);
    }
};

template <typename T0__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T10__, typename T11__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__, T10__, typename boost::math::tools::promote_args<T11__>::type>::type>::type, Eigen::Dynamic, 1>
glm_approx_loglik(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                      const std::vector<int>& y_miss,
                      const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& a1,
                      const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& P1,
                      const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& Ht,
                      const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& Tt,
                      const Eigen::Matrix<T6__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                      const Eigen::Matrix<T7__, Eigen::Dynamic, Eigen::Dynamic>& xreg,
                      const int& distribution,
                      const std::vector<int>& u,
                      const Eigen::Matrix<T10__, Eigen::Dynamic, 1>& y_original,
                      const Eigen::Matrix<T11__, Eigen::Dynamic, 1>& xbeta_fixed, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__, T10__, typename boost::math::tools::promote_args<T11__>::type>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 118;
        int k(0);
        (void) k;  // dummy to suppress unused var warning
        stan::math::fill(k, std::numeric_limits<int>::min());
        stan::math::assign(k,rows(xreg));

        current_statement_begin__ = 119;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,rows(y));

        current_statement_begin__ = 120;
        int m(0);
        (void) m;  // dummy to suppress unused var warning
        stan::math::fill(m, std::numeric_limits<int>::min());
        stan::math::assign(m,rows(a1));

        current_statement_begin__ = 121;
        validate_non_negative_index("loglik", "2", 2);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> loglik(2);
        stan::math::initialize(loglik, DUMMY_VAR__);
        stan::math::fill(loglik, DUMMY_VAR__);
        stan::math::assign(loglik,rep_vector(0.0, 2));

        current_statement_begin__ = 122;
        validate_non_negative_index("x", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> x(m);
        stan::math::initialize(x, DUMMY_VAR__);
        stan::math::fill(x, DUMMY_VAR__);
        stan::math::assign(x,a1);

        current_statement_begin__ = 123;
        validate_non_negative_index("P", "m", m);
        validate_non_negative_index("P", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> P(m, m);
        stan::math::initialize(P, DUMMY_VAR__);
        stan::math::fill(P, DUMMY_VAR__);
        stan::math::assign(P,P1);

        current_statement_begin__ = 124;
        validate_non_negative_index("v", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> v(n);
        stan::math::initialize(v, DUMMY_VAR__);
        stan::math::fill(v, DUMMY_VAR__);

        current_statement_begin__ = 125;
        validate_non_negative_index("F", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> F(n);
        stan::math::initialize(F, DUMMY_VAR__);
        stan::math::fill(F, DUMMY_VAR__);

        current_statement_begin__ = 126;
        validate_non_negative_index("K", "m", m);
        validate_non_negative_index("K", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> K(m, n);
        stan::math::initialize(K, DUMMY_VAR__);
        stan::math::fill(K, DUMMY_VAR__);

        current_statement_begin__ = 127;
        validate_non_negative_index("r", "m", m);
        validate_non_negative_index("r", "(n + 1)", (n + 1));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> r(m, (n + 1));
        stan::math::initialize(r, DUMMY_VAR__);
        stan::math::fill(r, DUMMY_VAR__);

        current_statement_begin__ = 128;
        validate_non_negative_index("tmpr", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmpr(m);
        stan::math::initialize(tmpr, DUMMY_VAR__);
        stan::math::fill(tmpr, DUMMY_VAR__);


        current_statement_begin__ = 130;
        for (int t = 1; t <= n; ++t) {

            current_statement_begin__ = 132;
            stan::model::assign(F, 
                        stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                        (quad_form(stan::model::rvalue(P, stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::nil_index_list())), "P"), stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")) + get_base1(Ht, t, "Ht", 1)), 
                        "assigning variable F");
            current_statement_begin__ = 134;
            if (as_bool((primitive_value(logical_eq(get_base1(y_miss, t, "y_miss", 1), 0)) && primitive_value(logical_gt(get_base1(F, t, "F", 1), 1.0e-12))))) {

                current_statement_begin__ = 135;
                stan::model::assign(v, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            (get_base1(y, t, "y", 1) - dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), head(x, k))), 
                            "assigning variable v");
                current_statement_begin__ = 136;
                stan::model::assign(K, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                            divide(multiply(stan::model::rvalue(P, stan::model::cons_list(stan::model::index_min_max(1, m), stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::nil_index_list())), "P"), stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")), get_base1(F, t, "F", 1)), 
                            "assigning variable K");
                current_statement_begin__ = 137;
                stan::math::assign(x, multiply(Tt, add(x, multiply(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"), get_base1(v, t, "v", 1)))));
                current_statement_begin__ = 138;
                stan::math::assign(P, quad_form_sym(subtract(P, multiply(multiply(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"), transpose(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"))), get_base1(F, t, "F", 1))), transpose(Tt)));
                current_statement_begin__ = 139;
                for (int i = 1; i <= m; ++i) {

                    current_statement_begin__ = 140;
                    stan::model::assign(P, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                (stan::model::rvalue(P, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "P") + get_base1(Rt, i, t, "Rt", 1)), 
                                "assigning variable P");
                }
                current_statement_begin__ = 142;
                stan::model::assign(loglik, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            (stan::model::rvalue(loglik, stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), "loglik") - (0.5 * (stan::math::log(get_base1(F, t, "F", 1)) + ((get_base1(v, t, "v", 1) * get_base1(v, t, "v", 1)) / get_base1(F, t, "F", 1))))), 
                            "assigning variable loglik");
            } else {

                current_statement_begin__ = 144;
                stan::math::assign(x, multiply(Tt, x));
                current_statement_begin__ = 145;
                stan::math::assign(P, quad_form_sym(P, transpose(Tt)));
                current_statement_begin__ = 146;
                for (int i = 1; i <= m; ++i) {

                    current_statement_begin__ = 147;
                    stan::model::assign(P, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                (stan::model::rvalue(P, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "P") + get_base1(Rt, i, t, "Rt", 1)), 
                                "assigning variable P");
                }
            }
        }
        current_statement_begin__ = 152;
        stan::model::assign(r, 
                    stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((n + 1)), stan::model::nil_index_list())), 
                    rep_vector(0.0, m), 
                    "assigning variable r");
        current_statement_begin__ = 153;
        for (int tt = 1; tt <= n; ++tt) {
            {
            current_statement_begin__ = 154;
            int t(0);
            (void) t;  // dummy to suppress unused var warning
            stan::math::fill(t, std::numeric_limits<int>::min());
            stan::math::assign(t,((n + 1) - tt));

            current_statement_begin__ = 155;
            validate_non_negative_index("tmp", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp(m);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            stan::math::assign(tmp,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), "r"));


            current_statement_begin__ = 156;
            if (as_bool((primitive_value(logical_eq(get_base1(y_miss, t, "y_miss", 1), 0)) && primitive_value(logical_gt(get_base1(F, t, "F", 1), 1.0e-12))))) {
                {
                current_statement_begin__ = 157;
                validate_non_negative_index("tmp2", "m", m);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp2(m);
                stan::math::initialize(tmp2, DUMMY_VAR__);
                stan::math::fill(tmp2, DUMMY_VAR__);
                stan::math::assign(tmp2,rep_vector(0.0, m));


                current_statement_begin__ = 158;
                stan::model::assign(tmp2, 
                            stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::nil_index_list()), 
                            stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), 
                            "assigning variable tmp2");
                current_statement_begin__ = 159;
                stan::model::assign(r, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                            add(divide(multiply(tmp2, get_base1(v, t, "v", 1)), get_base1(F, t, "F", 1)), multiply(transpose(subtract(Tt, multiply(multiply(Tt, stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K")), transpose(tmp2)))), tmp)), 
                            "assigning variable r");
                }
            } else {

                current_statement_begin__ = 161;
                stan::model::assign(r, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                            multiply(transpose(Tt), tmp), 
                            "assigning variable r");
            }
            }
        }
        current_statement_begin__ = 165;
        stan::math::assign(tmpr, stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "r"));
        current_statement_begin__ = 166;
        stan::model::assign(r, 
                    stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    add(a1, multiply(P1, tmpr)), 
                    "assigning variable r");
        current_statement_begin__ = 167;
        for (int t = 2; t <= n; ++t) {
            {
            current_statement_begin__ = 168;
            validate_non_negative_index("tmp", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp(m);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            stan::math::assign(tmp,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::nil_index_list())), "r"));

            current_statement_begin__ = 169;
            validate_non_negative_index("tmp2", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp2(m);
            stan::math::initialize(tmp2, DUMMY_VAR__);
            stan::math::fill(tmp2, DUMMY_VAR__);
            stan::math::assign(tmp2,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "r"));


            current_statement_begin__ = 170;
            stan::model::assign(r, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                        add(multiply(Tt, tmp), elt_multiply(stan::model::rvalue(Rt, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "Rt"), tmp2)), 
                        "assigning variable r");
            }
        }
        current_statement_begin__ = 174;
        if (as_bool(logical_eq(distribution, 1))) {

            current_statement_begin__ = 175;
            for (int t = 1; t <= n; ++t) {

                current_statement_begin__ = 176;
                if (as_bool(logical_eq(get_base1(y_miss, t, "y_miss", 1), 0))) {
                    {
                    current_statement_begin__ = 177;
                    local_scalar_t__ xbeta_rw(DUMMY_VAR__);
                    (void) xbeta_rw;  // dummy to suppress unused var warning
                    stan::math::initialize(xbeta_rw, DUMMY_VAR__);
                    stan::math::fill(xbeta_rw, DUMMY_VAR__);
                    stan::math::assign(xbeta_rw,dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), stan::model::rvalue(r, stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "r")));


                    current_statement_begin__ = 178;
                    stan::model::assign(loglik, 
                                stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                                (stan::model::rvalue(loglik, stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), "loglik") + (((get_base1(y_original, t, "y_original", 1) * (xbeta_rw + get_base1(xbeta_fixed, t, "xbeta_fixed", 1))) - (get_base1(u, t, "u", 1) * stan::math::exp((xbeta_rw + get_base1(xbeta_fixed, t, "xbeta_fixed", 1))))) + ((0.5 * pow((get_base1(y, t, "y", 1) - xbeta_rw), 2)) / get_base1(Ht, t, "Ht", 1)))), 
                                "assigning variable loglik");
                    }
                }
            }
        } else {

            current_statement_begin__ = 184;
            for (int t = 1; t <= n; ++t) {

                current_statement_begin__ = 185;
                if (as_bool(logical_eq(get_base1(y_miss, t, "y_miss", 1), 0))) {
                    {
                    current_statement_begin__ = 186;
                    local_scalar_t__ xbeta_rw(DUMMY_VAR__);
                    (void) xbeta_rw;  // dummy to suppress unused var warning
                    stan::math::initialize(xbeta_rw, DUMMY_VAR__);
                    stan::math::fill(xbeta_rw, DUMMY_VAR__);
                    stan::math::assign(xbeta_rw,dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), stan::model::rvalue(r, stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "r")));


                    current_statement_begin__ = 187;
                    stan::model::assign(loglik, 
                                stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                                (stan::model::rvalue(loglik, stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), "loglik") + (((get_base1(y_original, t, "y_original", 1) * (xbeta_rw + get_base1(xbeta_fixed, t, "xbeta_fixed", 1))) - (get_base1(u, t, "u", 1) * stan::math::log1p(stan::math::exp((xbeta_rw + get_base1(xbeta_fixed, t, "xbeta_fixed", 1)))))) + ((0.5 * pow((get_base1(y, t, "y", 1) - xbeta_rw), 2)) / get_base1(Ht, t, "Ht", 1)))), 
                                "assigning variable loglik");
                    }
                }
            }
        }
        current_statement_begin__ = 193;
        return stan::math::promote_scalar<fun_return_scalar_t__>(loglik);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct glm_approx_loglik_functor__ {
    template <typename T0__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T10__, typename T11__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__, T10__, typename boost::math::tools::promote_args<T11__>::type>::type>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                      const std::vector<int>& y_miss,
                      const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& a1,
                      const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& P1,
                      const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& Ht,
                      const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& Tt,
                      const Eigen::Matrix<T6__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                      const Eigen::Matrix<T7__, Eigen::Dynamic, Eigen::Dynamic>& xreg,
                      const int& distribution,
                      const std::vector<int>& u,
                      const Eigen::Matrix<T10__, Eigen::Dynamic, 1>& y_original,
                      const Eigen::Matrix<T11__, Eigen::Dynamic, 1>& xbeta_fixed, std::ostream* pstream__) const {
        return glm_approx_loglik(y, y_miss, a1, P1, Ht, Tt, Rt, xreg, distribution, u, y_original, xbeta_fixed, pstream__);
    }
};

template <typename T0__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__>::type>::type, Eigen::Dynamic, Eigen::Dynamic>
glm_approx_smoother(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                        const std::vector<int>& y_miss,
                        const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& a1,
                        const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& P1,
                        const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& Ht,
                        const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& Tt,
                        const Eigen::Matrix<T6__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                        const Eigen::Matrix<T7__, Eigen::Dynamic, Eigen::Dynamic>& xreg, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 203;
        int k(0);
        (void) k;  // dummy to suppress unused var warning
        stan::math::fill(k, std::numeric_limits<int>::min());
        stan::math::assign(k,rows(xreg));

        current_statement_begin__ = 204;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,rows(y));

        current_statement_begin__ = 205;
        int m(0);
        (void) m;  // dummy to suppress unused var warning
        stan::math::fill(m, std::numeric_limits<int>::min());
        stan::math::assign(m,rows(a1));

        current_statement_begin__ = 206;
        validate_non_negative_index("x", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> x(m);
        stan::math::initialize(x, DUMMY_VAR__);
        stan::math::fill(x, DUMMY_VAR__);
        stan::math::assign(x,a1);

        current_statement_begin__ = 207;
        validate_non_negative_index("P", "m", m);
        validate_non_negative_index("P", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> P(m, m);
        stan::math::initialize(P, DUMMY_VAR__);
        stan::math::fill(P, DUMMY_VAR__);
        stan::math::assign(P,P1);

        current_statement_begin__ = 208;
        validate_non_negative_index("v", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> v(n);
        stan::math::initialize(v, DUMMY_VAR__);
        stan::math::fill(v, DUMMY_VAR__);

        current_statement_begin__ = 209;
        validate_non_negative_index("F", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> F(n);
        stan::math::initialize(F, DUMMY_VAR__);
        stan::math::fill(F, DUMMY_VAR__);

        current_statement_begin__ = 210;
        validate_non_negative_index("K", "m", m);
        validate_non_negative_index("K", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> K(m, n);
        stan::math::initialize(K, DUMMY_VAR__);
        stan::math::fill(K, DUMMY_VAR__);

        current_statement_begin__ = 211;
        validate_non_negative_index("r", "m", m);
        validate_non_negative_index("r", "(n + 1)", (n + 1));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> r(m, (n + 1));
        stan::math::initialize(r, DUMMY_VAR__);
        stan::math::fill(r, DUMMY_VAR__);

        current_statement_begin__ = 212;
        validate_non_negative_index("tmpr", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmpr(m);
        stan::math::initialize(tmpr, DUMMY_VAR__);
        stan::math::fill(tmpr, DUMMY_VAR__);


        current_statement_begin__ = 214;
        for (int t = 1; t <= n; ++t) {

            current_statement_begin__ = 216;
            stan::model::assign(F, 
                        stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                        (quad_form(stan::model::rvalue(P, stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::nil_index_list())), "P"), stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")) + get_base1(Ht, t, "Ht", 1)), 
                        "assigning variable F");
            current_statement_begin__ = 218;
            if (as_bool((primitive_value(logical_eq(get_base1(y_miss, t, "y_miss", 1), 0)) && primitive_value(logical_gt(get_base1(F, t, "F", 1), 1.0e-12))))) {

                current_statement_begin__ = 219;
                stan::model::assign(v, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            (get_base1(y, t, "y", 1) - dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), head(x, k))), 
                            "assigning variable v");
                current_statement_begin__ = 220;
                stan::model::assign(K, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                            divide(multiply(stan::model::rvalue(P, stan::model::cons_list(stan::model::index_min_max(1, m), stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::nil_index_list())), "P"), stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")), get_base1(F, t, "F", 1)), 
                            "assigning variable K");
                current_statement_begin__ = 221;
                stan::math::assign(x, multiply(Tt, add(x, multiply(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"), get_base1(v, t, "v", 1)))));
                current_statement_begin__ = 222;
                stan::math::assign(P, quad_form_sym(subtract(P, multiply(multiply(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"), transpose(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"))), get_base1(F, t, "F", 1))), transpose(Tt)));
                current_statement_begin__ = 223;
                for (int i = 1; i <= m; ++i) {

                    current_statement_begin__ = 224;
                    stan::model::assign(P, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                (stan::model::rvalue(P, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "P") + get_base1(Rt, i, t, "Rt", 1)), 
                                "assigning variable P");
                }
            } else {

                current_statement_begin__ = 227;
                stan::math::assign(x, multiply(Tt, x));
                current_statement_begin__ = 228;
                stan::math::assign(P, quad_form_sym(P, transpose(Tt)));
                current_statement_begin__ = 229;
                for (int i = 1; i <= m; ++i) {

                    current_statement_begin__ = 230;
                    stan::model::assign(P, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                (stan::model::rvalue(P, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "P") + get_base1(Rt, i, t, "Rt", 1)), 
                                "assigning variable P");
                }
            }
        }
        current_statement_begin__ = 235;
        stan::model::assign(r, 
                    stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((n + 1)), stan::model::nil_index_list())), 
                    rep_vector(0.0, m), 
                    "assigning variable r");
        current_statement_begin__ = 236;
        for (int tt = 1; tt <= n; ++tt) {
            {
            current_statement_begin__ = 237;
            int t(0);
            (void) t;  // dummy to suppress unused var warning
            stan::math::fill(t, std::numeric_limits<int>::min());
            stan::math::assign(t,((n + 1) - tt));

            current_statement_begin__ = 238;
            validate_non_negative_index("tmp", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp(m);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            stan::math::assign(tmp,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), "r"));


            current_statement_begin__ = 239;
            if (as_bool((primitive_value(logical_eq(get_base1(y_miss, t, "y_miss", 1), 0)) && primitive_value(logical_gt(get_base1(F, t, "F", 1), 1.0e-12))))) {
                {
                current_statement_begin__ = 240;
                validate_non_negative_index("tmp2", "m", m);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp2(m);
                stan::math::initialize(tmp2, DUMMY_VAR__);
                stan::math::fill(tmp2, DUMMY_VAR__);
                stan::math::assign(tmp2,rep_vector(0.0, m));


                current_statement_begin__ = 241;
                stan::model::assign(tmp2, 
                            stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::nil_index_list()), 
                            stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), 
                            "assigning variable tmp2");
                current_statement_begin__ = 242;
                stan::model::assign(r, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                            add(divide(multiply(tmp2, get_base1(v, t, "v", 1)), get_base1(F, t, "F", 1)), multiply(transpose(subtract(Tt, multiply(multiply(Tt, stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K")), transpose(tmp2)))), tmp)), 
                            "assigning variable r");
                }
            } else {

                current_statement_begin__ = 244;
                stan::model::assign(r, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                            multiply(transpose(Tt), tmp), 
                            "assigning variable r");
            }
            }
        }
        current_statement_begin__ = 248;
        stan::math::assign(tmpr, stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "r"));
        current_statement_begin__ = 249;
        stan::model::assign(r, 
                    stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    add(a1, multiply(P1, tmpr)), 
                    "assigning variable r");
        current_statement_begin__ = 250;
        for (int t = 2; t <= n; ++t) {
            {
            current_statement_begin__ = 251;
            validate_non_negative_index("tmp", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp(m);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            stan::math::assign(tmp,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::nil_index_list())), "r"));

            current_statement_begin__ = 252;
            validate_non_negative_index("tmp2", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp2(m);
            stan::math::initialize(tmp2, DUMMY_VAR__);
            stan::math::fill(tmp2, DUMMY_VAR__);
            stan::math::assign(tmp2,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "r"));


            current_statement_begin__ = 253;
            stan::model::assign(r, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                        add(multiply(Tt, tmp), elt_multiply(stan::model::rvalue(Rt, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "Rt"), tmp2)), 
                        "assigning variable r");
            }
        }
        current_statement_begin__ = 256;
        return stan::math::promote_scalar<fun_return_scalar_t__>(stan::model::rvalue(r, stan::model::cons_list(stan::model::index_min_max(1, m), stan::model::cons_list(stan::model::index_min_max(1, n), stan::model::nil_index_list())), "r"));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct glm_approx_smoother_functor__ {
    template <typename T0__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__>::type>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                        const std::vector<int>& y_miss,
                        const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& a1,
                        const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& P1,
                        const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& Ht,
                        const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& Tt,
                        const Eigen::Matrix<T6__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                        const Eigen::Matrix<T7__, Eigen::Dynamic, Eigen::Dynamic>& xreg, std::ostream* pstream__) const {
        return glm_approx_smoother(y, y_miss, a1, P1, Ht, Tt, Rt, xreg, pstream__);
    }
};

class model_walker_glm : public prob_grad {
private:
        int k_fixed;
        int k_rw1;
        int k_rw2;
        int m;
        int k;
        int n;
        matrix_d xreg_fixed;
        matrix_d xreg_rw;
        vector_d y;
        std::vector<int> y_miss;
        double beta_fixed_mean;
        double beta_rw1_mean;
        double beta_rw2_mean;
        double beta_fixed_sd;
        double beta_rw1_sd;
        double beta_rw2_sd;
        double sigma_rw1_mean;
        double sigma_rw2_mean;
        double sigma_rw1_sd;
        double sigma_rw2_sd;
        double slope_mean;
        double slope_sd;
        vector_d Ht;
        vector_d y_original;
        std::vector<int> u;
        int distribution;
        int N;
        matrix_d gamma_rw1;
        matrix_d gamma_rw2;
        vector_d a1;
        matrix_d P1;
        matrix_d Tt;
public:
    model_walker_glm(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_walker_glm(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_walker_glm_namespace::model_walker_glm";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            // initialize data block variables from context__
            current_statement_begin__ = 262;
            context__.validate_dims("data initialization", "k_fixed", "int", context__.to_vec());
            k_fixed = int(0);
            vals_i__ = context__.vals_i("k_fixed");
            pos__ = 0;
            k_fixed = vals_i__[pos__++];
            check_greater_or_equal(function__, "k_fixed", k_fixed, 0);

            current_statement_begin__ = 263;
            context__.validate_dims("data initialization", "k_rw1", "int", context__.to_vec());
            k_rw1 = int(0);
            vals_i__ = context__.vals_i("k_rw1");
            pos__ = 0;
            k_rw1 = vals_i__[pos__++];
            check_greater_or_equal(function__, "k_rw1", k_rw1, 0);

            current_statement_begin__ = 264;
            context__.validate_dims("data initialization", "k_rw2", "int", context__.to_vec());
            k_rw2 = int(0);
            vals_i__ = context__.vals_i("k_rw2");
            pos__ = 0;
            k_rw2 = vals_i__[pos__++];
            check_greater_or_equal(function__, "k_rw2", k_rw2, 0);

            current_statement_begin__ = 265;
            context__.validate_dims("data initialization", "m", "int", context__.to_vec());
            m = int(0);
            vals_i__ = context__.vals_i("m");
            pos__ = 0;
            m = vals_i__[pos__++];
            check_greater_or_equal(function__, "m", m, 0);

            current_statement_begin__ = 266;
            context__.validate_dims("data initialization", "k", "int", context__.to_vec());
            k = int(0);
            vals_i__ = context__.vals_i("k");
            pos__ = 0;
            k = vals_i__[pos__++];
            check_greater_or_equal(function__, "k", k, 0);

            current_statement_begin__ = 267;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            check_greater_or_equal(function__, "n", n, 0);

            current_statement_begin__ = 268;
            validate_non_negative_index("xreg_fixed", "n", n);
            validate_non_negative_index("xreg_fixed", "k_fixed", k_fixed);
            context__.validate_dims("data initialization", "xreg_fixed", "matrix_d", context__.to_vec(n,k_fixed));
            xreg_fixed = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n, k_fixed);
            vals_r__ = context__.vals_r("xreg_fixed");
            pos__ = 0;
            size_t xreg_fixed_j_2_max__ = k_fixed;
            size_t xreg_fixed_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < xreg_fixed_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < xreg_fixed_j_1_max__; ++j_1__) {
                    xreg_fixed(j_1__, j_2__) = vals_r__[pos__++];
                }
            }

            current_statement_begin__ = 269;
            validate_non_negative_index("xreg_rw", "k", k);
            validate_non_negative_index("xreg_rw", "n", n);
            context__.validate_dims("data initialization", "xreg_rw", "matrix_d", context__.to_vec(k,n));
            xreg_rw = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(k, n);
            vals_r__ = context__.vals_r("xreg_rw");
            pos__ = 0;
            size_t xreg_rw_j_2_max__ = n;
            size_t xreg_rw_j_1_max__ = k;
            for (size_t j_2__ = 0; j_2__ < xreg_rw_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < xreg_rw_j_1_max__; ++j_1__) {
                    xreg_rw(j_1__, j_2__) = vals_r__[pos__++];
                }
            }

            current_statement_begin__ = 270;
            validate_non_negative_index("y", "n", n);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(n));
            y = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                y(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 271;
            validate_non_negative_index("y_miss", "n", n);
            context__.validate_dims("data initialization", "y_miss", "int", context__.to_vec(n));
            y_miss = std::vector<int>(n, int(0));
            vals_i__ = context__.vals_i("y_miss");
            pos__ = 0;
            size_t y_miss_k_0_max__ = n;
            for (size_t k_0__ = 0; k_0__ < y_miss_k_0_max__; ++k_0__) {
                y_miss[k_0__] = vals_i__[pos__++];
            }
            size_t y_miss_i_0_max__ = n;
            for (size_t i_0__ = 0; i_0__ < y_miss_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "y_miss[i_0__]", y_miss[i_0__], 0);
            }

            current_statement_begin__ = 272;
            context__.validate_dims("data initialization", "beta_fixed_mean", "double", context__.to_vec());
            beta_fixed_mean = double(0);
            vals_r__ = context__.vals_r("beta_fixed_mean");
            pos__ = 0;
            beta_fixed_mean = vals_r__[pos__++];

            current_statement_begin__ = 273;
            context__.validate_dims("data initialization", "beta_rw1_mean", "double", context__.to_vec());
            beta_rw1_mean = double(0);
            vals_r__ = context__.vals_r("beta_rw1_mean");
            pos__ = 0;
            beta_rw1_mean = vals_r__[pos__++];

            current_statement_begin__ = 274;
            context__.validate_dims("data initialization", "beta_rw2_mean", "double", context__.to_vec());
            beta_rw2_mean = double(0);
            vals_r__ = context__.vals_r("beta_rw2_mean");
            pos__ = 0;
            beta_rw2_mean = vals_r__[pos__++];

            current_statement_begin__ = 275;
            context__.validate_dims("data initialization", "beta_fixed_sd", "double", context__.to_vec());
            beta_fixed_sd = double(0);
            vals_r__ = context__.vals_r("beta_fixed_sd");
            pos__ = 0;
            beta_fixed_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "beta_fixed_sd", beta_fixed_sd, 0);

            current_statement_begin__ = 276;
            context__.validate_dims("data initialization", "beta_rw1_sd", "double", context__.to_vec());
            beta_rw1_sd = double(0);
            vals_r__ = context__.vals_r("beta_rw1_sd");
            pos__ = 0;
            beta_rw1_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "beta_rw1_sd", beta_rw1_sd, 0);

            current_statement_begin__ = 277;
            context__.validate_dims("data initialization", "beta_rw2_sd", "double", context__.to_vec());
            beta_rw2_sd = double(0);
            vals_r__ = context__.vals_r("beta_rw2_sd");
            pos__ = 0;
            beta_rw2_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "beta_rw2_sd", beta_rw2_sd, 0);

            current_statement_begin__ = 279;
            context__.validate_dims("data initialization", "sigma_rw1_mean", "double", context__.to_vec());
            sigma_rw1_mean = double(0);
            vals_r__ = context__.vals_r("sigma_rw1_mean");
            pos__ = 0;
            sigma_rw1_mean = vals_r__[pos__++];

            current_statement_begin__ = 280;
            context__.validate_dims("data initialization", "sigma_rw2_mean", "double", context__.to_vec());
            sigma_rw2_mean = double(0);
            vals_r__ = context__.vals_r("sigma_rw2_mean");
            pos__ = 0;
            sigma_rw2_mean = vals_r__[pos__++];

            current_statement_begin__ = 281;
            context__.validate_dims("data initialization", "sigma_rw1_sd", "double", context__.to_vec());
            sigma_rw1_sd = double(0);
            vals_r__ = context__.vals_r("sigma_rw1_sd");
            pos__ = 0;
            sigma_rw1_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "sigma_rw1_sd", sigma_rw1_sd, 0);

            current_statement_begin__ = 282;
            context__.validate_dims("data initialization", "sigma_rw2_sd", "double", context__.to_vec());
            sigma_rw2_sd = double(0);
            vals_r__ = context__.vals_r("sigma_rw2_sd");
            pos__ = 0;
            sigma_rw2_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "sigma_rw2_sd", sigma_rw2_sd, 0);

            current_statement_begin__ = 284;
            context__.validate_dims("data initialization", "slope_mean", "double", context__.to_vec());
            slope_mean = double(0);
            vals_r__ = context__.vals_r("slope_mean");
            pos__ = 0;
            slope_mean = vals_r__[pos__++];
            check_greater_or_equal(function__, "slope_mean", slope_mean, 0);

            current_statement_begin__ = 285;
            context__.validate_dims("data initialization", "slope_sd", "double", context__.to_vec());
            slope_sd = double(0);
            vals_r__ = context__.vals_r("slope_sd");
            pos__ = 0;
            slope_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "slope_sd", slope_sd, 0);

            current_statement_begin__ = 287;
            validate_non_negative_index("Ht", "n", n);
            context__.validate_dims("data initialization", "Ht", "vector_d", context__.to_vec(n));
            Ht = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("Ht");
            pos__ = 0;
            size_t Ht_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < Ht_j_1_max__; ++j_1__) {
                Ht(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 288;
            validate_non_negative_index("y_original", "n", n);
            context__.validate_dims("data initialization", "y_original", "vector_d", context__.to_vec(n));
            y_original = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("y_original");
            pos__ = 0;
            size_t y_original_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y_original_j_1_max__; ++j_1__) {
                y_original(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 289;
            validate_non_negative_index("u", "n", n);
            context__.validate_dims("data initialization", "u", "int", context__.to_vec(n));
            u = std::vector<int>(n, int(0));
            vals_i__ = context__.vals_i("u");
            pos__ = 0;
            size_t u_k_0_max__ = n;
            for (size_t k_0__ = 0; k_0__ < u_k_0_max__; ++k_0__) {
                u[k_0__] = vals_i__[pos__++];
            }
            size_t u_i_0_max__ = n;
            for (size_t i_0__ = 0; i_0__ < u_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "u[i_0__]", u[i_0__], 0);
            }

            current_statement_begin__ = 290;
            context__.validate_dims("data initialization", "distribution", "int", context__.to_vec());
            distribution = int(0);
            vals_i__ = context__.vals_i("distribution");
            pos__ = 0;
            distribution = vals_i__[pos__++];

            current_statement_begin__ = 291;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 0);

            current_statement_begin__ = 292;
            validate_non_negative_index("gamma_rw1", "k_rw1", k_rw1);
            validate_non_negative_index("gamma_rw1", "n", n);
            context__.validate_dims("data initialization", "gamma_rw1", "matrix_d", context__.to_vec(k_rw1,n));
            gamma_rw1 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(k_rw1, n);
            vals_r__ = context__.vals_r("gamma_rw1");
            pos__ = 0;
            size_t gamma_rw1_j_2_max__ = n;
            size_t gamma_rw1_j_1_max__ = k_rw1;
            for (size_t j_2__ = 0; j_2__ < gamma_rw1_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < gamma_rw1_j_1_max__; ++j_1__) {
                    gamma_rw1(j_1__, j_2__) = vals_r__[pos__++];
                }
            }

            current_statement_begin__ = 293;
            validate_non_negative_index("gamma_rw2", "k_rw2", k_rw2);
            validate_non_negative_index("gamma_rw2", "n", n);
            context__.validate_dims("data initialization", "gamma_rw2", "matrix_d", context__.to_vec(k_rw2,n));
            gamma_rw2 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(k_rw2, n);
            vals_r__ = context__.vals_r("gamma_rw2");
            pos__ = 0;
            size_t gamma_rw2_j_2_max__ = n;
            size_t gamma_rw2_j_1_max__ = k_rw2;
            for (size_t j_2__ = 0; j_2__ < gamma_rw2_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < gamma_rw2_j_1_max__; ++j_1__) {
                    gamma_rw2(j_1__, j_2__) = vals_r__[pos__++];
                }
            }


            // initialize transformed data variables
            current_statement_begin__ = 297;
            validate_non_negative_index("a1", "m", m);
            a1 = Eigen::Matrix<double, Eigen::Dynamic, 1>(m);
            stan::math::fill(a1, DUMMY_VAR__);

            current_statement_begin__ = 298;
            validate_non_negative_index("P1", "m", m);
            validate_non_negative_index("P1", "m", m);
            P1 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(m, m);
            stan::math::fill(P1, DUMMY_VAR__);
            stan::math::assign(P1,rep_matrix(0.0, m, m));

            current_statement_begin__ = 299;
            validate_non_negative_index("Tt", "m", m);
            validate_non_negative_index("Tt", "m", m);
            Tt = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(m, m);
            stan::math::fill(Tt, DUMMY_VAR__);
            stan::math::assign(Tt,diag_matrix(rep_vector(1.0, m)));

            // execute transformed data statements
            current_statement_begin__ = 301;
            stan::model::assign(Tt, 
                        stan::model::cons_list(stan::model::index_min_max((k_rw1 + 1), k), stan::model::cons_list(stan::model::index_min_max((k + 1), m), stan::model::nil_index_list())), 
                        diag_matrix(rep_vector(1.0, k_rw2)), 
                        "assigning variable Tt");
            current_statement_begin__ = 303;
            for (int i = 1; i <= k_rw1; ++i) {

                current_statement_begin__ = 304;
                stan::model::assign(a1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            beta_rw1_mean, 
                            "assigning variable a1");
                current_statement_begin__ = 305;
                stan::model::assign(P1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                            pow(beta_rw1_sd, 2), 
                            "assigning variable P1");
            }
            current_statement_begin__ = 307;
            for (int i = (k_rw1 + 1); i <= k; ++i) {

                current_statement_begin__ = 308;
                stan::model::assign(a1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            beta_rw2_mean, 
                            "assigning variable a1");
                current_statement_begin__ = 309;
                stan::model::assign(P1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                            pow(beta_rw2_sd, 2), 
                            "assigning variable P1");
            }
            current_statement_begin__ = 311;
            for (int i = (k + 1); i <= m; ++i) {

                current_statement_begin__ = 312;
                stan::model::assign(a1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            slope_mean, 
                            "assigning variable a1");
                current_statement_begin__ = 313;
                stan::model::assign(P1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                            pow(slope_sd, 2), 
                            "assigning variable P1");
            }

            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 319;
            validate_non_negative_index("beta_fixed", "k_fixed", k_fixed);
            num_params_r__ += k_fixed;
            current_statement_begin__ = 320;
            validate_non_negative_index("sigma_rw1", "k_rw1", k_rw1);
            num_params_r__ += (1 * k_rw1);
            current_statement_begin__ = 321;
            validate_non_negative_index("sigma_rw2", "k_rw2", k_rw2);
            num_params_r__ += (1 * k_rw2);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_walker_glm() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        current_statement_begin__ = 319;
        if (!(context__.contains_r("beta_fixed")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta_fixed missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta_fixed");
        pos__ = 0U;
        validate_non_negative_index("beta_fixed", "k_fixed", k_fixed);
        context__.validate_dims("parameter initialization", "beta_fixed", "vector_d", context__.to_vec(k_fixed));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta_fixed(k_fixed);
        size_t beta_fixed_j_1_max__ = k_fixed;
        for (size_t j_1__ = 0; j_1__ < beta_fixed_j_1_max__; ++j_1__) {
            beta_fixed(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta_fixed);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta_fixed: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 320;
        if (!(context__.contains_r("sigma_rw1")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_rw1 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_rw1");
        pos__ = 0U;
        validate_non_negative_index("sigma_rw1", "k_rw1", k_rw1);
        context__.validate_dims("parameter initialization", "sigma_rw1", "double", context__.to_vec(k_rw1));
        std::vector<double> sigma_rw1(k_rw1, double(0));
        size_t sigma_rw1_k_0_max__ = k_rw1;
        for (size_t k_0__ = 0; k_0__ < sigma_rw1_k_0_max__; ++k_0__) {
            sigma_rw1[k_0__] = vals_r__[pos__++];
        }
        size_t sigma_rw1_i_0_max__ = k_rw1;
        for (size_t i_0__ = 0; i_0__ < sigma_rw1_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, sigma_rw1[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_rw1: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }

        current_statement_begin__ = 321;
        if (!(context__.contains_r("sigma_rw2")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_rw2 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_rw2");
        pos__ = 0U;
        validate_non_negative_index("sigma_rw2", "k_rw2", k_rw2);
        context__.validate_dims("parameter initialization", "sigma_rw2", "double", context__.to_vec(k_rw2));
        std::vector<double> sigma_rw2(k_rw2, double(0));
        size_t sigma_rw2_k_0_max__ = k_rw2;
        for (size_t k_0__ = 0; k_0__ < sigma_rw2_k_0_max__; ++k_0__) {
            sigma_rw2[k_0__] = vals_r__[pos__++];
        }
        size_t sigma_rw2_i_0_max__ = k_rw2;
        for (size_t i_0__ = 0; i_0__ < sigma_rw2_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, sigma_rw2[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_rw2: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);

            // model parameters
            current_statement_begin__ = 319;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta_fixed;
            (void) beta_fixed;  // dummy to suppress unused var warning
            if (jacobian__)
                beta_fixed = in__.vector_constrain(k_fixed, lp__);
            else
                beta_fixed = in__.vector_constrain(k_fixed);

            current_statement_begin__ = 320;
            std::vector<local_scalar_t__> sigma_rw1;
            size_t sigma_rw1_d_0_max__ = k_rw1;
            sigma_rw1.reserve(sigma_rw1_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < sigma_rw1_d_0_max__; ++d_0__) {
                if (jacobian__)
                    sigma_rw1.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    sigma_rw1.push_back(in__.scalar_lb_constrain(0));
            }

            current_statement_begin__ = 321;
            std::vector<local_scalar_t__> sigma_rw2;
            size_t sigma_rw2_d_0_max__ = k_rw2;
            sigma_rw2.reserve(sigma_rw2_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < sigma_rw2_d_0_max__; ++d_0__) {
                if (jacobian__)
                    sigma_rw2.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    sigma_rw2.push_back(in__.scalar_lb_constrain(0));
            }

            // transformed parameters
            current_statement_begin__ = 325;
            validate_non_negative_index("Rt", "m", m);
            validate_non_negative_index("Rt", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> Rt(m, n);
            stan::math::initialize(Rt, DUMMY_VAR__);
            stan::math::fill(Rt, DUMMY_VAR__);
            stan::math::assign(Rt,rep_matrix(0.0, m, n));

            current_statement_begin__ = 326;
            validate_non_negative_index("xbeta", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> xbeta(n);
            stan::math::initialize(xbeta, DUMMY_VAR__);
            stan::math::fill(xbeta, DUMMY_VAR__);

            current_statement_begin__ = 327;
            validate_non_negative_index("y_", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> y_(n);
            stan::math::initialize(y_, DUMMY_VAR__);
            stan::math::fill(y_, DUMMY_VAR__);

            current_statement_begin__ = 328;
            validate_non_negative_index("loglik", "2", 2);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> loglik(2);
            stan::math::initialize(loglik, DUMMY_VAR__);
            stan::math::fill(loglik, DUMMY_VAR__);

            // transformed parameters block statements
            current_statement_begin__ = 330;
            if (as_bool(logical_gt(k_fixed, 0))) {

                current_statement_begin__ = 331;
                stan::math::assign(xbeta, multiply(xreg_fixed, beta_fixed));
            } else {

                current_statement_begin__ = 333;
                stan::math::assign(xbeta, rep_vector(0.0, n));
            }
            current_statement_begin__ = 335;
            stan::math::assign(y_, subtract(y, xbeta));
            current_statement_begin__ = 337;
            for (int t = 1; t <= n; ++t) {

                current_statement_begin__ = 338;
                for (int i = 1; i <= k_rw1; ++i) {

                    current_statement_begin__ = 339;
                    stan::model::assign(Rt, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                pow((get_base1(gamma_rw1, i, t, "gamma_rw1", 1) * get_base1(sigma_rw1, i, "sigma_rw1", 1)), 2), 
                                "assigning variable Rt");
                }
                current_statement_begin__ = 341;
                for (int i = 1; i <= k_rw2; ++i) {

                    current_statement_begin__ = 342;
                    stan::model::assign(Rt, 
                                stan::model::cons_list(stan::model::index_uni((k + i)), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                pow((get_base1(gamma_rw2, i, t, "gamma_rw2", 1) * get_base1(sigma_rw2, i, "sigma_rw2", 1)), 2), 
                                "assigning variable Rt");
                }
            }
            current_statement_begin__ = 346;
            stan::math::assign(loglik, glm_approx_loglik(y_, y_miss, a1, P1, Ht, Tt, Rt, xreg_rw, distribution, u, y_original, xbeta, pstream__));

            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            current_statement_begin__ = 325;
            size_t Rt_j_1_max__ = m;
            size_t Rt_j_2_max__ = n;
            for (size_t j_1__ = 0; j_1__ < Rt_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < Rt_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(Rt(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: Rt" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable Rt: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 326;
            size_t xbeta_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < xbeta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(xbeta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: xbeta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable xbeta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 327;
            size_t y__j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y__j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(y_(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: y_" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable y_: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 328;
            size_t loglik_j_1_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < loglik_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(loglik(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: loglik" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable loglik: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }

            // model body

            current_statement_begin__ = 352;
            lp_accum__.add(normal_log<propto__>(beta_fixed, beta_fixed_mean, beta_fixed_sd));
            current_statement_begin__ = 353;
            lp_accum__.add(normal_log<propto__>(sigma_rw1, sigma_rw1_mean, sigma_rw1_sd));
            current_statement_begin__ = 354;
            lp_accum__.add(normal_log<propto__>(sigma_rw2, sigma_rw2_mean, sigma_rw2_sd));
            current_statement_begin__ = 355;
            lp_accum__.add(sum(loglik));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("beta_fixed");
        names__.push_back("sigma_rw1");
        names__.push_back("sigma_rw2");
        names__.push_back("Rt");
        names__.push_back("xbeta");
        names__.push_back("y_");
        names__.push_back("loglik");
        names__.push_back("beta_rw");
        names__.push_back("slope");
        names__.push_back("weights");
        names__.push_back("y_fit");
        names__.push_back("y_rep");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(k_fixed);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k_rw1);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k_rw2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(m);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k_rw2);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_walker_glm_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning

        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta_fixed = in__.vector_constrain(k_fixed);
        size_t beta_fixed_j_1_max__ = k_fixed;
        for (size_t j_1__ = 0; j_1__ < beta_fixed_j_1_max__; ++j_1__) {
            vars__.push_back(beta_fixed(j_1__));
        }

        std::vector<double> sigma_rw1;
        size_t sigma_rw1_d_0_max__ = k_rw1;
        sigma_rw1.reserve(sigma_rw1_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < sigma_rw1_d_0_max__; ++d_0__) {
            sigma_rw1.push_back(in__.scalar_lb_constrain(0));
        }
        size_t sigma_rw1_k_0_max__ = k_rw1;
        for (size_t k_0__ = 0; k_0__ < sigma_rw1_k_0_max__; ++k_0__) {
            vars__.push_back(sigma_rw1[k_0__]);
        }

        std::vector<double> sigma_rw2;
        size_t sigma_rw2_d_0_max__ = k_rw2;
        sigma_rw2.reserve(sigma_rw2_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < sigma_rw2_d_0_max__; ++d_0__) {
            sigma_rw2.push_back(in__.scalar_lb_constrain(0));
        }
        size_t sigma_rw2_k_0_max__ = k_rw2;
        for (size_t k_0__ = 0; k_0__ < sigma_rw2_k_0_max__; ++k_0__) {
            vars__.push_back(sigma_rw2[k_0__]);
        }

        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        if (!include_tparams__ && !include_gqs__) return;

        try {
            // declare and define transformed parameters
            current_statement_begin__ = 325;
            validate_non_negative_index("Rt", "m", m);
            validate_non_negative_index("Rt", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Rt(m, n);
            stan::math::initialize(Rt, DUMMY_VAR__);
            stan::math::fill(Rt, DUMMY_VAR__);
            stan::math::assign(Rt,rep_matrix(0.0, m, n));

            current_statement_begin__ = 326;
            validate_non_negative_index("xbeta", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> xbeta(n);
            stan::math::initialize(xbeta, DUMMY_VAR__);
            stan::math::fill(xbeta, DUMMY_VAR__);

            current_statement_begin__ = 327;
            validate_non_negative_index("y_", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> y_(n);
            stan::math::initialize(y_, DUMMY_VAR__);
            stan::math::fill(y_, DUMMY_VAR__);

            current_statement_begin__ = 328;
            validate_non_negative_index("loglik", "2", 2);
            Eigen::Matrix<double, Eigen::Dynamic, 1> loglik(2);
            stan::math::initialize(loglik, DUMMY_VAR__);
            stan::math::fill(loglik, DUMMY_VAR__);

            // do transformed parameters statements
            current_statement_begin__ = 330;
            if (as_bool(logical_gt(k_fixed, 0))) {

                current_statement_begin__ = 331;
                stan::math::assign(xbeta, multiply(xreg_fixed, beta_fixed));
            } else {

                current_statement_begin__ = 333;
                stan::math::assign(xbeta, rep_vector(0.0, n));
            }
            current_statement_begin__ = 335;
            stan::math::assign(y_, subtract(y, xbeta));
            current_statement_begin__ = 337;
            for (int t = 1; t <= n; ++t) {

                current_statement_begin__ = 338;
                for (int i = 1; i <= k_rw1; ++i) {

                    current_statement_begin__ = 339;
                    stan::model::assign(Rt, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                pow((get_base1(gamma_rw1, i, t, "gamma_rw1", 1) * get_base1(sigma_rw1, i, "sigma_rw1", 1)), 2), 
                                "assigning variable Rt");
                }
                current_statement_begin__ = 341;
                for (int i = 1; i <= k_rw2; ++i) {

                    current_statement_begin__ = 342;
                    stan::model::assign(Rt, 
                                stan::model::cons_list(stan::model::index_uni((k + i)), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                pow((get_base1(gamma_rw2, i, t, "gamma_rw2", 1) * get_base1(sigma_rw2, i, "sigma_rw2", 1)), 2), 
                                "assigning variable Rt");
                }
            }
            current_statement_begin__ = 346;
            stan::math::assign(loglik, glm_approx_loglik(y_, y_miss, a1, P1, Ht, Tt, Rt, xreg_rw, distribution, u, y_original, xbeta, pstream__));

            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            // write transformed parameters
            if (include_tparams__) {
                size_t Rt_j_2_max__ = n;
                size_t Rt_j_1_max__ = m;
                for (size_t j_2__ = 0; j_2__ < Rt_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < Rt_j_1_max__; ++j_1__) {
                        vars__.push_back(Rt(j_1__, j_2__));
                    }
                }
                size_t xbeta_j_1_max__ = n;
                for (size_t j_1__ = 0; j_1__ < xbeta_j_1_max__; ++j_1__) {
                    vars__.push_back(xbeta(j_1__));
                }
                size_t y__j_1_max__ = n;
                for (size_t j_1__ = 0; j_1__ < y__j_1_max__; ++j_1__) {
                    vars__.push_back(y_(j_1__));
                }
                size_t loglik_j_1_max__ = 2;
                for (size_t j_1__ = 0; j_1__ < loglik_j_1_max__; ++j_1__) {
                    vars__.push_back(loglik(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 361;
            validate_non_negative_index("beta_rw", "k", k);
            validate_non_negative_index("beta_rw", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> beta_rw(k, n);
            stan::math::initialize(beta_rw, DUMMY_VAR__);
            stan::math::fill(beta_rw, DUMMY_VAR__);

            current_statement_begin__ = 362;
            validate_non_negative_index("slope", "k_rw2", k_rw2);
            validate_non_negative_index("slope", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> slope(k_rw2, n);
            stan::math::initialize(slope, DUMMY_VAR__);
            stan::math::fill(slope, DUMMY_VAR__);

            current_statement_begin__ = 363;
            double weights;
            (void) weights;  // dummy to suppress unused var warning
            stan::math::initialize(weights, DUMMY_VAR__);
            stan::math::fill(weights, DUMMY_VAR__);

            current_statement_begin__ = 364;
            validate_non_negative_index("y_fit", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> y_fit(n);
            stan::math::initialize(y_fit, DUMMY_VAR__);
            stan::math::fill(y_fit, DUMMY_VAR__);

            current_statement_begin__ = 365;
            validate_non_negative_index("y_rep", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> y_rep(n);
            stan::math::initialize(y_rep, DUMMY_VAR__);
            stan::math::fill(y_rep, DUMMY_VAR__);

            // generated quantities statements
            {
            current_statement_begin__ = 369;
            validate_non_negative_index("y_rep_j", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> y_rep_j(n);
            stan::math::initialize(y_rep_j, DUMMY_VAR__);
            stan::math::fill(y_rep_j, DUMMY_VAR__);

            current_statement_begin__ = 370;
            validate_non_negative_index("beta_j", "k", k);
            validate_non_negative_index("beta_j", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> beta_j(k, n);
            stan::math::initialize(beta_j, DUMMY_VAR__);
            stan::math::fill(beta_j, DUMMY_VAR__);

            current_statement_begin__ = 371;
            validate_non_negative_index("slope_j", "k_rw2", k_rw2);
            validate_non_negative_index("slope_j", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> slope_j(k_rw2, n);
            stan::math::initialize(slope_j, DUMMY_VAR__);
            stan::math::fill(slope_j, DUMMY_VAR__);

            current_statement_begin__ = 372;
            validate_non_negative_index("beta_array", "k", k);
            validate_non_negative_index("beta_array", "n", n);
            validate_non_negative_index("beta_array", "N", N);
            std::vector<std::vector<std::vector<local_scalar_t__  >  >  > beta_array(k, std::vector<std::vector<local_scalar_t__> >(n, std::vector<local_scalar_t__>(N, local_scalar_t__(DUMMY_VAR__))));
            stan::math::initialize(beta_array, DUMMY_VAR__);
            stan::math::fill(beta_array, DUMMY_VAR__);

            current_statement_begin__ = 373;
            validate_non_negative_index("slope_array", "k_rw2", k_rw2);
            validate_non_negative_index("slope_array", "n", n);
            validate_non_negative_index("slope_array", "N", N);
            std::vector<std::vector<std::vector<local_scalar_t__  >  >  > slope_array(k_rw2, std::vector<std::vector<local_scalar_t__> >(n, std::vector<local_scalar_t__>(N, local_scalar_t__(DUMMY_VAR__))));
            stan::math::initialize(slope_array, DUMMY_VAR__);
            stan::math::fill(slope_array, DUMMY_VAR__);

            current_statement_begin__ = 374;
            validate_non_negative_index("w", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> w(N);
            stan::math::initialize(w, DUMMY_VAR__);
            stan::math::fill(w, DUMMY_VAR__);
            stan::math::assign(w,rep_vector(0.0, N));


            current_statement_begin__ = 381;
            for (int j = 1; j <= N; ++j) {

                current_statement_begin__ = 383;
                for (int i = 1; i <= k_rw1; ++i) {

                    current_statement_begin__ = 384;
                    stan::model::assign(beta_j, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                                normal_rng(beta_rw1_mean, beta_rw1_sd, base_rng__), 
                                "assigning variable beta_j");
                }
                current_statement_begin__ = 386;
                for (int i = 1; i <= k_rw2; ++i) {

                    current_statement_begin__ = 387;
                    stan::model::assign(beta_j, 
                                stan::model::cons_list(stan::model::index_uni((k_rw1 + i)), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                                normal_rng(beta_rw2_mean, beta_rw2_sd, base_rng__), 
                                "assigning variable beta_j");
                    current_statement_begin__ = 388;
                    stan::model::assign(slope_j, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                                normal_rng(slope_mean, slope_sd, base_rng__), 
                                "assigning variable slope_j");
                }
                current_statement_begin__ = 391;
                for (int t = 1; t <= (n - 1); ++t) {

                    current_statement_begin__ = 392;
                    for (int i = 1; i <= k_rw1; ++i) {

                        current_statement_begin__ = 393;
                        stan::model::assign(beta_j, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), 
                                    normal_rng(get_base1(beta_j, i, t, "beta_j", 1), (get_base1(gamma_rw1, i, t, "gamma_rw1", 1) * get_base1(sigma_rw1, i, "sigma_rw1", 1)), base_rng__), 
                                    "assigning variable beta_j");
                    }
                    current_statement_begin__ = 395;
                    for (int i = 1; i <= k_rw2; ++i) {

                        current_statement_begin__ = 396;
                        stan::model::assign(beta_j, 
                                    stan::model::cons_list(stan::model::index_uni((k_rw1 + i)), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), 
                                    (get_base1(beta_j, (k_rw1 + i), t, "beta_j", 1) + get_base1(slope_j, i, t, "slope_j", 1)), 
                                    "assigning variable beta_j");
                        current_statement_begin__ = 397;
                        stan::model::assign(slope_j, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), 
                                    normal_rng(get_base1(slope_j, i, t, "slope_j", 1), (get_base1(gamma_rw2, i, t, "gamma_rw2", 1) * get_base1(sigma_rw2, i, "sigma_rw2", 1)), base_rng__), 
                                    "assigning variable slope_j");
                    }
                }
                current_statement_begin__ = 401;
                for (int t = 1; t <= n; ++t) {

                    current_statement_begin__ = 402;
                    stan::model::assign(y_rep_j, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                normal_rng(dot_product(stan::model::rvalue(xreg_rw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg_rw"), stan::model::rvalue(beta_j, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "beta_j")), stan::math::sqrt(get_base1(Ht, t, "Ht", 1)), base_rng__), 
                                "assigning variable y_rep_j");
                }
                {
                current_statement_begin__ = 406;
                validate_non_negative_index("states", "m", m);
                validate_non_negative_index("states", "n", n);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> states(m, n);
                stan::math::initialize(states, DUMMY_VAR__);
                stan::math::fill(states, DUMMY_VAR__);
                stan::math::assign(states,glm_approx_smoother(subtract(y_, y_rep_j), y_miss, a1, P1, Ht, Tt, Rt, xreg_rw, pstream__));


                current_statement_begin__ = 408;
                stan::math::assign(beta_j, add(beta_j, stan::model::rvalue(states, stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_min_max(1, n), stan::model::nil_index_list())), "states")));
                current_statement_begin__ = 409;
                stan::math::assign(slope_j, add(slope_j, stan::model::rvalue(states, stan::model::cons_list(stan::model::index_min_max((k + 1), m), stan::model::cons_list(stan::model::index_min_max(1, n), stan::model::nil_index_list())), "states")));
                }
                current_statement_begin__ = 412;
                stan::model::assign(beta_array, 
                            stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_min_max(1, n), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()))), 
                            to_array_2d(beta_j), 
                            "assigning variable beta_array");
                current_statement_begin__ = 413;
                stan::model::assign(slope_array, 
                            stan::model::cons_list(stan::model::index_min_max(1, k_rw2), stan::model::cons_list(stan::model::index_min_max(1, n), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()))), 
                            to_array_2d(slope_j), 
                            "assigning variable slope_array");
                current_statement_begin__ = 415;
                stan::model::assign(w, 
                            stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                            -(get_base1(loglik, 2, "loglik", 1)), 
                            "assigning variable w");
                current_statement_begin__ = 416;
                if (as_bool(logical_eq(distribution, 1))) {

                    current_statement_begin__ = 417;
                    for (int t = 1; t <= n; ++t) {
                        {
                        current_statement_begin__ = 418;
                        local_scalar_t__ xbeta_tmp(DUMMY_VAR__);
                        (void) xbeta_tmp;  // dummy to suppress unused var warning
                        stan::math::initialize(xbeta_tmp, DUMMY_VAR__);
                        stan::math::fill(xbeta_tmp, DUMMY_VAR__);
                        stan::math::assign(xbeta_tmp,(get_base1(xbeta, t, "xbeta", 1) + dot_product(stan::model::rvalue(xreg_rw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg_rw"), stan::model::rvalue(beta_j, stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "beta_j"))));


                        current_statement_begin__ = 419;
                        stan::model::assign(w, 
                                    stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(w, stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), "w") + (((get_base1(y_original, t, "y_original", 1) * xbeta_tmp) - (get_base1(u, t, "u", 1) * stan::math::exp(xbeta_tmp))) + ((0.5 * pow((get_base1(y, t, "y", 1) - xbeta_tmp), 2)) / get_base1(Ht, t, "Ht", 1)))), 
                                    "assigning variable w");
                        }
                    }
                } else {

                    current_statement_begin__ = 423;
                    for (int t = 1; t <= n; ++t) {
                        {
                        current_statement_begin__ = 424;
                        local_scalar_t__ xbeta_tmp(DUMMY_VAR__);
                        (void) xbeta_tmp;  // dummy to suppress unused var warning
                        stan::math::initialize(xbeta_tmp, DUMMY_VAR__);
                        stan::math::fill(xbeta_tmp, DUMMY_VAR__);
                        stan::math::assign(xbeta_tmp,(get_base1(xbeta, t, "xbeta", 1) + dot_product(stan::model::rvalue(xreg_rw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg_rw"), stan::model::rvalue(beta_j, stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "beta_j"))));


                        current_statement_begin__ = 425;
                        stan::model::assign(w, 
                                    stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(w, stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), "w") + (((get_base1(y_original, t, "y_original", 1) * xbeta_tmp) - (get_base1(u, t, "u", 1) * stan::math::log1p(stan::math::exp(xbeta_tmp)))) + ((0.5 * pow((get_base1(y, t, "y", 1) - xbeta_tmp), 2)) / get_base1(Ht, t, "Ht", 1)))), 
                                    "assigning variable w");
                        }
                    }
                }
            }
            {
            current_statement_begin__ = 438;
            int index(0);
            (void) index;  // dummy to suppress unused var warning
            stan::math::fill(index, std::numeric_limits<int>::min());

            current_statement_begin__ = 439;
            validate_non_negative_index("expw", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> expw(N);
            stan::math::initialize(expw, DUMMY_VAR__);
            stan::math::fill(expw, DUMMY_VAR__);
            stan::math::assign(expw,stan::math::exp(w));


            current_statement_begin__ = 440;
            stan::math::assign(weights, mean(expw));
            current_statement_begin__ = 441;
            stan::math::assign(index, categorical_rng(divide(expw, sum(expw)), base_rng__));
            current_statement_begin__ = 442;
            stan::math::assign(beta_rw, to_matrix(stan::model::rvalue(beta_array, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(index), stan::model::nil_index_list()))), "beta_array")));
            current_statement_begin__ = 443;
            if (as_bool(logical_gt(k_rw2, 0))) {
                current_statement_begin__ = 443;
                stan::math::assign(slope, to_matrix(stan::model::rvalue(slope_array, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(index), stan::model::nil_index_list()))), "slope_array")));
            }
            current_statement_begin__ = 447;
            if (as_bool(logical_eq(distribution, 1))) {

                current_statement_begin__ = 448;
                for (int t = 1; t <= n; ++t) {

                    current_statement_begin__ = 449;
                    stan::model::assign(y_fit, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                (get_base1(u, t, "u", 1) * stan::math::exp((get_base1(xbeta, t, "xbeta", 1) + dot_product(stan::model::rvalue(xreg_rw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg_rw"), stan::model::rvalue(beta_rw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "beta_rw"))))), 
                                "assigning variable y_fit");
                    current_statement_begin__ = 450;
                    stan::model::assign(y_rep, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                poisson_rng(get_base1(y_fit, t, "y_fit", 1), base_rng__), 
                                "assigning variable y_rep");
                }
            } else {

                current_statement_begin__ = 453;
                for (int t = 1; t <= n; ++t) {
                    {
                    current_statement_begin__ = 454;
                    local_scalar_t__ tmp(DUMMY_VAR__);
                    (void) tmp;  // dummy to suppress unused var warning
                    stan::math::initialize(tmp, DUMMY_VAR__);
                    stan::math::fill(tmp, DUMMY_VAR__);
                    stan::math::assign(tmp,stan::math::exp((get_base1(xbeta, t, "xbeta", 1) + dot_product(stan::model::rvalue(xreg_rw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg_rw"), stan::model::rvalue(beta_rw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "beta_rw")))));


                    current_statement_begin__ = 455;
                    stan::model::assign(y_fit, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                (tmp / (1.0 + tmp)), 
                                "assigning variable y_fit");
                    current_statement_begin__ = 456;
                    stan::model::assign(y_rep, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                binomial_rng(get_base1(u, t, "u", 1), get_base1(y_fit, t, "y_fit", 1), base_rng__), 
                                "assigning variable y_rep");
                    }
                }
            }
            }
            }

            // validate, write generated quantities
            current_statement_begin__ = 361;
            size_t beta_rw_j_2_max__ = n;
            size_t beta_rw_j_1_max__ = k;
            for (size_t j_2__ = 0; j_2__ < beta_rw_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < beta_rw_j_1_max__; ++j_1__) {
                    vars__.push_back(beta_rw(j_1__, j_2__));
                }
            }

            current_statement_begin__ = 362;
            size_t slope_j_2_max__ = n;
            size_t slope_j_1_max__ = k_rw2;
            for (size_t j_2__ = 0; j_2__ < slope_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < slope_j_1_max__; ++j_1__) {
                    vars__.push_back(slope(j_1__, j_2__));
                }
            }

            current_statement_begin__ = 363;
            vars__.push_back(weights);

            current_statement_begin__ = 364;
            size_t y_fit_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y_fit_j_1_max__; ++j_1__) {
                vars__.push_back(y_fit(j_1__));
            }

            current_statement_begin__ = 365;
            size_t y_rep_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y_rep_j_1_max__; ++j_1__) {
                vars__.push_back(y_rep(j_1__));
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_walker_glm";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t beta_fixed_j_1_max__ = k_fixed;
        for (size_t j_1__ = 0; j_1__ < beta_fixed_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_fixed" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_rw1_k_0_max__ = k_rw1;
        for (size_t k_0__ = 0; k_0__ < sigma_rw1_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_rw1" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_rw2_k_0_max__ = k_rw2;
        for (size_t k_0__ = 0; k_0__ < sigma_rw2_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_rw2" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            size_t Rt_j_2_max__ = n;
            size_t Rt_j_1_max__ = m;
            for (size_t j_2__ = 0; j_2__ < Rt_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Rt_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "Rt" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t xbeta_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < xbeta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "xbeta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t y__j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y__j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t loglik_j_1_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < loglik_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "loglik" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
        size_t beta_rw_j_2_max__ = n;
        size_t beta_rw_j_1_max__ = k;
        for (size_t j_2__ = 0; j_2__ < beta_rw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_rw_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_rw" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t slope_j_2_max__ = n;
        size_t slope_j_1_max__ = k_rw2;
        for (size_t j_2__ = 0; j_2__ < slope_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < slope_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "slope" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "weights";
        param_names__.push_back(param_name_stream__.str());
        size_t y_fit_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < y_fit_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_fit" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t y_rep_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < y_rep_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_rep" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t beta_fixed_j_1_max__ = k_fixed;
        for (size_t j_1__ = 0; j_1__ < beta_fixed_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_fixed" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_rw1_k_0_max__ = k_rw1;
        for (size_t k_0__ = 0; k_0__ < sigma_rw1_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_rw1" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_rw2_k_0_max__ = k_rw2;
        for (size_t k_0__ = 0; k_0__ < sigma_rw2_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_rw2" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            size_t Rt_j_2_max__ = n;
            size_t Rt_j_1_max__ = m;
            for (size_t j_2__ = 0; j_2__ < Rt_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Rt_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "Rt" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t xbeta_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < xbeta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "xbeta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t y__j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y__j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t loglik_j_1_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < loglik_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "loglik" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
        size_t beta_rw_j_2_max__ = n;
        size_t beta_rw_j_1_max__ = k;
        for (size_t j_2__ = 0; j_2__ < beta_rw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_rw_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_rw" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t slope_j_2_max__ = n;
        size_t slope_j_1_max__ = k_rw2;
        for (size_t j_2__ = 0; j_2__ < slope_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < slope_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "slope" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "weights";
        param_names__.push_back(param_name_stream__.str());
        size_t y_fit_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < y_fit_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_fit" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t y_rep_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < y_rep_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_rep" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

}  // namespace




// Code generated by Stan version 2.19.1

#include <stan/model/model_header.hpp>

namespace model_walker_lm_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_walker_lm");
    reader.add_event(393, 391, "end", "model_walker_lm");
    return reader;
}

template <typename T0__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T8__>
typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__, T8__>::type>::type
gaussian_filter(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                    const std::vector<int>& y_miss,
                    const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& a1,
                    const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& P1,
                    const T4__& Ht,
                    const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& Tt,
                    const Eigen::Matrix<T6__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                    const Eigen::Matrix<T7__, Eigen::Dynamic, Eigen::Dynamic>& xreg,
                    const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& gamma2_y, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__, T8__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 10;
        int k(0);
        (void) k;  // dummy to suppress unused var warning
        stan::math::fill(k, std::numeric_limits<int>::min());
        stan::math::assign(k,rows(xreg));

        current_statement_begin__ = 11;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,rows(y));

        current_statement_begin__ = 12;
        int m(0);
        (void) m;  // dummy to suppress unused var warning
        stan::math::fill(m, std::numeric_limits<int>::min());
        stan::math::assign(m,rows(a1));

        current_statement_begin__ = 13;
        local_scalar_t__ loglik(DUMMY_VAR__);
        (void) loglik;  // dummy to suppress unused var warning
        stan::math::initialize(loglik, DUMMY_VAR__);
        stan::math::fill(loglik, DUMMY_VAR__);
        stan::math::assign(loglik,0.0);

        current_statement_begin__ = 15;
        validate_non_negative_index("x", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> x(m);
        stan::math::initialize(x, DUMMY_VAR__);
        stan::math::fill(x, DUMMY_VAR__);
        stan::math::assign(x,a1);

        current_statement_begin__ = 16;
        validate_non_negative_index("P", "m", m);
        validate_non_negative_index("P", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> P(m, m);
        stan::math::initialize(P, DUMMY_VAR__);
        stan::math::fill(P, DUMMY_VAR__);
        stan::math::assign(P,P1);


        current_statement_begin__ = 18;
        for (int t = 1; t <= n; ++t) {
            {
            current_statement_begin__ = 19;
            local_scalar_t__ F(DUMMY_VAR__);
            (void) F;  // dummy to suppress unused var warning
            stan::math::initialize(F, DUMMY_VAR__);
            stan::math::fill(F, DUMMY_VAR__);
            stan::math::assign(F,(quad_form(stan::model::rvalue(P, stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::nil_index_list())), "P"), stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")) + (get_base1(gamma2_y, t, "gamma2_y", 1) * Ht)));


            current_statement_begin__ = 21;
            if (as_bool((primitive_value(logical_eq(get_base1(y_miss, t, "y_miss", 1), 0)) && primitive_value(logical_gt(F, 1.0e-12))))) {
                {
                current_statement_begin__ = 22;
                local_scalar_t__ v(DUMMY_VAR__);
                (void) v;  // dummy to suppress unused var warning
                stan::math::initialize(v, DUMMY_VAR__);
                stan::math::fill(v, DUMMY_VAR__);
                stan::math::assign(v,(get_base1(y, t, "y", 1) - dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), head(x, k))));

                current_statement_begin__ = 23;
                validate_non_negative_index("K", "m", m);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> K(m);
                stan::math::initialize(K, DUMMY_VAR__);
                stan::math::fill(K, DUMMY_VAR__);
                stan::math::assign(K,divide(multiply(stan::model::rvalue(P, stan::model::cons_list(stan::model::index_min_max(1, m), stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::nil_index_list())), "P"), stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")), F));


                current_statement_begin__ = 24;
                stan::math::assign(x, multiply(Tt, add(x, multiply(K, v))));
                current_statement_begin__ = 25;
                stan::math::assign(P, quad_form_sym(subtract(P, multiply(multiply(K, transpose(K)), F)), transpose(Tt)));
                current_statement_begin__ = 26;
                for (int i = 1; i <= m; ++i) {

                    current_statement_begin__ = 27;
                    stan::model::assign(P, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                (stan::model::rvalue(P, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "P") + get_base1(Rt, i, t, "Rt", 1)), 
                                "assigning variable P");
                }
                current_statement_begin__ = 29;
                stan::math::assign(loglik, (loglik - (0.5 * (stan::math::log(F) + ((v * v) / F)))));
                }
            } else {

                current_statement_begin__ = 31;
                stan::math::assign(x, multiply(Tt, x));
                current_statement_begin__ = 32;
                stan::math::assign(P, quad_form_sym(P, transpose(Tt)));
                current_statement_begin__ = 33;
                for (int i = 1; i <= m; ++i) {

                    current_statement_begin__ = 34;
                    stan::model::assign(P, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                (stan::model::rvalue(P, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "P") + get_base1(Rt, i, t, "Rt", 1)), 
                                "assigning variable P");
                }
            }
            }
        }
        current_statement_begin__ = 38;
        return stan::math::promote_scalar<fun_return_scalar_t__>(loglik);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct gaussian_filter_functor__ {
    template <typename T0__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T8__>
        typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__, T8__>::type>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                    const std::vector<int>& y_miss,
                    const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& a1,
                    const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& P1,
                    const T4__& Ht,
                    const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& Tt,
                    const Eigen::Matrix<T6__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                    const Eigen::Matrix<T7__, Eigen::Dynamic, Eigen::Dynamic>& xreg,
                    const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& gamma2_y, std::ostream* pstream__) const {
        return gaussian_filter(y, y_miss, a1, P1, Ht, Tt, Rt, xreg, gamma2_y, pstream__);
    }
};

template <typename T0__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T8__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__, T8__>::type>::type, Eigen::Dynamic, Eigen::Dynamic>
gaussian_smoother(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                      const std::vector<int>& y_miss,
                      const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& a1,
                      const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& P1,
                      const T4__& Ht,
                      const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& Tt,
                      const Eigen::Matrix<T6__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                      const Eigen::Matrix<T7__, Eigen::Dynamic, Eigen::Dynamic>& xreg,
                      const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& gamma2_y, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__, T8__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 45;
        int k(0);
        (void) k;  // dummy to suppress unused var warning
        stan::math::fill(k, std::numeric_limits<int>::min());
        stan::math::assign(k,rows(xreg));

        current_statement_begin__ = 46;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,rows(y));

        current_statement_begin__ = 47;
        int m(0);
        (void) m;  // dummy to suppress unused var warning
        stan::math::fill(m, std::numeric_limits<int>::min());
        stan::math::assign(m,rows(a1));

        current_statement_begin__ = 48;
        local_scalar_t__ loglik(DUMMY_VAR__);
        (void) loglik;  // dummy to suppress unused var warning
        stan::math::initialize(loglik, DUMMY_VAR__);
        stan::math::fill(loglik, DUMMY_VAR__);
        stan::math::assign(loglik,0.0);

        current_statement_begin__ = 49;
        validate_non_negative_index("x", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> x(m);
        stan::math::initialize(x, DUMMY_VAR__);
        stan::math::fill(x, DUMMY_VAR__);
        stan::math::assign(x,a1);

        current_statement_begin__ = 50;
        validate_non_negative_index("P", "m", m);
        validate_non_negative_index("P", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> P(m, m);
        stan::math::initialize(P, DUMMY_VAR__);
        stan::math::fill(P, DUMMY_VAR__);
        stan::math::assign(P,P1);

        current_statement_begin__ = 51;
        validate_non_negative_index("v", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> v(n);
        stan::math::initialize(v, DUMMY_VAR__);
        stan::math::fill(v, DUMMY_VAR__);

        current_statement_begin__ = 52;
        validate_non_negative_index("F", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> F(n);
        stan::math::initialize(F, DUMMY_VAR__);
        stan::math::fill(F, DUMMY_VAR__);

        current_statement_begin__ = 53;
        validate_non_negative_index("K", "m", m);
        validate_non_negative_index("K", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> K(m, n);
        stan::math::initialize(K, DUMMY_VAR__);
        stan::math::fill(K, DUMMY_VAR__);

        current_statement_begin__ = 54;
        validate_non_negative_index("r", "m", m);
        validate_non_negative_index("r", "(n + 1)", (n + 1));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> r(m, (n + 1));
        stan::math::initialize(r, DUMMY_VAR__);
        stan::math::fill(r, DUMMY_VAR__);

        current_statement_begin__ = 55;
        validate_non_negative_index("tmpr", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmpr(m);
        stan::math::initialize(tmpr, DUMMY_VAR__);
        stan::math::fill(tmpr, DUMMY_VAR__);


        current_statement_begin__ = 57;
        for (int t = 1; t <= n; ++t) {

            current_statement_begin__ = 59;
            stan::model::assign(F, 
                        stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                        (quad_form(stan::model::rvalue(P, stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::nil_index_list())), "P"), stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")) + (get_base1(gamma2_y, t, "gamma2_y", 1) * Ht)), 
                        "assigning variable F");
            current_statement_begin__ = 61;
            if (as_bool((primitive_value(logical_eq(get_base1(y_miss, t, "y_miss", 1), 0)) && primitive_value(logical_gt(get_base1(F, t, "F", 1), 1.0e-12))))) {

                current_statement_begin__ = 62;
                stan::model::assign(v, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            (get_base1(y, t, "y", 1) - dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), head(x, k))), 
                            "assigning variable v");
                current_statement_begin__ = 63;
                stan::model::assign(K, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                            divide(multiply(stan::model::rvalue(P, stan::model::cons_list(stan::model::index_min_max(1, m), stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::nil_index_list())), "P"), stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")), get_base1(F, t, "F", 1)), 
                            "assigning variable K");
                current_statement_begin__ = 64;
                stan::math::assign(x, multiply(Tt, add(x, multiply(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"), get_base1(v, t, "v", 1)))));
                current_statement_begin__ = 65;
                stan::math::assign(P, quad_form_sym(subtract(P, multiply(multiply(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"), transpose(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"))), get_base1(F, t, "F", 1))), transpose(Tt)));
                current_statement_begin__ = 66;
                for (int i = 1; i <= m; ++i) {

                    current_statement_begin__ = 67;
                    stan::model::assign(P, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                (stan::model::rvalue(P, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "P") + get_base1(Rt, i, t, "Rt", 1)), 
                                "assigning variable P");
                }
                current_statement_begin__ = 69;
                stan::math::assign(loglik, (loglik - (0.5 * (stan::math::log(get_base1(F, t, "F", 1)) + ((get_base1(v, t, "v", 1) * get_base1(v, t, "v", 1)) / get_base1(F, t, "F", 1))))));
            } else {

                current_statement_begin__ = 71;
                stan::math::assign(x, multiply(Tt, x));
                current_statement_begin__ = 72;
                stan::math::assign(P, quad_form_sym(P, transpose(Tt)));
                current_statement_begin__ = 73;
                for (int i = 1; i <= m; ++i) {

                    current_statement_begin__ = 74;
                    stan::model::assign(P, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                (stan::model::rvalue(P, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "P") + get_base1(Rt, i, t, "Rt", 1)), 
                                "assigning variable P");
                }
            }
        }
        current_statement_begin__ = 79;
        stan::model::assign(r, 
                    stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((n + 1)), stan::model::nil_index_list())), 
                    rep_vector(0.0, m), 
                    "assigning variable r");
        current_statement_begin__ = 80;
        for (int tt = 1; tt <= n; ++tt) {
            {
            current_statement_begin__ = 81;
            int t(0);
            (void) t;  // dummy to suppress unused var warning
            stan::math::fill(t, std::numeric_limits<int>::min());
            stan::math::assign(t,((n + 1) - tt));

            current_statement_begin__ = 82;
            validate_non_negative_index("tmp", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp(m);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            stan::math::assign(tmp,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), "r"));


            current_statement_begin__ = 83;
            if (as_bool((primitive_value(logical_eq(get_base1(y_miss, t, "y_miss", 1), 0)) && primitive_value(logical_gt(get_base1(F, t, "F", 1), 1.0e-12))))) {
                {
                current_statement_begin__ = 84;
                validate_non_negative_index("tmp2", "m", m);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp2(m);
                stan::math::initialize(tmp2, DUMMY_VAR__);
                stan::math::fill(tmp2, DUMMY_VAR__);
                stan::math::assign(tmp2,rep_vector(0.0, m));


                current_statement_begin__ = 85;
                stan::model::assign(tmp2, 
                            stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::nil_index_list()), 
                            stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), 
                            "assigning variable tmp2");
                current_statement_begin__ = 86;
                stan::model::assign(r, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                            add(divide(multiply(tmp2, get_base1(v, t, "v", 1)), get_base1(F, t, "F", 1)), multiply(transpose(subtract(Tt, multiply(multiply(Tt, stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K")), transpose(tmp2)))), tmp)), 
                            "assigning variable r");
                }
            } else {

                current_statement_begin__ = 88;
                stan::model::assign(r, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                            multiply(transpose(Tt), tmp), 
                            "assigning variable r");
            }
            }
        }
        current_statement_begin__ = 92;
        stan::math::assign(tmpr, stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "r"));
        current_statement_begin__ = 93;
        stan::model::assign(r, 
                    stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    add(a1, multiply(P1, tmpr)), 
                    "assigning variable r");
        current_statement_begin__ = 94;
        for (int t = 2; t <= n; ++t) {
            {
            current_statement_begin__ = 95;
            validate_non_negative_index("tmp", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp(m);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            stan::math::assign(tmp,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::nil_index_list())), "r"));

            current_statement_begin__ = 96;
            validate_non_negative_index("tmp2", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp2(m);
            stan::math::initialize(tmp2, DUMMY_VAR__);
            stan::math::fill(tmp2, DUMMY_VAR__);
            stan::math::assign(tmp2,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "r"));


            current_statement_begin__ = 97;
            stan::model::assign(r, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                        add(multiply(Tt, tmp), elt_multiply(stan::model::rvalue(Rt, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "Rt"), tmp2)), 
                        "assigning variable r");
            }
        }
        current_statement_begin__ = 99;
        return stan::math::promote_scalar<fun_return_scalar_t__>(stan::model::rvalue(r, stan::model::cons_list(stan::model::index_min_max(1, m), stan::model::cons_list(stan::model::index_min_max(1, n), stan::model::nil_index_list())), "r"));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct gaussian_smoother_functor__ {
    template <typename T0__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T8__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__, T8__>::type>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                      const std::vector<int>& y_miss,
                      const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& a1,
                      const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& P1,
                      const T4__& Ht,
                      const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& Tt,
                      const Eigen::Matrix<T6__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                      const Eigen::Matrix<T7__, Eigen::Dynamic, Eigen::Dynamic>& xreg,
                      const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& gamma2_y, std::ostream* pstream__) const {
        return gaussian_smoother(y, y_miss, a1, P1, Ht, Tt, Rt, xreg, gamma2_y, pstream__);
    }
};

template <typename T0__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T10__, typename T11__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__, T10__, typename boost::math::tools::promote_args<T11__>::type>::type>::type, Eigen::Dynamic, 1>
glm_approx_loglik(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                      const std::vector<int>& y_miss,
                      const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& a1,
                      const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& P1,
                      const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& Ht,
                      const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& Tt,
                      const Eigen::Matrix<T6__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                      const Eigen::Matrix<T7__, Eigen::Dynamic, Eigen::Dynamic>& xreg,
                      const int& distribution,
                      const std::vector<int>& u,
                      const Eigen::Matrix<T10__, Eigen::Dynamic, 1>& y_original,
                      const Eigen::Matrix<T11__, Eigen::Dynamic, 1>& xbeta_fixed, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__, T10__, typename boost::math::tools::promote_args<T11__>::type>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 111;
        int k(0);
        (void) k;  // dummy to suppress unused var warning
        stan::math::fill(k, std::numeric_limits<int>::min());
        stan::math::assign(k,rows(xreg));

        current_statement_begin__ = 112;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,rows(y));

        current_statement_begin__ = 113;
        int m(0);
        (void) m;  // dummy to suppress unused var warning
        stan::math::fill(m, std::numeric_limits<int>::min());
        stan::math::assign(m,rows(a1));

        current_statement_begin__ = 114;
        validate_non_negative_index("loglik", "2", 2);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> loglik(2);
        stan::math::initialize(loglik, DUMMY_VAR__);
        stan::math::fill(loglik, DUMMY_VAR__);
        stan::math::assign(loglik,rep_vector(0.0, 2));

        current_statement_begin__ = 115;
        validate_non_negative_index("x", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> x(m);
        stan::math::initialize(x, DUMMY_VAR__);
        stan::math::fill(x, DUMMY_VAR__);
        stan::math::assign(x,a1);

        current_statement_begin__ = 116;
        validate_non_negative_index("P", "m", m);
        validate_non_negative_index("P", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> P(m, m);
        stan::math::initialize(P, DUMMY_VAR__);
        stan::math::fill(P, DUMMY_VAR__);
        stan::math::assign(P,P1);

        current_statement_begin__ = 117;
        validate_non_negative_index("v", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> v(n);
        stan::math::initialize(v, DUMMY_VAR__);
        stan::math::fill(v, DUMMY_VAR__);

        current_statement_begin__ = 118;
        validate_non_negative_index("F", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> F(n);
        stan::math::initialize(F, DUMMY_VAR__);
        stan::math::fill(F, DUMMY_VAR__);

        current_statement_begin__ = 119;
        validate_non_negative_index("K", "m", m);
        validate_non_negative_index("K", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> K(m, n);
        stan::math::initialize(K, DUMMY_VAR__);
        stan::math::fill(K, DUMMY_VAR__);

        current_statement_begin__ = 120;
        validate_non_negative_index("r", "m", m);
        validate_non_negative_index("r", "(n + 1)", (n + 1));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> r(m, (n + 1));
        stan::math::initialize(r, DUMMY_VAR__);
        stan::math::fill(r, DUMMY_VAR__);

        current_statement_begin__ = 121;
        validate_non_negative_index("tmpr", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmpr(m);
        stan::math::initialize(tmpr, DUMMY_VAR__);
        stan::math::fill(tmpr, DUMMY_VAR__);


        current_statement_begin__ = 123;
        for (int t = 1; t <= n; ++t) {

            current_statement_begin__ = 125;
            stan::model::assign(F, 
                        stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                        (quad_form(stan::model::rvalue(P, stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::nil_index_list())), "P"), stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")) + get_base1(Ht, t, "Ht", 1)), 
                        "assigning variable F");
            current_statement_begin__ = 127;
            if (as_bool((primitive_value(logical_eq(get_base1(y_miss, t, "y_miss", 1), 0)) && primitive_value(logical_gt(get_base1(F, t, "F", 1), 1.0e-12))))) {

                current_statement_begin__ = 128;
                stan::model::assign(v, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            (get_base1(y, t, "y", 1) - dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), head(x, k))), 
                            "assigning variable v");
                current_statement_begin__ = 129;
                stan::model::assign(K, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                            divide(multiply(stan::model::rvalue(P, stan::model::cons_list(stan::model::index_min_max(1, m), stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::nil_index_list())), "P"), stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")), get_base1(F, t, "F", 1)), 
                            "assigning variable K");
                current_statement_begin__ = 130;
                stan::math::assign(x, multiply(Tt, add(x, multiply(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"), get_base1(v, t, "v", 1)))));
                current_statement_begin__ = 131;
                stan::math::assign(P, quad_form_sym(subtract(P, multiply(multiply(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"), transpose(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"))), get_base1(F, t, "F", 1))), transpose(Tt)));
                current_statement_begin__ = 132;
                for (int i = 1; i <= m; ++i) {

                    current_statement_begin__ = 133;
                    stan::model::assign(P, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                (stan::model::rvalue(P, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "P") + get_base1(Rt, i, t, "Rt", 1)), 
                                "assigning variable P");
                }
                current_statement_begin__ = 135;
                stan::model::assign(loglik, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            (stan::model::rvalue(loglik, stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), "loglik") - (0.5 * (stan::math::log(get_base1(F, t, "F", 1)) + ((get_base1(v, t, "v", 1) * get_base1(v, t, "v", 1)) / get_base1(F, t, "F", 1))))), 
                            "assigning variable loglik");
            } else {

                current_statement_begin__ = 137;
                stan::math::assign(x, multiply(Tt, x));
                current_statement_begin__ = 138;
                stan::math::assign(P, quad_form_sym(P, transpose(Tt)));
                current_statement_begin__ = 139;
                for (int i = 1; i <= m; ++i) {

                    current_statement_begin__ = 140;
                    stan::model::assign(P, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                (stan::model::rvalue(P, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "P") + get_base1(Rt, i, t, "Rt", 1)), 
                                "assigning variable P");
                }
            }
        }
        current_statement_begin__ = 145;
        stan::model::assign(r, 
                    stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((n + 1)), stan::model::nil_index_list())), 
                    rep_vector(0.0, m), 
                    "assigning variable r");
        current_statement_begin__ = 146;
        for (int tt = 1; tt <= n; ++tt) {
            {
            current_statement_begin__ = 147;
            int t(0);
            (void) t;  // dummy to suppress unused var warning
            stan::math::fill(t, std::numeric_limits<int>::min());
            stan::math::assign(t,((n + 1) - tt));

            current_statement_begin__ = 148;
            validate_non_negative_index("tmp", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp(m);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            stan::math::assign(tmp,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), "r"));


            current_statement_begin__ = 149;
            if (as_bool((primitive_value(logical_eq(get_base1(y_miss, t, "y_miss", 1), 0)) && primitive_value(logical_gt(get_base1(F, t, "F", 1), 1.0e-12))))) {
                {
                current_statement_begin__ = 150;
                validate_non_negative_index("tmp2", "m", m);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp2(m);
                stan::math::initialize(tmp2, DUMMY_VAR__);
                stan::math::fill(tmp2, DUMMY_VAR__);
                stan::math::assign(tmp2,rep_vector(0.0, m));


                current_statement_begin__ = 151;
                stan::model::assign(tmp2, 
                            stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::nil_index_list()), 
                            stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), 
                            "assigning variable tmp2");
                current_statement_begin__ = 152;
                stan::model::assign(r, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                            add(divide(multiply(tmp2, get_base1(v, t, "v", 1)), get_base1(F, t, "F", 1)), multiply(transpose(subtract(Tt, multiply(multiply(Tt, stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K")), transpose(tmp2)))), tmp)), 
                            "assigning variable r");
                }
            } else {

                current_statement_begin__ = 154;
                stan::model::assign(r, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                            multiply(transpose(Tt), tmp), 
                            "assigning variable r");
            }
            }
        }
        current_statement_begin__ = 158;
        stan::math::assign(tmpr, stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "r"));
        current_statement_begin__ = 159;
        stan::model::assign(r, 
                    stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    add(a1, multiply(P1, tmpr)), 
                    "assigning variable r");
        current_statement_begin__ = 160;
        for (int t = 2; t <= n; ++t) {
            {
            current_statement_begin__ = 161;
            validate_non_negative_index("tmp", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp(m);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            stan::math::assign(tmp,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::nil_index_list())), "r"));

            current_statement_begin__ = 162;
            validate_non_negative_index("tmp2", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp2(m);
            stan::math::initialize(tmp2, DUMMY_VAR__);
            stan::math::fill(tmp2, DUMMY_VAR__);
            stan::math::assign(tmp2,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "r"));


            current_statement_begin__ = 163;
            stan::model::assign(r, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                        add(multiply(Tt, tmp), elt_multiply(stan::model::rvalue(Rt, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "Rt"), tmp2)), 
                        "assigning variable r");
            }
        }
        current_statement_begin__ = 167;
        if (as_bool(logical_eq(distribution, 1))) {

            current_statement_begin__ = 168;
            for (int t = 1; t <= n; ++t) {

                current_statement_begin__ = 169;
                if (as_bool(logical_eq(get_base1(y_miss, t, "y_miss", 1), 0))) {
                    {
                    current_statement_begin__ = 170;
                    local_scalar_t__ xbeta_rw(DUMMY_VAR__);
                    (void) xbeta_rw;  // dummy to suppress unused var warning
                    stan::math::initialize(xbeta_rw, DUMMY_VAR__);
                    stan::math::fill(xbeta_rw, DUMMY_VAR__);
                    stan::math::assign(xbeta_rw,dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), stan::model::rvalue(r, stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "r")));


                    current_statement_begin__ = 171;
                    stan::model::assign(loglik, 
                                stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                                (stan::model::rvalue(loglik, stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), "loglik") + (((get_base1(y_original, t, "y_original", 1) * (xbeta_rw + get_base1(xbeta_fixed, t, "xbeta_fixed", 1))) - (get_base1(u, t, "u", 1) * stan::math::exp((xbeta_rw + get_base1(xbeta_fixed, t, "xbeta_fixed", 1))))) + ((0.5 * pow((get_base1(y, t, "y", 1) - xbeta_rw), 2)) / get_base1(Ht, t, "Ht", 1)))), 
                                "assigning variable loglik");
                    }
                }
            }
        } else {

            current_statement_begin__ = 177;
            for (int t = 1; t <= n; ++t) {

                current_statement_begin__ = 178;
                if (as_bool(logical_eq(get_base1(y_miss, t, "y_miss", 1), 0))) {
                    {
                    current_statement_begin__ = 179;
                    local_scalar_t__ xbeta_rw(DUMMY_VAR__);
                    (void) xbeta_rw;  // dummy to suppress unused var warning
                    stan::math::initialize(xbeta_rw, DUMMY_VAR__);
                    stan::math::fill(xbeta_rw, DUMMY_VAR__);
                    stan::math::assign(xbeta_rw,dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), stan::model::rvalue(r, stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "r")));


                    current_statement_begin__ = 180;
                    stan::model::assign(loglik, 
                                stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                                (stan::model::rvalue(loglik, stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), "loglik") + (((get_base1(y_original, t, "y_original", 1) * (xbeta_rw + get_base1(xbeta_fixed, t, "xbeta_fixed", 1))) - (get_base1(u, t, "u", 1) * stan::math::log1p(stan::math::exp((xbeta_rw + get_base1(xbeta_fixed, t, "xbeta_fixed", 1)))))) + ((0.5 * pow((get_base1(y, t, "y", 1) - xbeta_rw), 2)) / get_base1(Ht, t, "Ht", 1)))), 
                                "assigning variable loglik");
                    }
                }
            }
        }
        current_statement_begin__ = 186;
        return stan::math::promote_scalar<fun_return_scalar_t__>(loglik);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct glm_approx_loglik_functor__ {
    template <typename T0__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T10__, typename T11__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__, T10__, typename boost::math::tools::promote_args<T11__>::type>::type>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                      const std::vector<int>& y_miss,
                      const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& a1,
                      const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& P1,
                      const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& Ht,
                      const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& Tt,
                      const Eigen::Matrix<T6__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                      const Eigen::Matrix<T7__, Eigen::Dynamic, Eigen::Dynamic>& xreg,
                      const int& distribution,
                      const std::vector<int>& u,
                      const Eigen::Matrix<T10__, Eigen::Dynamic, 1>& y_original,
                      const Eigen::Matrix<T11__, Eigen::Dynamic, 1>& xbeta_fixed, std::ostream* pstream__) const {
        return glm_approx_loglik(y, y_miss, a1, P1, Ht, Tt, Rt, xreg, distribution, u, y_original, xbeta_fixed, pstream__);
    }
};

template <typename T0__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__>::type>::type, Eigen::Dynamic, Eigen::Dynamic>
glm_approx_smoother(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                        const std::vector<int>& y_miss,
                        const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& a1,
                        const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& P1,
                        const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& Ht,
                        const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& Tt,
                        const Eigen::Matrix<T6__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                        const Eigen::Matrix<T7__, Eigen::Dynamic, Eigen::Dynamic>& xreg, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 196;
        int k(0);
        (void) k;  // dummy to suppress unused var warning
        stan::math::fill(k, std::numeric_limits<int>::min());
        stan::math::assign(k,rows(xreg));

        current_statement_begin__ = 197;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,rows(y));

        current_statement_begin__ = 198;
        int m(0);
        (void) m;  // dummy to suppress unused var warning
        stan::math::fill(m, std::numeric_limits<int>::min());
        stan::math::assign(m,rows(a1));

        current_statement_begin__ = 199;
        validate_non_negative_index("x", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> x(m);
        stan::math::initialize(x, DUMMY_VAR__);
        stan::math::fill(x, DUMMY_VAR__);
        stan::math::assign(x,a1);

        current_statement_begin__ = 200;
        validate_non_negative_index("P", "m", m);
        validate_non_negative_index("P", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> P(m, m);
        stan::math::initialize(P, DUMMY_VAR__);
        stan::math::fill(P, DUMMY_VAR__);
        stan::math::assign(P,P1);

        current_statement_begin__ = 201;
        validate_non_negative_index("v", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> v(n);
        stan::math::initialize(v, DUMMY_VAR__);
        stan::math::fill(v, DUMMY_VAR__);

        current_statement_begin__ = 202;
        validate_non_negative_index("F", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> F(n);
        stan::math::initialize(F, DUMMY_VAR__);
        stan::math::fill(F, DUMMY_VAR__);

        current_statement_begin__ = 203;
        validate_non_negative_index("K", "m", m);
        validate_non_negative_index("K", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> K(m, n);
        stan::math::initialize(K, DUMMY_VAR__);
        stan::math::fill(K, DUMMY_VAR__);

        current_statement_begin__ = 204;
        validate_non_negative_index("r", "m", m);
        validate_non_negative_index("r", "(n + 1)", (n + 1));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> r(m, (n + 1));
        stan::math::initialize(r, DUMMY_VAR__);
        stan::math::fill(r, DUMMY_VAR__);

        current_statement_begin__ = 205;
        validate_non_negative_index("tmpr", "m", m);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmpr(m);
        stan::math::initialize(tmpr, DUMMY_VAR__);
        stan::math::fill(tmpr, DUMMY_VAR__);


        current_statement_begin__ = 207;
        for (int t = 1; t <= n; ++t) {

            current_statement_begin__ = 209;
            stan::model::assign(F, 
                        stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                        (quad_form(stan::model::rvalue(P, stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::nil_index_list())), "P"), stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")) + get_base1(Ht, t, "Ht", 1)), 
                        "assigning variable F");
            current_statement_begin__ = 211;
            if (as_bool((primitive_value(logical_eq(get_base1(y_miss, t, "y_miss", 1), 0)) && primitive_value(logical_gt(get_base1(F, t, "F", 1), 1.0e-12))))) {

                current_statement_begin__ = 212;
                stan::model::assign(v, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            (get_base1(y, t, "y", 1) - dot_product(stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), head(x, k))), 
                            "assigning variable v");
                current_statement_begin__ = 213;
                stan::model::assign(K, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                            divide(multiply(stan::model::rvalue(P, stan::model::cons_list(stan::model::index_min_max(1, m), stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::nil_index_list())), "P"), stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg")), get_base1(F, t, "F", 1)), 
                            "assigning variable K");
                current_statement_begin__ = 214;
                stan::math::assign(x, multiply(Tt, add(x, multiply(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"), get_base1(v, t, "v", 1)))));
                current_statement_begin__ = 215;
                stan::math::assign(P, quad_form_sym(subtract(P, multiply(multiply(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"), transpose(stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K"))), get_base1(F, t, "F", 1))), transpose(Tt)));
                current_statement_begin__ = 216;
                for (int i = 1; i <= m; ++i) {

                    current_statement_begin__ = 217;
                    stan::model::assign(P, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                (stan::model::rvalue(P, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "P") + get_base1(Rt, i, t, "Rt", 1)), 
                                "assigning variable P");
                }
            } else {

                current_statement_begin__ = 220;
                stan::math::assign(x, multiply(Tt, x));
                current_statement_begin__ = 221;
                stan::math::assign(P, quad_form_sym(P, transpose(Tt)));
                current_statement_begin__ = 222;
                for (int i = 1; i <= m; ++i) {

                    current_statement_begin__ = 223;
                    stan::model::assign(P, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                (stan::model::rvalue(P, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "P") + get_base1(Rt, i, t, "Rt", 1)), 
                                "assigning variable P");
                }
            }
        }
        current_statement_begin__ = 228;
        stan::model::assign(r, 
                    stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((n + 1)), stan::model::nil_index_list())), 
                    rep_vector(0.0, m), 
                    "assigning variable r");
        current_statement_begin__ = 229;
        for (int tt = 1; tt <= n; ++tt) {
            {
            current_statement_begin__ = 230;
            int t(0);
            (void) t;  // dummy to suppress unused var warning
            stan::math::fill(t, std::numeric_limits<int>::min());
            stan::math::assign(t,((n + 1) - tt));

            current_statement_begin__ = 231;
            validate_non_negative_index("tmp", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp(m);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            stan::math::assign(tmp,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), "r"));


            current_statement_begin__ = 232;
            if (as_bool((primitive_value(logical_eq(get_base1(y_miss, t, "y_miss", 1), 0)) && primitive_value(logical_gt(get_base1(F, t, "F", 1), 1.0e-12))))) {
                {
                current_statement_begin__ = 233;
                validate_non_negative_index("tmp2", "m", m);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp2(m);
                stan::math::initialize(tmp2, DUMMY_VAR__);
                stan::math::fill(tmp2, DUMMY_VAR__);
                stan::math::assign(tmp2,rep_vector(0.0, m));


                current_statement_begin__ = 234;
                stan::model::assign(tmp2, 
                            stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::nil_index_list()), 
                            stan::model::rvalue(xreg, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg"), 
                            "assigning variable tmp2");
                current_statement_begin__ = 235;
                stan::model::assign(r, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                            add(divide(multiply(tmp2, get_base1(v, t, "v", 1)), get_base1(F, t, "F", 1)), multiply(transpose(subtract(Tt, multiply(multiply(Tt, stan::model::rvalue(K, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "K")), transpose(tmp2)))), tmp)), 
                            "assigning variable r");
                }
            } else {

                current_statement_begin__ = 237;
                stan::model::assign(r, 
                            stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                            multiply(transpose(Tt), tmp), 
                            "assigning variable r");
            }
            }
        }
        current_statement_begin__ = 241;
        stan::math::assign(tmpr, stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "r"));
        current_statement_begin__ = 242;
        stan::model::assign(r, 
                    stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    add(a1, multiply(P1, tmpr)), 
                    "assigning variable r");
        current_statement_begin__ = 243;
        for (int t = 2; t <= n; ++t) {
            {
            current_statement_begin__ = 244;
            validate_non_negative_index("tmp", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp(m);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            stan::math::assign(tmp,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::nil_index_list())), "r"));

            current_statement_begin__ = 245;
            validate_non_negative_index("tmp2", "m", m);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tmp2(m);
            stan::math::initialize(tmp2, DUMMY_VAR__);
            stan::math::fill(tmp2, DUMMY_VAR__);
            stan::math::assign(tmp2,stan::model::rvalue(r, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "r"));


            current_statement_begin__ = 246;
            stan::model::assign(r, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                        add(multiply(Tt, tmp), elt_multiply(stan::model::rvalue(Rt, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "Rt"), tmp2)), 
                        "assigning variable r");
            }
        }
        current_statement_begin__ = 249;
        return stan::math::promote_scalar<fun_return_scalar_t__>(stan::model::rvalue(r, stan::model::cons_list(stan::model::index_min_max(1, m), stan::model::cons_list(stan::model::index_min_max(1, n), stan::model::nil_index_list())), "r"));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct glm_approx_smoother_functor__ {
    template <typename T0__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__, typename T7__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, typename boost::math::tools::promote_args<T5__, T6__, T7__>::type>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                        const std::vector<int>& y_miss,
                        const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& a1,
                        const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& P1,
                        const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& Ht,
                        const Eigen::Matrix<T5__, Eigen::Dynamic, Eigen::Dynamic>& Tt,
                        const Eigen::Matrix<T6__, Eigen::Dynamic, Eigen::Dynamic>& Rt,
                        const Eigen::Matrix<T7__, Eigen::Dynamic, Eigen::Dynamic>& xreg, std::ostream* pstream__) const {
        return glm_approx_smoother(y, y_miss, a1, P1, Ht, Tt, Rt, xreg, pstream__);
    }
};

class model_walker_lm : public prob_grad {
private:
        int k_fixed;
        int k_rw1;
        int k_rw2;
        int m;
        int k;
        int n;
        matrix_d xreg_fixed;
        matrix_d xreg_rw;
        vector_d y;
        std::vector<int> y_miss;
        double sigma_y_mean;
        double sigma_y_sd;
        double beta_fixed_mean;
        double beta_rw1_mean;
        double beta_rw2_mean;
        double beta_fixed_sd;
        double beta_rw1_sd;
        double beta_rw2_sd;
        double sigma_rw1_mean;
        double sigma_rw2_mean;
        double sigma_rw1_sd;
        double sigma_rw2_sd;
        double slope_mean;
        double slope_sd;
        vector_d gamma_y;
        matrix_d gamma_rw1;
        matrix_d gamma_rw2;
        vector_d a1;
        matrix_d P1;
        matrix_d Tt;
        vector_d gamma2_y;
public:
    model_walker_lm(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_walker_lm(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_walker_lm_namespace::model_walker_lm";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            // initialize data block variables from context__
            current_statement_begin__ = 255;
            context__.validate_dims("data initialization", "k_fixed", "int", context__.to_vec());
            k_fixed = int(0);
            vals_i__ = context__.vals_i("k_fixed");
            pos__ = 0;
            k_fixed = vals_i__[pos__++];
            check_greater_or_equal(function__, "k_fixed", k_fixed, 0);

            current_statement_begin__ = 256;
            context__.validate_dims("data initialization", "k_rw1", "int", context__.to_vec());
            k_rw1 = int(0);
            vals_i__ = context__.vals_i("k_rw1");
            pos__ = 0;
            k_rw1 = vals_i__[pos__++];
            check_greater_or_equal(function__, "k_rw1", k_rw1, 0);

            current_statement_begin__ = 257;
            context__.validate_dims("data initialization", "k_rw2", "int", context__.to_vec());
            k_rw2 = int(0);
            vals_i__ = context__.vals_i("k_rw2");
            pos__ = 0;
            k_rw2 = vals_i__[pos__++];
            check_greater_or_equal(function__, "k_rw2", k_rw2, 0);

            current_statement_begin__ = 258;
            context__.validate_dims("data initialization", "m", "int", context__.to_vec());
            m = int(0);
            vals_i__ = context__.vals_i("m");
            pos__ = 0;
            m = vals_i__[pos__++];
            check_greater_or_equal(function__, "m", m, 0);

            current_statement_begin__ = 259;
            context__.validate_dims("data initialization", "k", "int", context__.to_vec());
            k = int(0);
            vals_i__ = context__.vals_i("k");
            pos__ = 0;
            k = vals_i__[pos__++];
            check_greater_or_equal(function__, "k", k, 0);

            current_statement_begin__ = 260;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            check_greater_or_equal(function__, "n", n, 0);

            current_statement_begin__ = 261;
            validate_non_negative_index("xreg_fixed", "n", n);
            validate_non_negative_index("xreg_fixed", "k_fixed", k_fixed);
            context__.validate_dims("data initialization", "xreg_fixed", "matrix_d", context__.to_vec(n,k_fixed));
            xreg_fixed = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n, k_fixed);
            vals_r__ = context__.vals_r("xreg_fixed");
            pos__ = 0;
            size_t xreg_fixed_j_2_max__ = k_fixed;
            size_t xreg_fixed_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < xreg_fixed_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < xreg_fixed_j_1_max__; ++j_1__) {
                    xreg_fixed(j_1__, j_2__) = vals_r__[pos__++];
                }
            }

            current_statement_begin__ = 262;
            validate_non_negative_index("xreg_rw", "k", k);
            validate_non_negative_index("xreg_rw", "n", n);
            context__.validate_dims("data initialization", "xreg_rw", "matrix_d", context__.to_vec(k,n));
            xreg_rw = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(k, n);
            vals_r__ = context__.vals_r("xreg_rw");
            pos__ = 0;
            size_t xreg_rw_j_2_max__ = n;
            size_t xreg_rw_j_1_max__ = k;
            for (size_t j_2__ = 0; j_2__ < xreg_rw_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < xreg_rw_j_1_max__; ++j_1__) {
                    xreg_rw(j_1__, j_2__) = vals_r__[pos__++];
                }
            }

            current_statement_begin__ = 263;
            validate_non_negative_index("y", "n", n);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(n));
            y = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                y(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 264;
            validate_non_negative_index("y_miss", "n", n);
            context__.validate_dims("data initialization", "y_miss", "int", context__.to_vec(n));
            y_miss = std::vector<int>(n, int(0));
            vals_i__ = context__.vals_i("y_miss");
            pos__ = 0;
            size_t y_miss_k_0_max__ = n;
            for (size_t k_0__ = 0; k_0__ < y_miss_k_0_max__; ++k_0__) {
                y_miss[k_0__] = vals_i__[pos__++];
            }
            size_t y_miss_i_0_max__ = n;
            for (size_t i_0__ = 0; i_0__ < y_miss_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "y_miss[i_0__]", y_miss[i_0__], 0);
            }

            current_statement_begin__ = 265;
            context__.validate_dims("data initialization", "sigma_y_mean", "double", context__.to_vec());
            sigma_y_mean = double(0);
            vals_r__ = context__.vals_r("sigma_y_mean");
            pos__ = 0;
            sigma_y_mean = vals_r__[pos__++];
            check_greater_or_equal(function__, "sigma_y_mean", sigma_y_mean, 0);

            current_statement_begin__ = 266;
            context__.validate_dims("data initialization", "sigma_y_sd", "double", context__.to_vec());
            sigma_y_sd = double(0);
            vals_r__ = context__.vals_r("sigma_y_sd");
            pos__ = 0;
            sigma_y_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "sigma_y_sd", sigma_y_sd, 0);

            current_statement_begin__ = 268;
            context__.validate_dims("data initialization", "beta_fixed_mean", "double", context__.to_vec());
            beta_fixed_mean = double(0);
            vals_r__ = context__.vals_r("beta_fixed_mean");
            pos__ = 0;
            beta_fixed_mean = vals_r__[pos__++];

            current_statement_begin__ = 269;
            context__.validate_dims("data initialization", "beta_rw1_mean", "double", context__.to_vec());
            beta_rw1_mean = double(0);
            vals_r__ = context__.vals_r("beta_rw1_mean");
            pos__ = 0;
            beta_rw1_mean = vals_r__[pos__++];

            current_statement_begin__ = 270;
            context__.validate_dims("data initialization", "beta_rw2_mean", "double", context__.to_vec());
            beta_rw2_mean = double(0);
            vals_r__ = context__.vals_r("beta_rw2_mean");
            pos__ = 0;
            beta_rw2_mean = vals_r__[pos__++];

            current_statement_begin__ = 271;
            context__.validate_dims("data initialization", "beta_fixed_sd", "double", context__.to_vec());
            beta_fixed_sd = double(0);
            vals_r__ = context__.vals_r("beta_fixed_sd");
            pos__ = 0;
            beta_fixed_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "beta_fixed_sd", beta_fixed_sd, 0);

            current_statement_begin__ = 272;
            context__.validate_dims("data initialization", "beta_rw1_sd", "double", context__.to_vec());
            beta_rw1_sd = double(0);
            vals_r__ = context__.vals_r("beta_rw1_sd");
            pos__ = 0;
            beta_rw1_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "beta_rw1_sd", beta_rw1_sd, 0);

            current_statement_begin__ = 273;
            context__.validate_dims("data initialization", "beta_rw2_sd", "double", context__.to_vec());
            beta_rw2_sd = double(0);
            vals_r__ = context__.vals_r("beta_rw2_sd");
            pos__ = 0;
            beta_rw2_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "beta_rw2_sd", beta_rw2_sd, 0);

            current_statement_begin__ = 275;
            context__.validate_dims("data initialization", "sigma_rw1_mean", "double", context__.to_vec());
            sigma_rw1_mean = double(0);
            vals_r__ = context__.vals_r("sigma_rw1_mean");
            pos__ = 0;
            sigma_rw1_mean = vals_r__[pos__++];

            current_statement_begin__ = 276;
            context__.validate_dims("data initialization", "sigma_rw2_mean", "double", context__.to_vec());
            sigma_rw2_mean = double(0);
            vals_r__ = context__.vals_r("sigma_rw2_mean");
            pos__ = 0;
            sigma_rw2_mean = vals_r__[pos__++];

            current_statement_begin__ = 277;
            context__.validate_dims("data initialization", "sigma_rw1_sd", "double", context__.to_vec());
            sigma_rw1_sd = double(0);
            vals_r__ = context__.vals_r("sigma_rw1_sd");
            pos__ = 0;
            sigma_rw1_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "sigma_rw1_sd", sigma_rw1_sd, 0);

            current_statement_begin__ = 278;
            context__.validate_dims("data initialization", "sigma_rw2_sd", "double", context__.to_vec());
            sigma_rw2_sd = double(0);
            vals_r__ = context__.vals_r("sigma_rw2_sd");
            pos__ = 0;
            sigma_rw2_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "sigma_rw2_sd", sigma_rw2_sd, 0);

            current_statement_begin__ = 280;
            context__.validate_dims("data initialization", "slope_mean", "double", context__.to_vec());
            slope_mean = double(0);
            vals_r__ = context__.vals_r("slope_mean");
            pos__ = 0;
            slope_mean = vals_r__[pos__++];
            check_greater_or_equal(function__, "slope_mean", slope_mean, 0);

            current_statement_begin__ = 281;
            context__.validate_dims("data initialization", "slope_sd", "double", context__.to_vec());
            slope_sd = double(0);
            vals_r__ = context__.vals_r("slope_sd");
            pos__ = 0;
            slope_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "slope_sd", slope_sd, 0);

            current_statement_begin__ = 282;
            validate_non_negative_index("gamma_y", "n", n);
            context__.validate_dims("data initialization", "gamma_y", "vector_d", context__.to_vec(n));
            gamma_y = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("gamma_y");
            pos__ = 0;
            size_t gamma_y_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < gamma_y_j_1_max__; ++j_1__) {
                gamma_y(j_1__) = vals_r__[pos__++];
            }

            current_statement_begin__ = 283;
            validate_non_negative_index("gamma_rw1", "k_rw1", k_rw1);
            validate_non_negative_index("gamma_rw1", "n", n);
            context__.validate_dims("data initialization", "gamma_rw1", "matrix_d", context__.to_vec(k_rw1,n));
            gamma_rw1 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(k_rw1, n);
            vals_r__ = context__.vals_r("gamma_rw1");
            pos__ = 0;
            size_t gamma_rw1_j_2_max__ = n;
            size_t gamma_rw1_j_1_max__ = k_rw1;
            for (size_t j_2__ = 0; j_2__ < gamma_rw1_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < gamma_rw1_j_1_max__; ++j_1__) {
                    gamma_rw1(j_1__, j_2__) = vals_r__[pos__++];
                }
            }

            current_statement_begin__ = 284;
            validate_non_negative_index("gamma_rw2", "k_rw2", k_rw2);
            validate_non_negative_index("gamma_rw2", "n", n);
            context__.validate_dims("data initialization", "gamma_rw2", "matrix_d", context__.to_vec(k_rw2,n));
            gamma_rw2 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(k_rw2, n);
            vals_r__ = context__.vals_r("gamma_rw2");
            pos__ = 0;
            size_t gamma_rw2_j_2_max__ = n;
            size_t gamma_rw2_j_1_max__ = k_rw2;
            for (size_t j_2__ = 0; j_2__ < gamma_rw2_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < gamma_rw2_j_1_max__; ++j_1__) {
                    gamma_rw2(j_1__, j_2__) = vals_r__[pos__++];
                }
            }


            // initialize transformed data variables
            current_statement_begin__ = 288;
            validate_non_negative_index("a1", "m", m);
            a1 = Eigen::Matrix<double, Eigen::Dynamic, 1>(m);
            stan::math::fill(a1, DUMMY_VAR__);

            current_statement_begin__ = 289;
            validate_non_negative_index("P1", "m", m);
            validate_non_negative_index("P1", "m", m);
            P1 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(m, m);
            stan::math::fill(P1, DUMMY_VAR__);
            stan::math::assign(P1,rep_matrix(0.0, m, m));

            current_statement_begin__ = 290;
            validate_non_negative_index("Tt", "m", m);
            validate_non_negative_index("Tt", "m", m);
            Tt = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(m, m);
            stan::math::fill(Tt, DUMMY_VAR__);
            stan::math::assign(Tt,diag_matrix(rep_vector(1.0, m)));

            current_statement_begin__ = 291;
            validate_non_negative_index("gamma2_y", "n", n);
            gamma2_y = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            stan::math::fill(gamma2_y, DUMMY_VAR__);
            stan::math::assign(gamma2_y,elt_multiply(gamma_y, gamma_y));

            // execute transformed data statements
            current_statement_begin__ = 293;
            stan::model::assign(Tt, 
                        stan::model::cons_list(stan::model::index_min_max((k_rw1 + 1), k), stan::model::cons_list(stan::model::index_min_max((k + 1), m), stan::model::nil_index_list())), 
                        diag_matrix(rep_vector(1.0, k_rw2)), 
                        "assigning variable Tt");
            current_statement_begin__ = 295;
            for (int i = 1; i <= k_rw1; ++i) {

                current_statement_begin__ = 296;
                stan::model::assign(a1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            beta_rw1_mean, 
                            "assigning variable a1");
                current_statement_begin__ = 297;
                stan::model::assign(P1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                            pow(beta_rw1_sd, 2), 
                            "assigning variable P1");
            }
            current_statement_begin__ = 299;
            for (int i = (k_rw1 + 1); i <= k; ++i) {

                current_statement_begin__ = 300;
                stan::model::assign(a1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            beta_rw2_mean, 
                            "assigning variable a1");
                current_statement_begin__ = 301;
                stan::model::assign(P1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                            pow(beta_rw2_sd, 2), 
                            "assigning variable P1");
            }
            current_statement_begin__ = 303;
            for (int i = (k + 1); i <= m; ++i) {

                current_statement_begin__ = 304;
                stan::model::assign(a1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            slope_mean, 
                            "assigning variable a1");
                current_statement_begin__ = 305;
                stan::model::assign(P1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                            pow(slope_sd, 2), 
                            "assigning variable P1");
            }

            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 311;
            validate_non_negative_index("beta_fixed", "k_fixed", k_fixed);
            num_params_r__ += k_fixed;
            current_statement_begin__ = 312;
            validate_non_negative_index("sigma_rw1", "k_rw1", k_rw1);
            num_params_r__ += (1 * k_rw1);
            current_statement_begin__ = 313;
            validate_non_negative_index("sigma_rw2", "k_rw2", k_rw2);
            num_params_r__ += (1 * k_rw2);
            current_statement_begin__ = 314;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_walker_lm() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        current_statement_begin__ = 311;
        if (!(context__.contains_r("beta_fixed")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta_fixed missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta_fixed");
        pos__ = 0U;
        validate_non_negative_index("beta_fixed", "k_fixed", k_fixed);
        context__.validate_dims("parameter initialization", "beta_fixed", "vector_d", context__.to_vec(k_fixed));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta_fixed(k_fixed);
        size_t beta_fixed_j_1_max__ = k_fixed;
        for (size_t j_1__ = 0; j_1__ < beta_fixed_j_1_max__; ++j_1__) {
            beta_fixed(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta_fixed);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta_fixed: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        current_statement_begin__ = 312;
        if (!(context__.contains_r("sigma_rw1")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_rw1 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_rw1");
        pos__ = 0U;
        validate_non_negative_index("sigma_rw1", "k_rw1", k_rw1);
        context__.validate_dims("parameter initialization", "sigma_rw1", "double", context__.to_vec(k_rw1));
        std::vector<double> sigma_rw1(k_rw1, double(0));
        size_t sigma_rw1_k_0_max__ = k_rw1;
        for (size_t k_0__ = 0; k_0__ < sigma_rw1_k_0_max__; ++k_0__) {
            sigma_rw1[k_0__] = vals_r__[pos__++];
        }
        size_t sigma_rw1_i_0_max__ = k_rw1;
        for (size_t i_0__ = 0; i_0__ < sigma_rw1_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, sigma_rw1[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_rw1: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }

        current_statement_begin__ = 313;
        if (!(context__.contains_r("sigma_rw2")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_rw2 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_rw2");
        pos__ = 0U;
        validate_non_negative_index("sigma_rw2", "k_rw2", k_rw2);
        context__.validate_dims("parameter initialization", "sigma_rw2", "double", context__.to_vec(k_rw2));
        std::vector<double> sigma_rw2(k_rw2, double(0));
        size_t sigma_rw2_k_0_max__ = k_rw2;
        for (size_t k_0__ = 0; k_0__ < sigma_rw2_k_0_max__; ++k_0__) {
            sigma_rw2[k_0__] = vals_r__[pos__++];
        }
        size_t sigma_rw2_i_0_max__ = k_rw2;
        for (size_t i_0__ = 0; i_0__ < sigma_rw2_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, sigma_rw2[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_rw2: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }

        current_statement_begin__ = 314;
        if (!(context__.contains_r("sigma_y")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_y missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_y");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma_y", "double", context__.to_vec());
        double sigma_y(0);
        sigma_y = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma_y);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_y: ") + e.what()), current_statement_begin__, prog_reader__());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);

            // model parameters
            current_statement_begin__ = 311;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta_fixed;
            (void) beta_fixed;  // dummy to suppress unused var warning
            if (jacobian__)
                beta_fixed = in__.vector_constrain(k_fixed, lp__);
            else
                beta_fixed = in__.vector_constrain(k_fixed);

            current_statement_begin__ = 312;
            std::vector<local_scalar_t__> sigma_rw1;
            size_t sigma_rw1_d_0_max__ = k_rw1;
            sigma_rw1.reserve(sigma_rw1_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < sigma_rw1_d_0_max__; ++d_0__) {
                if (jacobian__)
                    sigma_rw1.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    sigma_rw1.push_back(in__.scalar_lb_constrain(0));
            }

            current_statement_begin__ = 313;
            std::vector<local_scalar_t__> sigma_rw2;
            size_t sigma_rw2_d_0_max__ = k_rw2;
            sigma_rw2.reserve(sigma_rw2_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < sigma_rw2_d_0_max__; ++d_0__) {
                if (jacobian__)
                    sigma_rw2.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    sigma_rw2.push_back(in__.scalar_lb_constrain(0));
            }

            current_statement_begin__ = 314;
            local_scalar_t__ sigma_y;
            (void) sigma_y;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_y = in__.scalar_lb_constrain(0, lp__);
            else
                sigma_y = in__.scalar_lb_constrain(0);

            // transformed parameters
            current_statement_begin__ = 318;
            validate_non_negative_index("Rt", "m", m);
            validate_non_negative_index("Rt", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> Rt(m, n);
            stan::math::initialize(Rt, DUMMY_VAR__);
            stan::math::fill(Rt, DUMMY_VAR__);
            stan::math::assign(Rt,rep_matrix(0.0, m, n));

            current_statement_begin__ = 319;
            validate_non_negative_index("xbeta", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> xbeta(n);
            stan::math::initialize(xbeta, DUMMY_VAR__);
            stan::math::fill(xbeta, DUMMY_VAR__);

            current_statement_begin__ = 320;
            validate_non_negative_index("y_", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> y_(n);
            stan::math::initialize(y_, DUMMY_VAR__);
            stan::math::fill(y_, DUMMY_VAR__);

            // transformed parameters block statements
            current_statement_begin__ = 322;
            if (as_bool(logical_gt(k_fixed, 0))) {

                current_statement_begin__ = 323;
                stan::math::assign(xbeta, multiply(xreg_fixed, beta_fixed));
            } else {

                current_statement_begin__ = 325;
                stan::math::assign(xbeta, rep_vector(0.0, n));
            }
            current_statement_begin__ = 327;
            stan::math::assign(y_, subtract(y, xbeta));
            current_statement_begin__ = 328;
            for (int t = 1; t <= n; ++t) {

                current_statement_begin__ = 329;
                for (int i = 1; i <= k_rw1; ++i) {

                    current_statement_begin__ = 330;
                    stan::model::assign(Rt, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                pow((get_base1(gamma_rw1, i, t, "gamma_rw1", 1) * get_base1(sigma_rw1, i, "sigma_rw1", 1)), 2), 
                                "assigning variable Rt");
                }
                current_statement_begin__ = 332;
                for (int i = 1; i <= k_rw2; ++i) {

                    current_statement_begin__ = 333;
                    stan::model::assign(Rt, 
                                stan::model::cons_list(stan::model::index_uni((k + i)), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                pow((get_base1(gamma_rw2, i, t, "gamma_rw2", 1) * get_base1(sigma_rw2, i, "sigma_rw2", 1)), 2), 
                                "assigning variable Rt");
                }
            }

            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            current_statement_begin__ = 318;
            size_t Rt_j_1_max__ = m;
            size_t Rt_j_2_max__ = n;
            for (size_t j_1__ = 0; j_1__ < Rt_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < Rt_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(Rt(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: Rt" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable Rt: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 319;
            size_t xbeta_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < xbeta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(xbeta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: xbeta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable xbeta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 320;
            size_t y__j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y__j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(y_(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: y_" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable y_: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }

            // model body

            current_statement_begin__ = 339;
            lp_accum__.add(normal_log<propto__>(sigma_y, sigma_y_mean, sigma_y_sd));
            current_statement_begin__ = 340;
            lp_accum__.add(normal_log<propto__>(beta_fixed, beta_fixed_mean, beta_fixed_sd));
            current_statement_begin__ = 341;
            lp_accum__.add(normal_log<propto__>(sigma_rw1, sigma_rw1_mean, sigma_rw1_sd));
            current_statement_begin__ = 342;
            lp_accum__.add(normal_log<propto__>(sigma_rw2, sigma_rw2_mean, sigma_rw2_sd));
            current_statement_begin__ = 344;
            lp_accum__.add(gaussian_filter(y_, y_miss, a1, P1, pow(sigma_y, 2), Tt, Rt, xreg_rw, gamma2_y, pstream__));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("beta_fixed");
        names__.push_back("sigma_rw1");
        names__.push_back("sigma_rw2");
        names__.push_back("sigma_y");
        names__.push_back("Rt");
        names__.push_back("xbeta");
        names__.push_back("y_");
        names__.push_back("y_rep");
        names__.push_back("beta_rw");
        names__.push_back("slope");
        names__.push_back("y_fit");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(k_fixed);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k_rw1);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k_rw2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(m);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(k_rw2);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_walker_lm_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning

        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta_fixed = in__.vector_constrain(k_fixed);
        size_t beta_fixed_j_1_max__ = k_fixed;
        for (size_t j_1__ = 0; j_1__ < beta_fixed_j_1_max__; ++j_1__) {
            vars__.push_back(beta_fixed(j_1__));
        }

        std::vector<double> sigma_rw1;
        size_t sigma_rw1_d_0_max__ = k_rw1;
        sigma_rw1.reserve(sigma_rw1_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < sigma_rw1_d_0_max__; ++d_0__) {
            sigma_rw1.push_back(in__.scalar_lb_constrain(0));
        }
        size_t sigma_rw1_k_0_max__ = k_rw1;
        for (size_t k_0__ = 0; k_0__ < sigma_rw1_k_0_max__; ++k_0__) {
            vars__.push_back(sigma_rw1[k_0__]);
        }

        std::vector<double> sigma_rw2;
        size_t sigma_rw2_d_0_max__ = k_rw2;
        sigma_rw2.reserve(sigma_rw2_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < sigma_rw2_d_0_max__; ++d_0__) {
            sigma_rw2.push_back(in__.scalar_lb_constrain(0));
        }
        size_t sigma_rw2_k_0_max__ = k_rw2;
        for (size_t k_0__ = 0; k_0__ < sigma_rw2_k_0_max__; ++k_0__) {
            vars__.push_back(sigma_rw2[k_0__]);
        }

        double sigma_y = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma_y);

        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        if (!include_tparams__ && !include_gqs__) return;

        try {
            // declare and define transformed parameters
            current_statement_begin__ = 318;
            validate_non_negative_index("Rt", "m", m);
            validate_non_negative_index("Rt", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Rt(m, n);
            stan::math::initialize(Rt, DUMMY_VAR__);
            stan::math::fill(Rt, DUMMY_VAR__);
            stan::math::assign(Rt,rep_matrix(0.0, m, n));

            current_statement_begin__ = 319;
            validate_non_negative_index("xbeta", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> xbeta(n);
            stan::math::initialize(xbeta, DUMMY_VAR__);
            stan::math::fill(xbeta, DUMMY_VAR__);

            current_statement_begin__ = 320;
            validate_non_negative_index("y_", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> y_(n);
            stan::math::initialize(y_, DUMMY_VAR__);
            stan::math::fill(y_, DUMMY_VAR__);

            // do transformed parameters statements
            current_statement_begin__ = 322;
            if (as_bool(logical_gt(k_fixed, 0))) {

                current_statement_begin__ = 323;
                stan::math::assign(xbeta, multiply(xreg_fixed, beta_fixed));
            } else {

                current_statement_begin__ = 325;
                stan::math::assign(xbeta, rep_vector(0.0, n));
            }
            current_statement_begin__ = 327;
            stan::math::assign(y_, subtract(y, xbeta));
            current_statement_begin__ = 328;
            for (int t = 1; t <= n; ++t) {

                current_statement_begin__ = 329;
                for (int i = 1; i <= k_rw1; ++i) {

                    current_statement_begin__ = 330;
                    stan::model::assign(Rt, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                pow((get_base1(gamma_rw1, i, t, "gamma_rw1", 1) * get_base1(sigma_rw1, i, "sigma_rw1", 1)), 2), 
                                "assigning variable Rt");
                }
                current_statement_begin__ = 332;
                for (int i = 1; i <= k_rw2; ++i) {

                    current_statement_begin__ = 333;
                    stan::model::assign(Rt, 
                                stan::model::cons_list(stan::model::index_uni((k + i)), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                pow((get_base1(gamma_rw2, i, t, "gamma_rw2", 1) * get_base1(sigma_rw2, i, "sigma_rw2", 1)), 2), 
                                "assigning variable Rt");
                }
            }

            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning

            // write transformed parameters
            if (include_tparams__) {
                size_t Rt_j_2_max__ = n;
                size_t Rt_j_1_max__ = m;
                for (size_t j_2__ = 0; j_2__ < Rt_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < Rt_j_1_max__; ++j_1__) {
                        vars__.push_back(Rt(j_1__, j_2__));
                    }
                }
                size_t xbeta_j_1_max__ = n;
                for (size_t j_1__ = 0; j_1__ < xbeta_j_1_max__; ++j_1__) {
                    vars__.push_back(xbeta(j_1__));
                }
                size_t y__j_1_max__ = n;
                for (size_t j_1__ = 0; j_1__ < y__j_1_max__; ++j_1__) {
                    vars__.push_back(y_(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 349;
            validate_non_negative_index("y_rep", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> y_rep(n);
            stan::math::initialize(y_rep, DUMMY_VAR__);
            stan::math::fill(y_rep, DUMMY_VAR__);

            current_statement_begin__ = 350;
            validate_non_negative_index("beta_rw", "k", k);
            validate_non_negative_index("beta_rw", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> beta_rw(k, n);
            stan::math::initialize(beta_rw, DUMMY_VAR__);
            stan::math::fill(beta_rw, DUMMY_VAR__);

            current_statement_begin__ = 351;
            validate_non_negative_index("slope", "k_rw2", k_rw2);
            validate_non_negative_index("slope", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> slope(k_rw2, n);
            stan::math::initialize(slope, DUMMY_VAR__);
            stan::math::fill(slope, DUMMY_VAR__);

            current_statement_begin__ = 352;
            validate_non_negative_index("y_fit", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> y_fit(n);
            stan::math::initialize(y_fit, DUMMY_VAR__);
            stan::math::fill(y_fit, DUMMY_VAR__);

            // generated quantities statements
            current_statement_begin__ = 356;
            for (int i = 1; i <= k_rw1; ++i) {

                current_statement_begin__ = 357;
                stan::model::assign(beta_rw, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            normal_rng(beta_rw1_mean, beta_rw1_sd, base_rng__), 
                            "assigning variable beta_rw");
            }
            current_statement_begin__ = 359;
            for (int i = 1; i <= k_rw2; ++i) {

                current_statement_begin__ = 360;
                stan::model::assign(beta_rw, 
                            stan::model::cons_list(stan::model::index_uni((k_rw1 + i)), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            normal_rng(beta_rw2_mean, beta_rw2_sd, base_rng__), 
                            "assigning variable beta_rw");
                current_statement_begin__ = 361;
                stan::model::assign(slope, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            normal_rng(slope_mean, slope_sd, base_rng__), 
                            "assigning variable slope");
            }
            current_statement_begin__ = 364;
            for (int t = 1; t <= (n - 1); ++t) {

                current_statement_begin__ = 365;
                for (int i = 1; i <= k_rw1; ++i) {

                    current_statement_begin__ = 366;
                    stan::model::assign(beta_rw, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), 
                                normal_rng(get_base1(beta_rw, i, t, "beta_rw", 1), (get_base1(gamma_rw1, i, t, "gamma_rw1", 1) * get_base1(sigma_rw1, i, "sigma_rw1", 1)), base_rng__), 
                                "assigning variable beta_rw");
                }
                current_statement_begin__ = 368;
                for (int i = 1; i <= k_rw2; ++i) {

                    current_statement_begin__ = 369;
                    stan::model::assign(beta_rw, 
                                stan::model::cons_list(stan::model::index_uni((k_rw1 + i)), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), 
                                (get_base1(beta_rw, (k_rw1 + i), t, "beta_rw", 1) + get_base1(slope, i, t, "slope", 1)), 
                                "assigning variable beta_rw");
                    current_statement_begin__ = 370;
                    stan::model::assign(slope, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni((t + 1)), stan::model::nil_index_list())), 
                                normal_rng(get_base1(slope, i, t, "slope", 1), (get_base1(gamma_rw2, i, t, "gamma_rw2", 1) * get_base1(sigma_rw2, i, "sigma_rw2", 1)), base_rng__), 
                                "assigning variable slope");
                }
            }
            current_statement_begin__ = 374;
            for (int t = 1; t <= n; ++t) {

                current_statement_begin__ = 375;
                stan::model::assign(y_rep, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            normal_rng(dot_product(stan::model::rvalue(xreg_rw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg_rw"), stan::model::rvalue(beta_rw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "beta_rw")), (get_base1(gamma_y, t, "gamma_y", 1) * sigma_y), base_rng__), 
                            "assigning variable y_rep");
            }
            {
            current_statement_begin__ = 379;
            validate_non_negative_index("states", "m", m);
            validate_non_negative_index("states", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> states(m, n);
            stan::math::initialize(states, DUMMY_VAR__);
            stan::math::fill(states, DUMMY_VAR__);
            stan::math::assign(states,gaussian_smoother(subtract(y_, y_rep), y_miss, a1, P1, pow(sigma_y, 2), Tt, Rt, xreg_rw, gamma2_y, pstream__));


            current_statement_begin__ = 381;
            stan::math::assign(beta_rw, add(beta_rw, stan::model::rvalue(states, stan::model::cons_list(stan::model::index_min_max(1, k), stan::model::cons_list(stan::model::index_min_max(1, n), stan::model::nil_index_list())), "states")));
            current_statement_begin__ = 382;
            stan::math::assign(slope, add(slope, stan::model::rvalue(states, stan::model::cons_list(stan::model::index_min_max((k + 1), m), stan::model::cons_list(stan::model::index_min_max(1, n), stan::model::nil_index_list())), "states")));
            }
            current_statement_begin__ = 386;
            for (int t = 1; t <= n; ++t) {

                current_statement_begin__ = 387;
                stan::model::assign(y_fit, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            (get_base1(xbeta, t, "xbeta", 1) + dot_product(stan::model::rvalue(xreg_rw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "xreg_rw"), stan::model::rvalue(beta_rw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), "beta_rw"))), 
                            "assigning variable y_fit");
                current_statement_begin__ = 388;
                stan::model::assign(y_rep, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            normal_rng(get_base1(y_fit, t, "y_fit", 1), (get_base1(gamma_y, t, "gamma_y", 1) * sigma_y), base_rng__), 
                            "assigning variable y_rep");
            }

            // validate, write generated quantities
            current_statement_begin__ = 349;
            size_t y_rep_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y_rep_j_1_max__; ++j_1__) {
                vars__.push_back(y_rep(j_1__));
            }

            current_statement_begin__ = 350;
            size_t beta_rw_j_2_max__ = n;
            size_t beta_rw_j_1_max__ = k;
            for (size_t j_2__ = 0; j_2__ < beta_rw_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < beta_rw_j_1_max__; ++j_1__) {
                    vars__.push_back(beta_rw(j_1__, j_2__));
                }
            }

            current_statement_begin__ = 351;
            size_t slope_j_2_max__ = n;
            size_t slope_j_1_max__ = k_rw2;
            for (size_t j_2__ = 0; j_2__ < slope_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < slope_j_1_max__; ++j_1__) {
                    vars__.push_back(slope(j_1__, j_2__));
                }
            }

            current_statement_begin__ = 352;
            size_t y_fit_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y_fit_j_1_max__; ++j_1__) {
                vars__.push_back(y_fit(j_1__));
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_walker_lm";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t beta_fixed_j_1_max__ = k_fixed;
        for (size_t j_1__ = 0; j_1__ < beta_fixed_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_fixed" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_rw1_k_0_max__ = k_rw1;
        for (size_t k_0__ = 0; k_0__ < sigma_rw1_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_rw1" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_rw2_k_0_max__ = k_rw2;
        for (size_t k_0__ = 0; k_0__ < sigma_rw2_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_rw2" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_y";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            size_t Rt_j_2_max__ = n;
            size_t Rt_j_1_max__ = m;
            for (size_t j_2__ = 0; j_2__ < Rt_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Rt_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "Rt" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t xbeta_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < xbeta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "xbeta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t y__j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y__j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
        size_t y_rep_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < y_rep_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_rep" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_rw_j_2_max__ = n;
        size_t beta_rw_j_1_max__ = k;
        for (size_t j_2__ = 0; j_2__ < beta_rw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_rw_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_rw" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t slope_j_2_max__ = n;
        size_t slope_j_1_max__ = k_rw2;
        for (size_t j_2__ = 0; j_2__ < slope_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < slope_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "slope" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t y_fit_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < y_fit_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_fit" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t beta_fixed_j_1_max__ = k_fixed;
        for (size_t j_1__ = 0; j_1__ < beta_fixed_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_fixed" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_rw1_k_0_max__ = k_rw1;
        for (size_t k_0__ = 0; k_0__ < sigma_rw1_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_rw1" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_rw2_k_0_max__ = k_rw2;
        for (size_t k_0__ = 0; k_0__ < sigma_rw2_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_rw2" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_y";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            size_t Rt_j_2_max__ = n;
            size_t Rt_j_1_max__ = m;
            for (size_t j_2__ = 0; j_2__ < Rt_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Rt_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "Rt" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t xbeta_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < xbeta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "xbeta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t y__j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < y__j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
        size_t y_rep_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < y_rep_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_rep" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_rw_j_2_max__ = n;
        size_t beta_rw_j_1_max__ = k;
        for (size_t j_2__ = 0; j_2__ < beta_rw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_rw_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_rw" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t slope_j_2_max__ = n;
        size_t slope_j_1_max__ = k_rw2;
        for (size_t j_2__ = 0; j_2__ < slope_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < slope_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "slope" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t y_fit_j_1_max__ = n;
        for (size_t j_1__ = 0; j_1__ < y_fit_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_fit" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

}  // namespace




#endif
