% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wTOfast.R
\name{wTO.fast}
\alias{wTO.fast}
\title{wTO.fast}
\usage{
wTO.fast(Data, Overlap = row.names(Data), method = "p", sign = "sign",
  delta = 0.2, n = 10, method_resampling = "Bootstrap", lag = NULL)
}
\arguments{
\item{Data}{data.frame containing the count / expression data for the correlation.}

\item{Overlap}{Set of nodes of interest, where the Overlapping weights will be computed.}

\item{method}{Type of the correlation that should be used. "s" / "spearman" will compute the rank spearman correlation, "p" / "pearson" will compute the linear correlation. If no value is given, the default is to use "p".}

\item{sign}{Should the wTO be signed?}

\item{delta}{expected difference between the real wTO and the bootstraped.}

\item{n}{Number of resamplings, used to compute the empirical distribuitions of the links. Default is set to 100.}

\item{method_resampling}{method of the resampling. Bootstrap or BlockBootstrap.If the second is used, please give the lag (time dependency among the data).}

\item{lag}{Time dependency for the blocked bootstrap.}
}
\description{
Compute the wTO and also the bootstraps. Proposed at arXiv:1711.04702. This is a quicker version of the wTO.Complete. It doesn'T contain diagnose plots nor a parallel version.
}
\examples{
wTO.fast(Data = Microarray_Expression1,
Overlap = ExampleGRF$x, 
method = "p")
wTO.fast(Data = Microarray_Expression1,
Overlap = ExampleGRF$x, 
method = "p", 
method_resampling = 'BlockBootstrap', 
lag = 4)
}
\author{
Deisy Morselli Gysi <deisy at bioinf.uni-leipzig.de>
}
