% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authenticate_server.R
\name{authenticate_server}
\alias{authenticate_server}
\title{Authenticate on the Tableau server.}
\usage{
authenticate_server(username, password, base_url, api_version = 3.4)
}
\arguments{
\item{username}{The username on the Tableau server.}

\item{password}{The password on the Tableau server.}

\item{base_url}{The base url of the Tableau server.}

\item{api_version}{The api version.}
}
\value{
Dataframe containing authentication variables
}
\description{
Authenticates the users and sets system variables.
These are necessary in order to run the other Tableau REST Api methods.
}
\examples{
\dontrun{
# Authenticate on the Tableau server
authenticate_server(username = "your_username",
                    password = "your_password",
                    base_url = "https://tableau.server.com",
                    api_version = 3.4)
}
# Check the set system variables
Sys.getenv("TABLEAU_API_TOKEN")
Sys.getenv("TABLEAU_API_SITE_ID")
Sys.getenv("TABLEAU_API_USER_ID")
}
\seealso{
Other tableau rest api: 
\code{\link{download_workbooks_server_pdf}()},
\code{\link{download_workbooks_server_powerpoint}()},
\code{\link{download_workbooks_server}()},
\code{\link{get_server_connected_apps}()},
\code{\link{get_server_datasources}()},
\code{\link{get_server_groups}()},
\code{\link{get_server_info}()},
\code{\link{get_server_jobs}()},
\code{\link{get_server_projects}()},
\code{\link{get_server_refresh_tasks}()},
\code{\link{get_server_schedules}()},
\code{\link{get_server_users}()},
\code{\link{get_server_views}()},
\code{\link{get_server_workbooks}()}
}
\concept{tableau rest api}
