% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_department_grade_data.R
\name{get_department_grade_data}
\alias{get_department_grade_data}
\title{Get department-level grade data from the Canvas LMS API}
\usage{
get_department_grade_data(
  canvas,
  account_id,
  type = "current",
  term_id = NULL,
  per_page = 100
)
}
\arguments{
\item{canvas}{A list containing the 'api_key' and 'base_url' for authentication.}

\item{account_id}{The ID of the account for which to retrieve the grade data.}

\item{type}{The type of courses to include in the data. Can be 'current', 'completed', or 'term'.}

\item{term_id}{The ID of the term for which to retrieve the grade data. Only used when type is 'terms/<term_id>'.}

\item{per_page}{Number of grade data to retrieve per page. Default is 100.}
}
\value{
A data frame of grade data retrieved from the Canvas LMS API.
}
\description{
Retrieves the department-level grade data for a specific account and term from the Canvas LMS API.
}
