% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_handling.R
\name{collate_proc_data}
\alias{collate_proc_data}
\title{Collate processed data generated by any of the 'collate' functions}
\usage{
collate_proc_data(data, save2disk = TRUE, dir_out = "ProcessedData")
}
\arguments{
\item{data}{A list where each element is a df from \code{collate_[dat, yr, run]}}

\item{save2disk}{Whether to save the data as rda and csv, default: TRUE}

\item{dir_out}{The local path to store the output. Default: ProcessedData}
}
\value{
A data.frame with the collated data. Missing data are filled with NA.
}
\description{
\code{collate_proc_data} collates multiple data frames generated by any of the
'collate' functions. This may be useful when, for example, data generated by
different ST scenarios and/or 'standard' scenario runs are to be combined
into a unique dataframe that can then be passed to other functions.
}
\details{
Only dfs generated by the same function can be combined together. Missing data
are filled with NA.

When \code{save2disk=TRUE} the output file will be named 'CombinedDB'.
\code{dir_out} is created within the working directory unless a full path is
provided.
}
\examples{
# Using Campbell et al. example data. See ?sta.main, ?sta.evy5, ?sta.evy5.b11
# for more details.
data(sta.main, sta.evy5, sta.evy5.b11)
dfs <- list(sta.main, sta.evy5, sta.evy5.b11)
combined <- collate_proc_data(dfs, save2disk=FALSE)
}
