% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_handling.R
\name{collate_dat}
\alias{collate_dat}
\title{Collate Vortex .dat or .stdat output files into one data.frame}
\usage{
collate_dat(project, runs, scenario = NULL, dir_in = NULL,
  save2disk = TRUE, dir_out = "ProcessedData", verbose = TRUE)
}
\arguments{
\item{project}{The Vortex project name to be imported}

\item{runs}{The number of Vortex simulation runs}

\item{scenario}{The scenario name if ST, default: NULL}

\item{dir_in}{The local folder containing Vortex files, default: NULL. If
not specified, will fall back to use current working directory.}

\item{save2disk}{Whether to save the data as rda and csv, default: TRUE}

\item{dir_out}{The local path to store the output. Default: ProcessedData}

\item{verbose}{Progress messages, default: TRUE}
}
\value{
a data.frame with data from all matching Vortex files or NULL
}
\description{
\code{collate_dat} collates all Vortex output files matching a given project
name (and scenario name when relevant) in a given directory into one
data.frame using \code{collate_one_dat}.
}
\details{
The number of Vortex simulation runs has to be specified, as it cannot be
inferred by vortexR.

To read Vortex output files from Sensitivity Testing with the extension
'.stdat', specify the scenario name. If \code{scenario=NULL}, all files with
extension .dat, matching the project name will be imported.

\code{dir_in} may contain other files; only files matching the project (and,
optionally, the scenario) name will be read.

\code{dir_out} is created within the working directory unless a full path is
provided.

If no matching files are found in the given directory, an error is reported.

When \code{verbose=TRUE} the progress (i.e. the file being read) is reported
on screen.
}
\examples{
# Using Campbell et al. and Pacioni et al. example files.
# See ?pacioni and ?campbell for more details on example files.
require(vortexRdata)
camp.dir <- system.file('extdata', 'campbell', package='vortexRdata')
pac.dir <- system.file('extdata', 'pacioni', package='vortexRdata')

# Campbell example, project 'Starlingv3PopBased' (.dat)
starling <- collate_dat('Starlingv3PopBased', 10000,
            dir_in=camp.dir, save2disk=FALSE)

# Read data from all .stdat of the project 'Pacioni_et_al' and the ST scenario
#   'ST_Classic' and store the output in the object 'woylie.st.classic'
woylie.st.classic <- collate_dat('Pacioni_et_al', 3, scenario = 'ST_Classic',
                     dir_in = pac.dir, save2disk=FALSE)

# Save collated data as .Rda and .txt
\dontrun{
# Read data from all .stdat of the project 'Pacioni_et_al' and the ST scenario
#   'ST_Classic'. Store the output in the object 'woylie.st.classic' and save
#   to disk
woylie.st.classic <- collate_dat('Pacioni_et_al', 3, scenario = 'ST_Classic',
                     dir_in = pac.dir, save2disk=TRUE)
}
}
