% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pext.R
\name{Pextinct}
\alias{Pextinct}
\title{Cumulative probability of extinction at the end of the simulation}
\usage{
Pextinct(data, project, scenario, ST = FALSE, save2disk = TRUE,
  dir_out = "DataAnalysis/Pextinct")
}
\arguments{
\item{data}{The long format of run (lrun, the second element) of the output
from \code{collate_run}}

\item{project}{The Vortex project name}

\item{scenario}{The ST Vortex scenario name or the scenario that should be
used as baseline if simulations were not conducted with the ST module}

\item{ST}{Whether files are from sensitivity analysis (TRUE),
or not (FALSE, default)}

\item{save2disk}{Whether to save the output to disk, default: TRUE}

\item{dir_out}{The local path to store the output. Default: DataAnalysis/Pairwise}
}
\value{
A list with two elements, a table (\code{data.table}) with the mean
  Probability of extinction and its SD, the SSMD and its associated p-value
  for each scenario and population, and a table (\code{data.table}) with each
  iteration where extinction is coded as one (and zero for no extinction)
}
\description{
\code{Pextinct} calculates the cumulative probability of extinction at the by
calculating the proportion of runs in which a population goes extinct for
each scenario.
}
\details{
\code{Pextinct} then compares each scenario by calculating the strictly
standardised mean difference (SSMD, Zhang 2007) and reports this statistic
with its associated p values. Raw data are also reported.
}
\examples{
# Using Pacioni et al. example data. See ?pac.run.lhs for more details.
data(pac.run.lhs)
Pext <- Pextinct(pac.run.lhs[[2]], project='Pacioni_et_al',
  scenario='ST_Classic', ST=TRUE, save2disk=FALSE,
  dir_out='DataAnalysis/Pextinct')
}
\references{
Zhang, X. D. 2007. A pair of new statistical parameters for
  quality control in RNA interference high-throughput screening assays.
  Genomics 89:552-561.
}
