% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_handling.R
\name{conv_l_yr}
\alias{conv_l_yr}
\title{Convert 'census' data into long format}
\usage{
conv_l_yr(data, npops_noMeta = 1, appendMeta = FALSE, project, scenario,
  yrs = c(1, 2), save2disk = TRUE, dir_out = "ProcessedData")
}
\arguments{
\item{data}{The df 'census' from \code{collate_yr}}

\item{npops_noMeta}{The total number of populations excluding the
metapopulation, default: 1}

\item{appendMeta}{Whether to calculate data for the metapopulation,
default: FALSE}

\item{project}{Vortex project name (used to name the output)}

\item{scenario}{Vortex scenario name (used to name the output)}

\item{yrs}{The year(s) that need to be retained in the output}

\item{save2disk}{Whether to save the data as rda and csv, default: TRUE}

\item{dir_out}{The local path to store the output. Default: ProcessedData}
}
\value{
The census data.frame in long format
}
\description{
\code{conv_l_yr} converts the first element of the output from \code{collate_yr}
(census) in long format. This can be then fed into downstream analysis
(e.g. fit_regression)
}
\details{
\code{yrs} is used to indicate the years to be retained in the output. If more
than one year is required, these may be requested defining a numeric vector,
e.g. yrs=c(10, 20, 30). All simulated years can be included in the output by
passing a numeric vector with all years. For example, assuming that 100 years
were simulated, using \code{yrs=1:100} would retain all 100 years in the
output.

\code{dir_out} is created within the working directory unless a full path is
provided.
}
\examples{
# Using Pacioni et al. example data. See ?pac.yr for more details.
data(pac.yr)
lyr.classic <- conv_l_yr(pac.yr[[1]] , yrs=c(60, 120), save2disk=FALSE)
}
