% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependencies.R
\name{addIonicons}
\alias{addIonicons}
\title{Use Ionicons in visNetwork \code{graph}}
\usage{
addIonicons(graph)
}
\arguments{
\item{graph}{: a visNetwork object}
}
\value{
\code{graph} htmlwidget with Ionicons dependencies attached.
}
\description{
Add \href{http://ionicons.com/}{Ionicons} for styling
our \code{graph} with beautiful, professional icons.
See \href{http://ionicons.com/cheatsheet.html}{Cheatsheet} to get CSS content code.
Can also use \link{addFontAwesome}
}
\examples{

nodes <- data.frame(id = 1:3, group = c("B", "A", "B"))
edges <- data.frame(from = c(1,2), to = c(2,3))

visNetwork(nodes, edges) \%>\%
  visGroups(groupname = "A", shape = "icon", 
   icon = list(face ='Ionicons', code = "f101", size = 75)) \%>\%
  visGroups(groupname = "B", shape = "icon", 
   icon = list(face ='Ionicons', code = "f100", color = "red")) \%>\%
  addIonicons()

}
