% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulatePopulation.R
\name{simulatePopulation}
\alias{simulatePopulation}
\title{Simulates population dynamics for virtual species with different traits.}
\usage{
simulatePopulation(
  parameters=NULL,
  species="all",
  driver.A=NULL,
  driver.B=NULL,
  drivers=NULL,
  burnin=TRUE
  )
}
\arguments{
\item{parameters}{dataframe with parameters.}

\item{species}{if "all" or "ALL", all species in "parameters" are simulated It also accepts a vector of numbers representing the rows of the selected species, or a vector of names of the selected species.}

\item{driver.A}{numeric vector with driver values. Typically produced by \code{\link{simulateDriver}}.}

\item{driver.B}{numeric vector with driver values.  Typically produced by \code{\link{simulateDriver}}. Must have same length as \code{driver.A}.}

\item{drivers}{dataframe with drivers produced by \code{\link{simulateDriverS}}. It should have the columns:
\itemize{
  \item \emph{time} integer.
  \item \emph{driver} character, values are \code{A} and \code{B}
  \item \emph{autocorrelation.length} numeric, values are 200, 600, and 1800.
  \item \emph{value} numeric, value of the driver for the given \emph{time}.
}}

\item{burnin}{boolean, generates a warming-up period for the population model of a length of five times the maximum age of the virtual taxa.}
}
\value{
A list of dataframes, each one of them with the results of one simulation. The dataset \code{\link{simulation}} exemplifies the output of this function. Each dataframe in the output list has the columns:
\itemize{
  \item \emph{Time} integer, ages in years. Negative ages indicate the burn-in period.
  \item \emph{Pollen} numeric, pollen counts
  \item \emph{Population.mature} numeric, number of mature individuals.
  \item \emph{Population.immatre} numeric, number of immature individuals.
  \item \emph{Population.viable.seeds} numeric, number of viable seeds generated each year.
  \item \emph{Suitability} numeric, environmental suitability computed from the driver by the normal function/s defining the taxon niche.
  \item \emph{Biomass.total} numeric, overall biomass of the population.
  \item \emph{Biomass.mature} numeric, sum of biomass of mature individuals.
  \item \emph{Biomass.immature} numeric, sum of biomass of immature individuals.
  \item \emph{Mortality.mature} numeric, number of mature individuals dead each year.
  \item \emph{Mortality.immature} numeric, same as above for immature individuals.
  \item \emph{Driver.A} numeric, values of driver A.
  \item \emph{Driver.B} numeric, values of driver B, if available, and NA otherwise.
  \item \emph{Period} qualitative, with value "Burn-in" for burn-in period, and "Simulation" otherwise.
}
}
\description{
This function takes as input a dataframe of parameters defining virtual taxa produced by \code{\link{parametersDataframe}} and \code{\link{fixParametersTypes}}, a driver or drivers generated with \code{\link{simulateDriver}} or \code{\link{simulateDriverS}}, and simulates population dynamics for the given virtual taxa at yearly resolution for the time-length defined by the driver or drivers. \strong{Important}: note that the variable \code{time} runs from left to right, with lower values representing older samples. The model relies on the following set of assumptions:

\itemize{
  \item  The spatial structure of the population is not important to explain its pollen productivity. This is an operative assumption, to speed-up model execution.
  \item  The environmental niche of the species follows a Gaussian distribution, characterized by a mean (niche optimum, also niche position) and a standard deviation (niche breadth or tolerance).
  \item  Different drivers can have a different influence on the species dynamics, and that influence can be defined by the user by tuning the weights of each driver.
  \item  Environmental suitability, expressed in the range [0, 1], is the result of an additive function of the species niches (normal function defined by the species' mean and standard deviation for each driver), the drivers' values, and the relative influence of each driver (driver weights).
  \item  Pollen productivity is a function of the individual's biomass and environmental suitability, so under a hypothetical constant individual's biomass, its pollen production depends linearly on environmental suitability values.
  \item  Effective fecundity is limited by environmental suitability. Low environmental suitability values limit recruitment, acting as an environmental filter. Therefore, even though the fecundity of the individuals is fixed by the fecundity parameter, the overall population fecundity is limited by environmental suitability.
}
}
\details{
The model starts with a population of 100 individuals with random ages, in the range [1, maximum age], taken from a uniform distribution (all ages are equiprobable). For each environmental suitability value, including the burn-in period, the model performs the following operations:

\itemize{
  \item \strong{Aging}: adds one year to the age of the individuals.
  \item \strong{Mortality due to senescence}: individuals reaching the maximum age are removed from the simulation.
  \item \strong{Local extinction and immigration}: If the number of individuals drops to zero, the population is replaced by a "seed bank" of #' 100 individuals with age zero, and the simulation jumps to step 7.. This is intended to simulate the arrival of seeds from nearby regions, and will only lead to population growth if environmental suitability is higher than zero.
  \item \strong{Plant growth}: Applies a plant growth equation to compute the biomass of every individual.
  \item \strong{Carrying capacity}: If maximum population biomass is reached, individuals are iteratively selected for removal according to a mortality risk curve computed by the equation \eqn{P_{m} = 1 - sqrt(a/A)}, were \emph{Pm} is the probability of mortality, \emph{a} is the age of the given individual, and \emph{A} is the maximum age reached by the virtual taxa. This curve gives removal preference to younger individuals, matching observed patterns in natural populations.
  \item \strong{Pollen productivity}: In each time step the model computes the pollen productivity (in relative values) of the population using the equation \eqn{P_{t} = \sum x_{it} \times max(S_{t}, B)}, where \emph{t} is time (a given simulation time step), \emph{P} is the pollen productivity of the population at a given time, \emph{x_{i}} represents the biomass of every adult individual, \emph{S} is the environmental suitability at the given time, \emph{B} is the contribution of biomass to pollen productivity regardless of environmental suitability (\emph{pollen.control} parameter in the simulation, 0 by default). If \emph{B} equals 1, \emph{P} is equal to the total biomass sum of the adult population, regardless of the environmental suitability. If \emph{B} equals 0, pollen productivity depends entirely on environmental suitability values.
  \item \strong{Reproduction}: Generates as many seeds as reproductive individuals are available multiplied by the maximum fecundity and the environmental suitability of the given time.
}
The model returns a table with climatic suitability, pollen production, and population size (reproductive individuals only) per simulation year. Figure 10 shows the results of the population model when applied to the example virtual species.
}
\examples{

#getting data
data(parameters)
data(driverA)

#simulating population dynamics
# of first taxon in parameters
# for first 500 values of driverA
sim.output <- simulatePopulation(
 parameters=parameters[1,],
 driver.A=driverA[1:500]
 )

#checking output
str(sim.output)

}
\seealso{
\code{\link{parametersDataframe}}, \code{\link{fixParametersTypes}}, \code{\link{plotSimulation}}
}
\author{
Blas M. Benito  <blasbenito@gmail.com>
}
