% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vesselness3D.R
\name{vesselness3D}
\alias{vesselness3D}
\title{3D Volume Vesselness}
\usage{
vesselness3D(image, mask, radius = 1, color = "dark", parallel = FALSE,
  cores = 2)
}
\arguments{
\item{image}{a 3D array or image of class \code{\link{nifti}}}

\item{mask}{an array or \code{\link{nifti}} mask of voxels for which vesselness will be calculated,
with more selective masking improving speed significantly.
Note that mask should be in the same space as the image volume}

\item{radius}{an integer specifying radius of the neighborhood (in voxels) for which the vesselness should be calculated.
Note that this value essentially serves as the scale of the vessel objects}

\item{color}{a string specifying whether vessels will appear darker ("dark") or brighter ("bright") than their surroundings}

\item{parallel}{is a logical value that indicates whether the user's computer
is Linux or Unix (i.e. macOS), and should run the code in parallel}

\item{cores}{if parallel = TRUE, cores is an integer value that indicates how many cores
the function should be run on}
}
\value{
A 3D volume of the Frangi vesselness scores.
}
\description{
This function returns a vesselness map for a 3D array or NIfTI volume. This vesseless measure is based on the method described by Frangi (1998).
}
\examples{
\dontrun{
library(neurobase)
epi <- readnii('path/to/epi')
mask <- epi!=0
veins <- vesselness3D(image = epi, mask = mask, radius = 1,
                      color = "dark", parallel = TRUE, cores = 4) }
}
\references{
A.F. Frangi, W.J. Niessen, K.L. Vincken, M.A. Viergever (1998). Multiscale vessel enhancement filtering. In Medical Image Computing and Computer-Assisted Intervention - MICCAI'98, W.M. Wells, A. Colchester and S.L. Delp (Eds.), Lecture Notes in Computer Science, vol. 1496 - Springer Verlag, Berlin, Germany, pp. 130-137.
}
