% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradient3D.R
\name{gradient3D}
\alias{gradient3D}
\title{3D Volume Gradient}
\usage{
gradient3D(image, mask = NULL, which = "all", radius = 1)
}
\arguments{
\item{image}{a 3D array or image of class \code{\link{nifti}}}

\item{mask}{an array or \code{\link{nifti}} mask of voxels for which the gradient will be calculated,
if \code{NULL} the gradient will be run for the full array.
Note that mask should be in the same space as the image volume}

\item{which}{a string specifying the gradient direction that should be returned; either "all" for a list of x, y, and z gradient volumes, or "x", "y", or "z" for a single volume with the given gradient}

\item{radius}{an integer specifying radius of the neighborhood (in voxels) for which the gradient should be calculated}
}
\value{
Either a list of three gradient volumes or a single gradient volume, in either array or NIfTI format based on what was input.
}
\description{
This function returns the gradient images for a 3D array or NIfTI volume.
}
\examples{
\dontrun{
library(neurobase)
epi <- readnii('path/to/epi')
gradients <- gradient3D(image = epi, which = "all") }
}
