% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsampleEvenness.R
\name{subsampleEvenness}
\alias{subsampleEvenness}
\title{Shareholder Quorum Subsampling}
\usage{
subsampleEvenness(Abundance, Quota = 0.9, Trials = 100,
  IgnoreSingletons = FALSE, ExcludeDominant = FALSE)
}
\arguments{
\item{Abundance}{A vector of taxon abundances}

\item{Quota}{A numeric value greater than zero and less than one}

\item{Trials}{Number of iterations}

\item{IgnoreSingletons}{A logical}

\item{ExcludeDominant}{A logical}
}
\value{
A numeric value of estimated taxonomic richness
}
\description{
Calculate the richness of a sample after subsampling based on the evenness of the abundance distribution.
}
\details{
This is a port of S.M. Holland's port of J. Alroy's shareholder quorum subsampling function.

Alroy, J. (2010) "Fair sampling of taxonomic richness and unbiased estimation of origination and extinction rates" \emph{in} Quatitative Methods in Paleobiology, Paleontological Society Short Course 2010. The Paleontological Society Papers V. 16, John Alroy and Gene Hunt (eds.)
}
\examples{

# Download a test dataset of Miocene-Pleistocene bivalves.
# DataPBDB<-downloadPBDB(Taxa="Bivalvia",StartInterval="Miocene",StopInterval="Pleistocene")

 # Clean up the taxonomy by removing subgenus designation
 # DataPBDB<-cleanTaxonomy(DataPBDB,"genus")

# Create a community matrix of genera by tectonic plate ids.
# CommunityMatrix<-abundanceMatrix(DataPBDB,Rows="geoplate",Columns="genus")

# Cull out depauperate samples and rare taxa
# CommunityCull<-cullMatrix(CommunityMatrix,5,100)

# Calculate the standardized richness of each plate at a quota of 0.5.
# StandardizedRichness<-apply(CommunityCull,1,subsampleEvenness,0.5)

}
\author{
Andrew A. Zaffos
}

