% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptiveConfidence.R
\name{adaptiveOrigination}
\alias{adaptiveExtinction}
\alias{adaptiveExtinction,adaptiveOrigination,thetaNegative,thetaPositive,lambdaNegative,lambdaPositive}
\alias{adaptiveOrigination}
\title{Adaptive Beta Functions}
\usage{
adaptiveOrigination(Ages, Confidence = 0.95)

adaptiveExtinction(Ages, Confidence = 0.95)
}
\arguments{
\item{Ages}{a numeric vector of fossil occurrence ages, expressed as millions of years ago.}

\item{Confidence}{the desired confidence level}
}
\value{
A matrix listing the oldest or youngest observed fossil occurrence, the best inferred age of extinction or origination, and the upper confidence limit.
}
\description{
Functions for placing confidence intervals on time of orignation or extinction using the Adaptive Beta Method.
}
\details{
Takes a numeric vector of fossil occurrence ages, expressed as millions of years ago, to estimate either the time of origination \code{adaptiveOrigination} or extinction \code{adaptiveExtinction}.
This code was originally presented in Wang et al. (2015) "Adaptive credible intervals on stratigraphic ranges when recovery potential is unknown". \emph{Paleobiology} 42:240256. This simplified version
 will only accept ages in millions of years. The full version can be found in the online supplement to the paper.

Note that this function will not accept more than 161 age observations. This is a limitation of the original function.
}
\examples{
# Generate an exmaple dataset of fossil ages
FakeAges<-runif(50,50,100)

# Calculate the inferred age of extinction with 95\% confidence.
adaptiveExtinction(FakeAges,Confidence=0.95)

# Calculate the inferred age of origination with 50\% confidence.
adaptiveOrigination(FakeAges,Confidence=0.5)

}
\author{
Andrew A. Zaffos
}

