% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spv.R, R/spv.data.frame.R, R/spv.list.R,
%   R/spv.matrix.R
\name{spv}
\alias{spv}
\alias{spv.data.frame}
\alias{spv.list}
\alias{spv.matrix}
\title{Calculate the Scaled Prediction Variance (or SPV)}
\usage{
spv(
  n,
  design,
  type = "spherical",
  formula,
  at = FALSE,
  keepfun,
  sample,
  unscaled = FALSE,
  ...
)

\method{spv}{data.frame}(
  n,
  design,
  type = c("spherical", "cuboidal", "lhs", "mlhs", "slhs", "rslhs", "custom"),
  formula,
  at = FALSE,
  keepfun,
  sample,
  unscaled = FALSE,
  ...
)

\method{spv}{list}(
  n,
  design,
  type = c("spherical", "cuboidal", "lhs", "mlhs", "slhs", "rslhs", "custom"),
  formula,
  at = FALSE,
  keepfun,
  sample,
  unscaled = FALSE,
  ...
)

\method{spv}{matrix}(
  n,
  design,
  type = c("spherical", "cuboidal", "lhs", "mlhs", "slhs", "rslhs", "custom"),
  formula,
  at = FALSE,
  keepfun,
  sample,
  unscaled = FALSE,
  ...
)
}
\arguments{
\item{n}{number of samples to take}

\item{design}{a design or list of designs. Each design must be either a matrix or a data.frame or coercible to a data.frame.}

\item{type}{type of sampling passed to \code{\link{sampler}}}

\item{formula}{either a single model formula of a list of formulae}

\item{at}{only used when type is \code{'spherical'} or \code{'cuboidal'}}

\item{keepfun}{optional; function operating on the columns of a matrix with the same number of columns as design which return a logical value for 
including a specific point in the sample or not. Useful for rejection sampling for nonstandard design regions.}

\item{sample}{optional; if not missing it should contain a matrix or data.frame containing points sampled over the required design region. If it is not 
missing, no further sampling will be done: the SPV is simply evaluated at these points.}

\item{unscaled}{logical indicating whether to use the unscaled prediction variance (UPV) instead of the scale prediction variance (SPV)}

\item{\dots}{additional arguments passed to \code{\link{sampler}}. This enables the used of 
user-specified sampling functions via the \code{custom.fun} argument to \code{\link{sampler}}.}
}
\value{
Object of class 'spv', 'spvlist', 'spvforlist' or 'spvlistforlist', depending on whether single designs/formulas
are passed or lists of these.
}
\description{
Calculates the SPV for a sample of points in a design region of specified type. Sampling is done
by calling \code{\link{sampler}}.
}
\examples{

# Single design (class 'spv')
library(rsm)
bbd3 <- as.data.frame(bbd(3)[,3:5])
colnames(bbd3) <- paste0("x", 1:3)
quad.3f <- formula(~(x1 + x2 + x3)^2 - x1:x2:x3)
out <- spv(n = 1000, design = bbd3, type = "spherical", formula = quad.3f)
out
}
\references{
Pieter C. Schoonees, Niel J. le Roux, Roelof L.J. Coetzer (2016). Flexible Graphical Assessment of 
Experimental Designs in R: The vdg Package. \emph{Journal of Statistical Software}, 74(3), 1-22. 
\doi{10.18637/jss.v074.i03}.
}
\seealso{
\code{\link{plot.spv}} for more examples
}
\author{
Pieter C. Schoonees
}
\keyword{multivariate}
