% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_model.R
\name{meta.lm.cor.gen}
\alias{meta.lm.cor.gen}
\title{Meta-regression analysis for correlations}
\usage{
meta.lm.cor.gen(alpha, cor, se, X)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{cor}{vector of estimated correlations}

\item{se}{number of control variables}

\item{X}{matrix of predictor values}
}
\value{
Returns a matrix.  The first row is for the intercept with one additional
row per predictor.  The matrix has the following columns:
\itemize{
\item Estimate - OLS estimate
\item SE - standard error
\item z - z-value
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
This function estimates the intercept and slope coefficients in a
meta-regression model where the dependent variable is a
Fisher-transformed correlation. The correlations can be of different types
(e.g., Pearson, partial, Spearman). The estimates are OLS estimates
with robust standard errors that accommodate residual heteroscedasticity.
This function uses estimated correlations and their standard errors as
input. The correlations are Fisher-transformed and hence the parameter
estimates do not have a simple interpretation. However, the hypothesis
test results can be used to decide if a population slope is either
positive or negative.
}
\examples{

cor <- c(.40, .65, .60, .45)
se <- c(.182, .114, .098, .132)
x1 <- c(18, 25, 23, 19)
X <- matrix(x1, 4, 1)
meta.lm.cor.gen(.05, cor, se, X)

# Should return: 
#       Estimate         SE          z     p
# b0 -0.47832153 0.63427931 -0.7541181 0.451
# b1  0.05047154 0.02879859  1.7525699 0.080


}
