% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_ave.R
\name{meta.ave.gen.rc}
\alias{meta.ave.gen.rc}
\title{Confidence interval for an average effect size using a random coefficient
model}
\usage{
meta.ave.gen.rc(alpha, est, se, bystudy = TRUE)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{est}{vector of parameter estimates}

\item{se}{vector of standard errors}

\item{bystudy}{logical to also return each study estimate (TRUE) or not}
}
\value{
Returns a matrix.  The first row is the average estimate across all studies.  If bystudy
is true, there is 1 additional row for each study.  The matrix has the following columns:
\itemize{
\item Estimate - the estimated effect size
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for a
a weighted average effect from multiple studies using the random
coefficient (random-effects) meta-analysis model. An estimate of
effect-sze heterogeneity (tau-squared) is also computed. The random
coefficient model assumes that the studies in the meta-analysis are
a random sample from some definable superpopulation of studies. This
assumption is very difficult to justify. The weighted average
estimate will be biased regardless of number of studies or sample size
per study and the actual confidence interval coverage probability can
much smaller than the specified confidence level if the effect sizes are
correlated with the weights. This method also assume that the true effects
sizes in the superpopulation of studies have a normal distribution. A large
number of studies, each with a large sample size, is required to assess the
superpopulation normality assumption and to accurately estimate tau-squared.
The traditional confidence interval for the population tau-squared is
hypersensitive to very minor and difficult to detect violations of the
superpopulation normality assumption.
}
\examples{
est <- c(.022, .751, .421, .287, .052, .146, .562, .904)
se <- c(.124, .464, .102, .592, .864, .241, .252, .318)
meta.ave.gen.rc(.05, est, se, bystudy = TRUE)

# Should return: 
#               Estimate        SE          LL        UL
# Tau-squared 0.03772628 0.0518109  0.00000000 0.1392738
# Average     0.35394806 0.1155239  0.12752528 0.5803708
# Study 1     0.02200000 0.1240000 -0.22103553 0.2650355
# Study 2     0.75100000 0.4640000 -0.15842329 1.6604233
# Study 3     0.42100000 0.1020000  0.22108367 0.6209163
# Study 4     0.28700000 0.5920000 -0.87329868 1.4472987
# Study 5     0.05200000 0.8640000 -1.64140888 1.7454089
# Study 6     0.14600000 0.2410000 -0.32635132 0.6183513
# Study 7     0.56200000 0.2520000  0.06808908 1.0559109
# Study 8     0.90400000 0.3180000  0.28073145 1.5272685

}
\references{
\itemize{
\item \insertRef{Hedges1985}{vcmeta}
\item \insertRef{Borenstein2009}{vcmeta}
}
}
