% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proc_chromR.R
\name{Process chromR objects}
\alias{Process chromR objects}
\alias{proc.chromR}
\alias{regex.win}
\alias{seq2rects}
\alias{var.win}
\alias{gt2popsum}
\alias{gt.to.popsum}
\title{Process chromR object}
\usage{
proc.chromR(x, win.size = 1000, verbose = TRUE)

regex.win(x, max.win = 1000, regex = "[acgtwsmkrybdhv]")

seq2rects(x, chars = "acgtwsmkrybdhv", lower = TRUE)

var.win(x, win.size = 1000)

gt2popsum(x)

gt.to.popsum(x)
}
\arguments{
\item{x}{object of class chromR}

\item{win.size}{integer indicating size for windowing processes}

\item{verbose}{logical indicating whether verbose output should be reported}

\item{max.win}{maximum window size}

\item{regex}{a regular expression to indicate nucleotides to be searched for}

\item{chars}{a vector of characters to be used as a database for inclusion in rectangles}

\item{lower}{converts the sequence and database to lower case, making the search case insensitive}

\item{...}{arguments to be passed to methods}
}
\description{
Functions which process chromR objects

Create representation of a sequence.
Begining and end points are determined for stretches of nucleotides.
Stretches are determined by querying each nucleotides in a sequence to determine if it is represented in the database of characters (chars).
}
\details{
The function \strong{proc_chromR()} calls helper functions to process the data present in a chromR object into summaries statistics.

The function \strong{regex.win()} is used to generate coordinates to define rectangles to represent regions of the chromosome containing called nucleotides (acgtwsmkrybdhv).
It is then called a second time to generate coordinates to define rectangles to represent regions called as uncalled nucleotides (n, but not gaps).

The function \strong{gt2popsum} is called to create summaries of the variant data.

The function \strong{var.win} is called to create windowized summaries of the chromR object.

Each \strong{window} receives a \strong{name} and its coordinates.
Several attempts are made to name the windows appropriately.
First, the CHROM column of vcfR@fix is queried for a name.
Next, the label of the sequence is queried for a name.
Next, the first cell of the annotation matrix is queried.
If an appropriate name was not found in the above locations the chromR object's 'name' slot is used.
Note that the 'name' slot has a default value.
If this default value is not updated then all of your windows may receive the same name.
}
