% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dina_vb.R
\name{dina}
\alias{dina}
\title{for the deterministic input noisy AND gate (DINA) model.}
\usage{
dina(
  X,
  Q,
  max_it = 500,
  epsilon = 1e-04,
  verbose = TRUE,
  delta_0 = NULL,
  alpha_s = NULL,
  beta_s = NULL,
  alpha_g = NULL,
  beta_g = NULL
)
}
\arguments{
\item{X}{I by J binary matrix, item response data}

\item{Q}{J by K binary matrix, Q-matrix}

\item{max_it}{the maximum number of iterations (default: 500)}

\item{epsilon}{the convergence tolerance for iterations (default: 1e-4)}

\item{verbose}{Logical, controls whether to print progress (default: TRUE)}

\item{delta_0}{L by 1 vector, hyperparameter of prior dirichlet distribution
for the class mixing parameter \eqn{\pi} (default: NULL).}

\item{alpha_s}{A positive scalar, hyperparameter that determines the
shape of  prior beta distribution for slip parameter (default: NULL).}

\item{beta_s}{A positive scalar, hyperparameter that determines the
shape of  prior beta distribution for slip parameter (default: NULL).}

\item{alpha_g}{A positive scalar, hyperparameter that determines the
shape of  prior beta distribution for guessing parameter (default: NULL).}

\item{beta_g}{A positive scalar, hyperparameter that determines the
shape of  prior beta distribution for guessing parameter (default: NULL).}
}
\value{
A list including:
\describe{
  \item{s_est}{the posterior mean of slip parameter.}
  \item{g_est}{the posterior mean of guessing parameter.}
  \item{s_sd}{the posterior standard diviation of slip parameter.}
  \item{g_sd}{the posterior standard diviation of guessing parameter.}
  \item{alpha_s_ast}{the estimates of variational parameter for slip parameter}
  \item{beta_s_ast}{the estimates of variational parameter for slip parameter}
  \item{alpha_g_ast}{the estimates of variational parameter for guessing parameter}
  \item{beta_g_ast}{the estimates of variational parameter for guessing parameter}
  \item{pi_est}{the estimates of class mixing parameter \eqn{\pi}}
  \item{delta_ast}{the estimates of variational parameter \eqn{\delta^*}}
  \item{delta_sd}{the standard diviation of variational parameter \eqn{\delta^*}}
  \item{l_lb}{the list of the values of evidence lower bound in each itertion}
  \item{att_pat_est}{the estimated attribute mastery patterns}
  \item{eta_lj}{the computed ideal responce}
  \item{m}{the number of performed iterations}
}
}
\description{
\code{dina()} returns variational Bayesian estimates for the DINA model.
}
\examples{
# load Q-matrix and create artificial item response data
Q = sim_Q_J80K5
sim_data = dina_data_gen(Q=Q,I=200)
# fit DINO model
res_dina = dina(X=sim_data$X, Q=Q)

}
\references{
Yamaguchi, K., & Okada, K. (2020). Variational Bayes inference
  for the DINA model. \emph{Journal of Educational and Behavioral
  Statistics}, 45(5), 569-597. \doi{10.3102/1076998620911934}
}
