\name{vardom_othstr}
\alias{vardom_othstr}

\title{Variance estimation for sample surveys in domain by the two stratification}

\description{Computes the variance estimation for sample surveys in domain by the two stratification.}

\usage{vardom_othstr(Y, H, H2, PSU, w_final, id=NULL,
       Dom = NULL, period=NULL, N_h = NULL,
       N_h2, Z = NULL,
       X = NULL, g = NULL, q = NULL, dataset = NULL, 
       confidence = .95,  outp_lin=FALSE, outp_res=FALSE)}

\arguments{

\item{Y}{Variables of interest. Object convertible to \code{data.table} or variable names as character, column numbers.}

\item{H}{The unit stratum variable. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{H2}{The unit new stratum variable. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{PSU}{Primary sampling unit variable. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{w_final}{Weight variable. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{id}{Optional variable for unit ID codes. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{Dom}{Optional variables used to define population domains. If supplied, linearization of the at-risk-of-poverty rate is done for each domain. An object convertible to \code{data.table} or variable names as character vector, column numbers.}

\item{period}{Optional variable for survey period. If supplied, residual estimation of calibration is done independently for each time period. One dimensional object convertible to one-column \code{data.table}.}

\item{N_h}{optional; either a \code{data.table} giving the first column - stratum, but the second column - the total of the population in each stratum.}

\item{N_h2}{optional; either a \code{data.frame} giving the first column - new stratum, but the second column - the total of the population in each new stratum.}

\item{Z}{optional variables of denominator for ratio estimation. Object convertible to \code{data.table} or variable names as character, column numbers.}

\item{X}{Optional matrix of the auxiliary variables for the calibration estimator. Object convertible to \code{data.table} or variable names as character, column numbers.}

\item{g}{Optional variable of the g weights. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{q}{Variable of the positive values accounting for heteroscedasticity. One dimensional object convertible to one-column \code{data.table} or variable name as character, column number.}

\item{dataset}{Optional survey data object convertible to \code{data.table}.}

\item{confidence}{Optional positive value for confidence interval. This variable by default is 0.95.}

\item{outp_lin}{Logical value. If \code{TRUE} linearized values of the ratio estimator will be printed out.}

\item{outp_res}{Logical value. If \code{TRUE} estimated residuals of calibration will be printed out.}

}

\value{

  A list with objects are returned by the function:

  \item{lin_out}{A \code{data.table} containing the linearized values of the ratio estimator with id and PSU.}

  \item{res_out}{A \code{data.table} containing the estimated residuals of calibration with id and PSU.}

  \item{s2g}{A \code{data.table} containing the s^2g value.}

  \item{all_result}{A \code{data.table}, which containing variables:

       \code{respondent_count} - the count of respondents, \cr
       \code{pop_size} - the estimated size of population, \cr
       \code{n_nonzero} - the count of respondents, who answers are larger than zero, \cr
       \code{estim} - the estimated value, \cr
       \code{var} - the estimated variance, \cr
       \code{se} - the estimated standard error, \cr
       \code{rse} - the estimated relative standard error (coefficient of variation), \cr
       \code{cv} - the estimated relative standard error (coefficient of variation) in percentage, \cr
       \code{absolute_margin_of_error} - the estimated absolute margin of error, \cr
       \code{relative_margin_of_error} - the estimated relative margin of error, \cr
       \code{CI_lower} - the estimated confidence interval lower bound, \cr
       \code{CI_upper} - the estimated confidence interval upper bound, \cr
       \code{var_srs_HT} - the estimated variance of the HT estimator under SRS, \cr
       \code{var_cur_HT} - the estimated variance of the HT estimator under current design, \cr
       \code{var_srs_ca} - the estimated variance of the calibrated estimator under SRS, \cr
       \code{deff_sam} - the estimated design effect of sample design, \cr
       \code{deff_est} - the estimated design effect of estimator, \cr
       \code{deff} - the overall estimated design effect of sample design and estimator, \cr
       \code{n_eff} - the effective sample size.}

}

\references{
  Jean-Claude Deville (1999). Variance estimation for complex statistics
  and estimators: linearization and residual techniques. Survey
  Methodology, 25, 193-203,
  URL \url{http://www5.statcan.gc.ca/bsolc/olc-cel/olc-cel?lang=eng&catno=12-001-X19990024882}. \cr

  M. Liberts. (2004) Non-response Analysis and Bias Estimation in a Survey on Transportation of Goods by Road.  \cr
}

\examples{

data(eusilc)

# Example 1
eusilc1 <- eusilc[1:1000, ]
dataset <- data.table(IDd=1:nrow(eusilc1), eusilc1)
N_h2 <- dataset[, sum(rb050, na.rm = FALSE), keyby="db040"]

aa<-vardom_othstr(Y="eqIncome", H="db040",H2="db040", PSU="db030", w_final="rb050",
           id="rb030", Dom = "db040", period=NULL, N_h=NULL, N_h2=N_h2, Z = NULL,
           X=NULL, g=NULL, q=NULL, dataset=dataset,           
           confidence = .95, outp_lin=TRUE, outp_res=TRUE)


\dontrun{
# Example 2
dataset <- data.table(IDd=1:nrow(eusilc), eusilc)
N_h2 <- dataset[, sum(rb050, na.rm = FALSE), keyby="db040"]

aa<-vardom_othstr(Y="eqIncome", H="db040",H2="db040", PSU="db030", w_final="rb050",
           id="rb030", Dom = "db040", period=NULL, N_h=NULL, N_h2=N_h2, Z = NULL,
           X = NULL, g = NULL, dataset = dataset,
           q = rep(1, if (is.null(dataset)) 
                       nrow(as.data.frame(H)) else nrow(dataset)),
           confidence = .95, outp_lin=TRUE, outp_res=TRUE)
}

}
\seealso{
\code{\link{domain}},   \code{\link{lin.ratio}},  \code{\link{residual_est}},
\code{\link{vardomh}},  \code{\link{var_srs}},    \code{\link{variance_est}},
\code{\link{variance_othstr}}}
\keyword{vardpoor}
