% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_genome.r
\name{bound_intervals}
\alias{bound_intervals}
\title{Select intervals bounded by a genome.}
\usage{
bound_intervals(x, genome, trim = FALSE)
}
\arguments{
\item{x}{a tbl of intervals}

\item{genome}{a tbl of chrom sizes}

\item{trim}{adjust coordinates for out-of-bounds intervals}
}
\value{
\code{data_frame}
}
\description{
Select intervals bounded by a genome.
}
\examples{
x <- tibble::tribble(
 ~chrom, ~start, ~end,
 "chr1", -100,   500,
 "chr1", 100,    1e9,
 "chr1", 500,    1000
)

genome <- read_genome(valr_example('hg19.chrom.sizes.gz'))

# out-of-bounds are removed by default 
bound_intervals(x, genome)

# out-of-bounds intervals can be trimmed with trim = TRUE  
bound_intervals(x, genome, trim = TRUE)

}

