% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_merge.r
\name{bed_merge}
\alias{bed_merge}
\title{Merge overlapping intervals.}
\usage{
bed_merge(x, max_dist = 0, ...)
}
\arguments{
\item{x}{tbl of intervals}

\item{max_dist}{maximum distance between intervals to merge}

\item{...}{name-value pairs that specify operations on merged intervals}
}
\value{
\code{data_frame}
}
\description{
Operations can be performed on merged intervals by specifying name-value
pairs.
}
\details{
input tbls can be grouped using \code{\link[dplyr]{group_by}} prior to 
  analysis. Input tbls are grouped by \code{chrom} by default. Grouping by 
  \code{strand} will constrain analyses to the same strand. To compare 
  opposing strands between two tbls, strands on the \code{y} tbl can first be
  be inverted using \code{\link{flip_strands}}.
}
\examples{
x <- tibble::tribble(
  ~chrom, ~start, ~end,
  'chr1',  1,      50,
  'chr1',  10,     75,
  'chr1',  100,    120
)

bed_glyph(bed_merge(x))

x <- tibble::tribble(
 ~chrom, ~start, ~end, ~value, ~strand,
 "chr1", 1,      50,   1,      '+',
 "chr1", 100,    200,  2,      '+',
 "chr1", 150,    250,  3,      '-',
 "chr2", 1,      25,   4,      '+',
 "chr2", 200,    400,  5,      '-',
 "chr2", 400,    500,  6,      '+',
 "chr2", 450,    550,  7,      '+'
)

bed_merge(x)

bed_merge(x, max_dist = 100)

# merge intervals on same strand
bed_merge(dplyr::group_by(x, strand))

bed_merge(x, .value = sum(value))

}
\seealso{
\url{http://bedtools.readthedocs.org/en/latest/content/tools/merge.html}

Other single-set-ops: \code{\link{bed_cluster}},
  \code{\link{bed_complement}}, \code{\link{bed_flank}},
  \code{\link{bed_random}}, \code{\link{bed_shift}},
  \code{\link{bed_shuffle}}, \code{\link{bed_slop}}
}

