% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{process_result}
\alias{process_result}
\title{Process a set of ValidMind results into parseable data}
\usage{
process_result(results)
}
\arguments{
\item{results}{A list of ValidMind result objects}
}
\value{
A nested list of ValidMind results (dataframes, plotly plots, and
matplotlib plots)
}
\description{
Process a set of ValidMind results into parseable data
}
\examples{
\dontrun{
vm_dataset = vm_r$init_dataset(
  dataset=data,
  target_column="Exited",
  class_labels=list("0" = "Did not exit", "1" = "Exited")
)

tabular_suite_results <- vm_r$run_test_suite("tabular_dataset", dataset=vm_dataset)

processed_results <- process_result(tabular_suite_results)
processed_results
}

}
