% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_validation.R
\name{run_validation_file}
\alias{run_validation_file}
\alias{run_validation_dir}
\alias{print.validations}
\alias{summary.validations}
\title{Run a file with confrontations. Capture results}
\usage{
run_validation_file(file, verbose = TRUE)

run_validation_dir(dir = "./", pattern = "^validate.+[rR]", verbose = TRUE)

\method{print}{validations}(x, ...)

\method{summary}{validations}(object, ...)
}
\arguments{
\item{file}{\code{[character]} location of an R file.}

\item{verbose}{\code{[logical]} toggle verbose output.}

\item{dir}{\code{[character]} path to directory.}

\item{pattern}{\code{[characer]} regular expression that selects validation files to run.}

\item{x}{An R object}

\item{...}{Unused}

\item{object}{An R object}
}
\value{
\code{run_validation_file}: An object of class \code{validations}. This is 
  a \code{list} of objects of class \code{\link{validation}}.

\code{run_validation_dir}: An object of class \code{validations}. This is 
  a \code{list} of objects of class \code{\link{validation}}.

\code{print}: \code{NULL}, invisibly.

\code{summary}: A data frame similar to the data frame returned
  when summarizing a \code{\link{validation}} object. There are extra columns listing
  each call, file and first and last line where the code occurred.
}
\description{
A validation script is a regular R script, intersperced with \code{confront}
or \code{check_that} statements. This function will run the script file 
and capture all output from calls to these functions.
}
\concept{validation validation-files}
\concept{validations validation-files}
