% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{cells}
\alias{cells}
\title{Cell counts and differences for a series of datasets}
\usage{
cells(..., .list = NULL, compare = c("to_first", "sequential"))
}
\arguments{
\item{...}{A (named) sequence of R objects carrying data (\emph{e.g.} \code{data.frame}s)}

\item{.list}{A list of R objects carrying data; will be concatenated with objects in \code{...}}

\item{compare}{How to compare the datasets.}
}
\value{
An object of class \code{cellComparison}, which is really an array 
  with a few attributes. It counts the total number of cells, the number of 
  missings, the number of altered values and changes therein as compared to 
  the reference defined in \code{how}.
}
\description{
Cell counts and differences for a series of datasets
}
\section{Details}{

This function assumes that the datasets have the same dimensions and that both
rows and columns are ordered similarly.
}
\examples{
data(retailers)

# start with raw data
step0 <- retailers

# impute turnovers
step1 <- step0
step1$turnover[is.na(step1$turnover)] <- mean(step1$turnover,na.rm=TRUE)

# flip sign of negative revenues
step2 <- step1
step2$other.rev <- abs(step2$other.rev)
  
# create an overview of differences compared to raw data
cells(raw = step0, imputed = step1, flipped = step2)

# create an overview of differences, comparing to the previous step
cells(raw = step0, imputed = step1, flipped = step2, compare="sequential")

}
\seealso{
\itemize{
 \item{\code{\link{compare}}} 
 \item{\code{\link{match_cells}}}
}
}

