% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSeriesInfo.R
\name{getSeriesInfo}
\alias{getSeriesInfo}
\title{Retrieves series information}
\usage{
getSeriesInfo(patternGroupLabel = NULL, patternSeriesLabel = NULL, ...)
}
\arguments{
\item{patternGroupLabel}{character string as regular expression. Only accepts character string or \code{NULL} (default).
If length is greater than 1, the first element is used. \code{patternGroupLabel=NULL} retrieves the details for all groups in the
API.}

\item{patternSeriesLabel}{character string as regular expression. Only accepts character string or \code{NULL} (default).
If length is greater than 1, the first element is used. If \code{NULL}, no pattern-matching is executed on the series' label.}

\item{...}{accepts the follwing extra arguments from \code{\link[base]{grep}}: \code{ignore.case}, \code{perl}, \code{fixed} and
\code{useBytes}.}
}
\value{
An \eqn{n x 6} \code{data.frame} with columns representing the different characteristic of a series.
}
\description{
Exploratory function (albeit more complete than \code{\link{regexSeriesLabel}}). The pattern arguments searches for information on
series based on their group label and series label. A \code{data.frame} is returned with the series' group name, group label, group
description, series label, series link and series name. This function utilizes the "Series Group" route in the Valet API and provides
the full set of information available to a series. The series' link (or name) can be used in the function \code{\link{getSeriesData}}
to fecth data.
}
\details{
The \code{data.frame} returned from this function contains all information available in the
\href{https://www.bankofcanada.ca/valet/docs#series_groups}{Series Group} router in the Valet API. This function is more complete than
\code{regexSeriesLabel}. \code{getSeriesInfo} returns not only the series label and link (also available in \code{regexSeriesLabel}) but
also a series' group name, group label, group description and series name.

    If \code{patternGroupLabel} is \code{NULL}, then the function will retrieve information for all groups (and their associated series).
    This results in a longer processing time. A progress bar tracks the retrieval process.
}
\examples{

# returns series info
\donttest{

seriesInfo <- getSeriesInfo(patternGroupLabel="(?i)consumer price",
                            patternSeriesLabel="(?i)seasonally")
}
}
\seealso{
\code{\link{getSeriesInfo}}, \code{\link[base]{grep}}
}
