% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{params_ce_cox}
\alias{params_ce_cox}
\title{Set parameters controlling Cox model estimation of controlled effect curves}
\usage{
params_ce_cox(spline_df = NA, spline_knots = NA, edge_ind = FALSE)
}
\arguments{
\item{spline_df}{An integer; if the marker is modeled flexibly within the Cox
model linear predictor as a natural cubic spline, this option controls
the degrees of freedom in the spline; knots are chosen to be equally
spaced across the range of the marker.}

\item{spline_knots}{A numeric vector; as an alternative to specifying
\code{spline_df}, the exact locations of the knots in the spline
(including boundary knots) can be specified with this option.}

\item{edge_ind}{Boolean. If TRUE, an indicator variable corresponding to the
lower limit of the marker will be included in the Cox model linear
predictor.}
}
\value{
A list of options.
}
\description{
This should be used in conjunction with \code{\link{est_ce}} to
    set parameters controlling Cox model estimation of controlled effect
    curves; see examples.
}
\examples{
data(hvtn505)
dat <- load_data(time="HIVwk28preunblfu", event="HIVwk28preunbl", vacc="trt",
                 marker="IgG_V2", covariates=c("age","BMI","bhvrisk"),
                 weights="wt", ph2="casecontrol", data=hvtn505)
\donttest{
ests_cox <- est_ce(
  dat = dat,
  type = "Cox",
  t_0 = 578,
  params_cox = params_ce_cox(spline_df=4)
)
}
}
