% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_tuneGrid.R
\name{tune_grid}
\alias{tune_grid}
\title{Estimate the forecast accuracy of a model on a time series according to a grid
of parameters}
\usage{
tune_grid(
  model,
  h,
  tuneGrid,
  type = c("normal", "minimum"),
  size = NULL,
  prop = NULL
)
}
\arguments{
\item{model}{An object of class \code{utsf} with a model trained with a time
series.}

\item{h}{A positive integer. The forecasting horizon.}

\item{tuneGrid}{A data frame with possible tuning values. The columns are
named as the tuning parameters.}

\item{type}{A string. Possible values are \code{"normal"} (the default) and
\code{"minimum"}. See the vignette \link{utsf} for an explanation of both ways
of evaluating forecast accuracy.}

\item{size}{An integer. It is the size of the test set (how many of the last
observations of the time series are used as test set). It can only be used
when the type parameter is \code{"normal"}. By default, it is the length of the
forecasting horizon.}

\item{prop}{A numeric value in the range (0, 1). It is the proportion of the
time series used as test set. It can only be used when the type parameter is
\code{"normal"}.}
}
\value{
A list with three components: \item{\code{tuneGrid}}{A data frame with the
different combination of parameters and the estimated forecast accuracy of a
model trained with those parameters.} \item{\code{best}}{The best combination of
parameters according to root mean squared error.} \item{\code{forecast}}{An
object of class \code{utsf_forecast} with the forecast for horizon \code{h} using the
best estimated combination of parameters.}
}
\description{
It uses an object of class \code{utsf} to asses the forecasting accuracy of its
associated model on its associated time series applying rolling origin
evaluation according to different configurations of model parameters.
}
\details{
The estimation of forecast accuracy is done with the \code{\link[=efa]{efa()}} function. The
best combination of parameters is used to train the model with all the
historical values of the time series and forecast \code{h} values ahead.
}
\examples{
m <- create_model(UKgas, lags = 1:4, method = "knn")
tune_grid(m, h = 4, tuneGrid = expand.grid(k = 1:7), type = "normal", size = 8)
}
